// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * An object that can be used to specify Tag conditions inside the `SearchFilter`. This accepts an `OR` of `AND` (List of List) input where:
 * + Top level list specifies conditions that need to be applied with `OR` operator
 * + Inner list specifies conditions that need to be applied with `AND` operator.
 */
class ControlPlaneTagFilter private constructor(builder: Builder) {
    /**
     * A list of conditions which would be applied together with an `AND` condition.
     */
    val andConditions: List<TagCondition>? = builder.andConditions
    /**
     * A list of conditions which would be applied together with an `OR` condition.
     */
    val orConditions: List<List<TagCondition>>? = builder.orConditions
    /**
     * A leaf node condition which can be used to specify a tag condition.
     */
    val tagCondition: aws.sdk.kotlin.services.connect.model.TagCondition? = builder.tagCondition

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ControlPlaneTagFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ControlPlaneTagFilter(")
        append("andConditions=$andConditions,")
        append("orConditions=$orConditions,")
        append("tagCondition=$tagCondition)")
    }

    override fun hashCode(): kotlin.Int {
        var result = andConditions?.hashCode() ?: 0
        result = 31 * result + (orConditions?.hashCode() ?: 0)
        result = 31 * result + (tagCondition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ControlPlaneTagFilter

        if (andConditions != other.andConditions) return false
        if (orConditions != other.orConditions) return false
        if (tagCondition != other.tagCondition) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ControlPlaneTagFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of conditions which would be applied together with an `AND` condition.
         */
        var andConditions: List<TagCondition>? = null
        /**
         * A list of conditions which would be applied together with an `OR` condition.
         */
        var orConditions: List<List<TagCondition>>? = null
        /**
         * A leaf node condition which can be used to specify a tag condition.
         */
        var tagCondition: aws.sdk.kotlin.services.connect.model.TagCondition? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ControlPlaneTagFilter) : this() {
            this.andConditions = x.andConditions
            this.orConditions = x.orConditions
            this.tagCondition = x.tagCondition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ControlPlaneTagFilter = ControlPlaneTagFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.TagCondition] inside the given [block]
         */
        fun tagCondition(block: aws.sdk.kotlin.services.connect.model.TagCondition.Builder.() -> kotlin.Unit) {
            this.tagCondition = aws.sdk.kotlin.services.connect.model.TagCondition.invoke(block)
        }
    }
}
