// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



class CreateTaskTemplateRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * Constraints that are applicable to the fields listed.
     */
    val constraints: aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints? = builder.constraints
    /**
     * The identifier of the flow that runs by default when a task is created by referencing this template.
     */
    val contactFlowId: kotlin.String? = builder.contactFlowId
    /**
     * The default values for fields when a task is created by referencing this template.
     */
    val defaults: aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults? = builder.defaults
    /**
     * The description of the task template.
     */
    val description: kotlin.String? = builder.description
    /**
     * Fields that are part of the template.
     */
    val fields: List<TaskTemplateField>? = builder.fields
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    val instanceId: kotlin.String? = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The name of the task template.
     */
    val name: kotlin.String? = builder.name
    /**
     * Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it. Tasks can only be created from `ACTIVE` templates. If a template is marked as `INACTIVE`, then a task that refers to this template cannot be created.
     */
    val status: aws.sdk.kotlin.services.connect.model.TaskTemplateStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateTaskTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTaskTemplateRequest(")
        append("clientToken=$clientToken,")
        append("constraints=$constraints,")
        append("contactFlowId=$contactFlowId,")
        append("defaults=$defaults,")
        append("description=$description,")
        append("fields=$fields,")
        append("instanceId=$instanceId,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (constraints?.hashCode() ?: 0)
        result = 31 * result + (contactFlowId?.hashCode() ?: 0)
        result = 31 * result + (defaults?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fields?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTaskTemplateRequest

        if (clientToken != other.clientToken) return false
        if (constraints != other.constraints) return false
        if (contactFlowId != other.contactFlowId) return false
        if (defaults != other.defaults) return false
        if (description != other.description) return false
        if (fields != other.fields) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateTaskTemplateRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        var clientToken: kotlin.String? = null
        /**
         * Constraints that are applicable to the fields listed.
         */
        var constraints: aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints? = null
        /**
         * The identifier of the flow that runs by default when a task is created by referencing this template.
         */
        var contactFlowId: kotlin.String? = null
        /**
         * The default values for fields when a task is created by referencing this template.
         */
        var defaults: aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults? = null
        /**
         * The description of the task template.
         */
        var description: kotlin.String? = null
        /**
         * Fields that are part of the template.
         */
        var fields: List<TaskTemplateField>? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        var instanceId: kotlin.String? = null
        /**
         * The name of the task template.
         */
        var name: kotlin.String? = null
        /**
         * Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it. Tasks can only be created from `ACTIVE` templates. If a template is marked as `INACTIVE`, then a task that refers to this template cannot be created.
         */
        var status: aws.sdk.kotlin.services.connect.model.TaskTemplateStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateTaskTemplateRequest) : this() {
            this.clientToken = x.clientToken
            this.constraints = x.constraints
            this.contactFlowId = x.contactFlowId
            this.defaults = x.defaults
            this.description = x.description
            this.fields = x.fields
            this.instanceId = x.instanceId
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateTaskTemplateRequest = CreateTaskTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints] inside the given [block]
         */
        fun constraints(block: aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints.Builder.() -> kotlin.Unit) {
            this.constraints = aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults] inside the given [block]
         */
        fun defaults(block: aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults.Builder.() -> kotlin.Unit) {
            this.defaults = aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults.invoke(block)
        }
    }
}
