// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains credentials to use for federation.
 */
class Credentials private constructor(builder: Builder) {
    /**
     * An access token generated for a federated user to access Amazon Connect.
     */
    val accessToken: kotlin.String? = builder.accessToken
    /**
     * A token generated with an expiration time for the session a user is logged in to Amazon Connect.
     */
    val accessTokenExpiration: aws.smithy.kotlin.runtime.time.Instant? = builder.accessTokenExpiration
    /**
     * Renews a token generated for a user to access the Amazon Connect instance.
     */
    val refreshToken: kotlin.String? = builder.refreshToken
    /**
     * Renews the expiration timer for a generated token.
     */
    val refreshTokenExpiration: aws.smithy.kotlin.runtime.time.Instant? = builder.refreshTokenExpiration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.Credentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Credentials(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("accessTokenExpiration=$accessTokenExpiration,")
        append("refreshToken=*** Sensitive Data Redacted ***,")
        append("refreshTokenExpiration=$refreshTokenExpiration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (accessTokenExpiration?.hashCode() ?: 0)
        result = 31 * result + (refreshToken?.hashCode() ?: 0)
        result = 31 * result + (refreshTokenExpiration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Credentials

        if (accessToken != other.accessToken) return false
        if (accessTokenExpiration != other.accessTokenExpiration) return false
        if (refreshToken != other.refreshToken) return false
        if (refreshTokenExpiration != other.refreshTokenExpiration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.Credentials = Builder(this).apply(block).build()

    class Builder {
        /**
         * An access token generated for a federated user to access Amazon Connect.
         */
        var accessToken: kotlin.String? = null
        /**
         * A token generated with an expiration time for the session a user is logged in to Amazon Connect.
         */
        var accessTokenExpiration: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Renews a token generated for a user to access the Amazon Connect instance.
         */
        var refreshToken: kotlin.String? = null
        /**
         * Renews the expiration timer for a generated token.
         */
        var refreshTokenExpiration: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.Credentials) : this() {
            this.accessToken = x.accessToken
            this.accessTokenExpiration = x.accessTokenExpiration
            this.refreshToken = x.refreshToken
            this.refreshTokenExpiration = x.refreshTokenExpiration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.Credentials = Credentials(this)
    }
}
