// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



class ListQuickConnectsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    val instanceId: kotlin.String? = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The maximum number of results to return per page.
     */
    val maxResults: kotlin.Int = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
     */
    val quickConnectTypes: List<QuickConnectType>? = builder.quickConnectTypes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ListQuickConnectsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListQuickConnectsRequest(")
        append("instanceId=$instanceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("quickConnectTypes=$quickConnectTypes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (quickConnectTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListQuickConnectsRequest

        if (instanceId != other.instanceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (quickConnectTypes != other.quickConnectTypes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ListQuickConnectsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        var maxResults: kotlin.Int = 0
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        var nextToken: kotlin.String? = null
        /**
         * The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
         */
        var quickConnectTypes: List<QuickConnectType>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ListQuickConnectsRequest) : this() {
            this.instanceId = x.instanceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.quickConnectTypes = x.quickConnectTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ListQuickConnectsRequest = ListQuickConnectsRequest(this)
    }
}
