// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Contains information about a routing profile.
 */
class RoutingProfile private constructor(builder: Builder) {
    /**
     * The identifier of the default outbound queue for this routing profile.
     */
    val defaultOutboundQueueId: kotlin.String? = builder.defaultOutboundQueueId
    /**
     * The description of the routing profile.
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
     */
    val mediaConcurrencies: List<MediaConcurrency>? = builder.mediaConcurrencies
    /**
     * The name of the routing profile.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the routing profile.
     */
    val routingProfileArn: kotlin.String? = builder.routingProfileArn
    /**
     * The identifier of the routing profile.
     */
    val routingProfileId: kotlin.String? = builder.routingProfileId
    /**
     * One or more tags.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.RoutingProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoutingProfile(")
        append("defaultOutboundQueueId=$defaultOutboundQueueId,")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("mediaConcurrencies=$mediaConcurrencies,")
        append("name=$name,")
        append("routingProfileArn=$routingProfileArn,")
        append("routingProfileId=$routingProfileId,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultOutboundQueueId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (mediaConcurrencies?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (routingProfileArn?.hashCode() ?: 0)
        result = 31 * result + (routingProfileId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoutingProfile

        if (defaultOutboundQueueId != other.defaultOutboundQueueId) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (mediaConcurrencies != other.mediaConcurrencies) return false
        if (name != other.name) return false
        if (routingProfileArn != other.routingProfileArn) return false
        if (routingProfileId != other.routingProfileId) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.RoutingProfile = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the default outbound queue for this routing profile.
         */
        var defaultOutboundQueueId: kotlin.String? = null
        /**
         * The description of the routing profile.
         */
        var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        var instanceId: kotlin.String? = null
        /**
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         */
        var mediaConcurrencies: List<MediaConcurrency>? = null
        /**
         * The name of the routing profile.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the routing profile.
         */
        var routingProfileArn: kotlin.String? = null
        /**
         * The identifier of the routing profile.
         */
        var routingProfileId: kotlin.String? = null
        /**
         * One or more tags.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.RoutingProfile) : this() {
            this.defaultOutboundQueueId = x.defaultOutboundQueueId
            this.description = x.description
            this.instanceId = x.instanceId
            this.mediaConcurrencies = x.mediaConcurrencies
            this.name = x.name
            this.routingProfileArn = x.routingProfileArn
            this.routingProfileId = x.routingProfileId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.RoutingProfile = RoutingProfile(this)
    }
}
