// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Contains information about the queue and channel for which priority and delay can be set.
 */
class RoutingProfileQueueConfig private constructor(builder: Builder) {
    /**
     * The delay, in seconds, a contact should be in the queue before they are routed to an available agent. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html) in the *Amazon Connect Administrator Guide*.
     */
    val delay: kotlin.Int = builder.delay
    /**
     * The order in which contacts are to be handled for the queue. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html).
     */
    val priority: kotlin.Int = builder.priority
    /**
     * Contains information about a queue resource.
     */
    val queueReference: aws.sdk.kotlin.services.connect.model.RoutingProfileQueueReference? = builder.queueReference

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoutingProfileQueueConfig(")
        append("delay=$delay,")
        append("priority=$priority,")
        append("queueReference=$queueReference)")
    }

    override fun hashCode(): kotlin.Int {
        var result = delay
        result = 31 * result + (priority)
        result = 31 * result + (queueReference?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoutingProfileQueueConfig

        if (delay != other.delay) return false
        if (priority != other.priority) return false
        if (queueReference != other.queueReference) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The delay, in seconds, a contact should be in the queue before they are routed to an available agent. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html) in the *Amazon Connect Administrator Guide*.
         */
        var delay: kotlin.Int = 0
        /**
         * The order in which contacts are to be handled for the queue. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html).
         */
        var priority: kotlin.Int = 0
        /**
         * Contains information about a queue resource.
         */
        var queueReference: aws.sdk.kotlin.services.connect.model.RoutingProfileQueueReference? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfig) : this() {
            this.delay = x.delay
            this.priority = x.priority
            this.queueReference = x.queueReference
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfig = RoutingProfileQueueConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.RoutingProfileQueueReference] inside the given [block]
         */
        fun queueReference(block: aws.sdk.kotlin.services.connect.model.RoutingProfileQueueReference.Builder.() -> kotlin.Unit) {
            this.queueReference = aws.sdk.kotlin.services.connect.model.RoutingProfileQueueReference.invoke(block)
        }
    }
}
