// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Contains summary information about a routing profile queue.
 */
class RoutingProfileQueueConfigSummary private constructor(builder: Builder) {
    /**
     * The channels this queue supports.
     */
    val channel: aws.sdk.kotlin.services.connect.model.Channel? = builder.channel
    /**
     * The delay, in seconds, that a contact should be in the queue before they are routed to an available agent. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html) in the *Amazon Connect Administrator Guide*.
     */
    val delay: kotlin.Int = builder.delay
    /**
     * The order in which contacts are to be handled for the queue. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html).
     */
    val priority: kotlin.Int = builder.priority
    /**
     * The Amazon Resource Name (ARN) of the queue.
     */
    val queueArn: kotlin.String? = builder.queueArn
    /**
     * The identifier for the queue.
     */
    val queueId: kotlin.String? = builder.queueId
    /**
     * The name of the queue.
     */
    val queueName: kotlin.String? = builder.queueName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfigSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoutingProfileQueueConfigSummary(")
        append("channel=$channel,")
        append("delay=$delay,")
        append("priority=$priority,")
        append("queueArn=$queueArn,")
        append("queueId=$queueId,")
        append("queueName=$queueName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channel?.hashCode() ?: 0
        result = 31 * result + (delay)
        result = 31 * result + (priority)
        result = 31 * result + (queueArn?.hashCode() ?: 0)
        result = 31 * result + (queueId?.hashCode() ?: 0)
        result = 31 * result + (queueName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoutingProfileQueueConfigSummary

        if (channel != other.channel) return false
        if (delay != other.delay) return false
        if (priority != other.priority) return false
        if (queueArn != other.queueArn) return false
        if (queueId != other.queueId) return false
        if (queueName != other.queueName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfigSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The channels this queue supports.
         */
        var channel: aws.sdk.kotlin.services.connect.model.Channel? = null
        /**
         * The delay, in seconds, that a contact should be in the queue before they are routed to an available agent. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html) in the *Amazon Connect Administrator Guide*.
         */
        var delay: kotlin.Int = 0
        /**
         * The order in which contacts are to be handled for the queue. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html).
         */
        var priority: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the queue.
         */
        var queueArn: kotlin.String? = null
        /**
         * The identifier for the queue.
         */
        var queueId: kotlin.String? = null
        /**
         * The name of the queue.
         */
        var queueName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfigSummary) : this() {
            this.channel = x.channel
            this.delay = x.delay
            this.priority = x.priority
            this.queueArn = x.queueArn
            this.queueId = x.queueId
            this.queueName = x.queueName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfigSummary = RoutingProfileQueueConfigSummary(this)
    }
}
