// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

class StartTaskContactRequest private constructor(builder: Builder) {
    /**
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.
     *
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to **Routing**, **Contact Flows**. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
     *
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
     */
    val contactFlowId: kotlin.String? = builder.contactFlowId
    /**
     * A description of the task that is shown to an agent in the Contact Control Panel (CCP).
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The name of a task that is shown to an agent in the Contact Control Panel (CCP).
     */
    val name: kotlin.String? = builder.name
    /**
     * The identifier of the previous chat, voice, or task contact.
     */
    val previousContactId: kotlin.String? = builder.previousContactId
    /**
     * The identifier for the quick connect.
     */
    val quickConnectId: kotlin.String? = builder.quickConnectId
    /**
     * A formatted URL that is shown to an agent in the Contact Control Panel (CCP).
     */
    val references: Map<String, Reference>? = builder.references
    /**
     * The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future.
     */
    val scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledTime
    /**
     * A unique identifier for the task template.
     */
    val taskTemplateId: kotlin.String? = builder.taskTemplateId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.StartTaskContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartTaskContactRequest(")
        append("attributes=$attributes,")
        append("clientToken=$clientToken,")
        append("contactFlowId=$contactFlowId,")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("name=$name,")
        append("previousContactId=$previousContactId,")
        append("quickConnectId=$quickConnectId,")
        append("references=$references,")
        append("scheduledTime=$scheduledTime,")
        append("taskTemplateId=$taskTemplateId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (contactFlowId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (previousContactId?.hashCode() ?: 0)
        result = 31 * result + (quickConnectId?.hashCode() ?: 0)
        result = 31 * result + (references?.hashCode() ?: 0)
        result = 31 * result + (scheduledTime?.hashCode() ?: 0)
        result = 31 * result + (taskTemplateId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartTaskContactRequest

        if (attributes != other.attributes) return false
        if (clientToken != other.clientToken) return false
        if (contactFlowId != other.contactFlowId) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (previousContactId != other.previousContactId) return false
        if (quickConnectId != other.quickConnectId) return false
        if (references != other.references) return false
        if (scheduledTime != other.scheduledTime) return false
        if (taskTemplateId != other.taskTemplateId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.StartTaskContactRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.
         *
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
         */
        var attributes: Map<String, String>? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        var clientToken: kotlin.String? = null
        /**
         * The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to **Routing**, **Contact Flows**. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
         *
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
         */
        var contactFlowId: kotlin.String? = null
        /**
         * A description of the task that is shown to an agent in the Contact Control Panel (CCP).
         */
        var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        var instanceId: kotlin.String? = null
        /**
         * The name of a task that is shown to an agent in the Contact Control Panel (CCP).
         */
        var name: kotlin.String? = null
        /**
         * The identifier of the previous chat, voice, or task contact.
         */
        var previousContactId: kotlin.String? = null
        /**
         * The identifier for the quick connect.
         */
        var quickConnectId: kotlin.String? = null
        /**
         * A formatted URL that is shown to an agent in the Contact Control Panel (CCP).
         */
        var references: Map<String, Reference>? = null
        /**
         * The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future.
         */
        var scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique identifier for the task template.
         */
        var taskTemplateId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.StartTaskContactRequest) : this() {
            this.attributes = x.attributes
            this.clientToken = x.clientToken
            this.contactFlowId = x.contactFlowId
            this.description = x.description
            this.instanceId = x.instanceId
            this.name = x.name
            this.previousContactId = x.previousContactId
            this.quickConnectId = x.quickConnectId
            this.references = x.references
            this.scheduledTime = x.scheduledTime
            this.taskTemplateId = x.taskTemplateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.StartTaskContactRequest = StartTaskContactRequest(this)
    }
}
