// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains summary information about the task template.
 */
class TaskTemplateMetadata private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the task template.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The timestamp when the task template was created.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description of the task template.
     */
    val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the task template.
     */
    val id: kotlin.String? = builder.id
    /**
     * The timestamp when the task template was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the task template.
     */
    val name: kotlin.String? = builder.name
    /**
     * Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it. Tasks can only be created from `ACTIVE` templates. If a template is marked as `INACTIVE`, then a task that refers to this template cannot be created.
     */
    val status: aws.sdk.kotlin.services.connect.model.TaskTemplateStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.TaskTemplateMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskTemplateMetadata(")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskTemplateMetadata

        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.TaskTemplateMetadata = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the task template.
         */
        var arn: kotlin.String? = null
        /**
         * The timestamp when the task template was created.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the task template.
         */
        var description: kotlin.String? = null
        /**
         * A unique identifier for the task template.
         */
        var id: kotlin.String? = null
        /**
         * The timestamp when the task template was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the task template.
         */
        var name: kotlin.String? = null
        /**
         * Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it. Tasks can only be created from `ACTIVE` templates. If a template is marked as `INACTIVE`, then a task that refers to this template cannot be created.
         */
        var status: aws.sdk.kotlin.services.connect.model.TaskTemplateStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.TaskTemplateMetadata) : this() {
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.description = x.description
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.TaskTemplateMetadata = TaskTemplateMetadata(this)
    }
}
