// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



class UpdateContactAttributesRequest private constructor(builder: Builder) {
    /**
     * The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other contact attributes.
     *
     * You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.
     */
    val initialContactId: kotlin.String? = builder.initialContactId
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    val instanceId: kotlin.String? = builder.instanceId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.UpdateContactAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateContactAttributesRequest(")
        append("attributes=$attributes,")
        append("initialContactId=$initialContactId,")
        append("instanceId=$instanceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (initialContactId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateContactAttributesRequest

        if (attributes != other.attributes) return false
        if (initialContactId != other.initialContactId) return false
        if (instanceId != other.instanceId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.UpdateContactAttributesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other contact attributes.
         *
         * You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
         */
        var attributes: Map<String, String>? = null
        /**
         * The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.
         */
        var initialContactId: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        var instanceId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.UpdateContactAttributesRequest) : this() {
            this.attributes = x.attributes
            this.initialContactId = x.initialContactId
            this.instanceId = x.instanceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.UpdateContactAttributesRequest = UpdateContactAttributesRequest(this)
    }
}
