// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Contains information about a user account for a Amazon Connect instance.
 */
class User private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the user account.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The identifier of the user account in the directory used for identity management.
     */
    val directoryUserId: kotlin.String? = builder.directoryUserId
    /**
     * The identifier of the hierarchy group for the user.
     */
    val hierarchyGroupId: kotlin.String? = builder.hierarchyGroupId
    /**
     * The identifier of the user account.
     */
    val id: kotlin.String? = builder.id
    /**
     * Information about the user identity.
     */
    val identityInfo: aws.sdk.kotlin.services.connect.model.UserIdentityInfo? = builder.identityInfo
    /**
     * Information about the phone configuration for the user.
     */
    val phoneConfig: aws.sdk.kotlin.services.connect.model.UserPhoneConfig? = builder.phoneConfig
    /**
     * The identifier of the routing profile for the user.
     */
    val routingProfileId: kotlin.String? = builder.routingProfileId
    /**
     * The identifiers of the security profiles for the user.
     */
    val securityProfileIds: List<String>? = builder.securityProfileIds
    /**
     * The tags.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The user name assigned to the user account.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.User = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("User(")
        append("arn=$arn,")
        append("directoryUserId=$directoryUserId,")
        append("hierarchyGroupId=$hierarchyGroupId,")
        append("id=$id,")
        append("identityInfo=$identityInfo,")
        append("phoneConfig=$phoneConfig,")
        append("routingProfileId=$routingProfileId,")
        append("securityProfileIds=$securityProfileIds,")
        append("tags=$tags,")
        append("username=$username)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (directoryUserId?.hashCode() ?: 0)
        result = 31 * result + (hierarchyGroupId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (identityInfo?.hashCode() ?: 0)
        result = 31 * result + (phoneConfig?.hashCode() ?: 0)
        result = 31 * result + (routingProfileId?.hashCode() ?: 0)
        result = 31 * result + (securityProfileIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as User

        if (arn != other.arn) return false
        if (directoryUserId != other.directoryUserId) return false
        if (hierarchyGroupId != other.hierarchyGroupId) return false
        if (id != other.id) return false
        if (identityInfo != other.identityInfo) return false
        if (phoneConfig != other.phoneConfig) return false
        if (routingProfileId != other.routingProfileId) return false
        if (securityProfileIds != other.securityProfileIds) return false
        if (tags != other.tags) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.User = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the user account.
         */
        var arn: kotlin.String? = null
        /**
         * The identifier of the user account in the directory used for identity management.
         */
        var directoryUserId: kotlin.String? = null
        /**
         * The identifier of the hierarchy group for the user.
         */
        var hierarchyGroupId: kotlin.String? = null
        /**
         * The identifier of the user account.
         */
        var id: kotlin.String? = null
        /**
         * Information about the user identity.
         */
        var identityInfo: aws.sdk.kotlin.services.connect.model.UserIdentityInfo? = null
        /**
         * Information about the phone configuration for the user.
         */
        var phoneConfig: aws.sdk.kotlin.services.connect.model.UserPhoneConfig? = null
        /**
         * The identifier of the routing profile for the user.
         */
        var routingProfileId: kotlin.String? = null
        /**
         * The identifiers of the security profiles for the user.
         */
        var securityProfileIds: List<String>? = null
        /**
         * The tags.
         */
        var tags: Map<String, String>? = null
        /**
         * The user name assigned to the user account.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.User) : this() {
            this.arn = x.arn
            this.directoryUserId = x.directoryUserId
            this.hierarchyGroupId = x.hierarchyGroupId
            this.id = x.id
            this.identityInfo = x.identityInfo
            this.phoneConfig = x.phoneConfig
            this.routingProfileId = x.routingProfileId
            this.securityProfileIds = x.securityProfileIds
            this.tags = x.tags
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.User = User(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserIdentityInfo] inside the given [block]
         */
        fun identityInfo(block: aws.sdk.kotlin.services.connect.model.UserIdentityInfo.Builder.() -> kotlin.Unit) {
            this.identityInfo = aws.sdk.kotlin.services.connect.model.UserIdentityInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserPhoneConfig] inside the given [block]
         */
        fun phoneConfig(block: aws.sdk.kotlin.services.connect.model.UserPhoneConfig.Builder.() -> kotlin.Unit) {
            this.phoneConfig = aws.sdk.kotlin.services.connect.model.UserPhoneConfig.invoke(block)
        }
    }
}
