// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Data for a user.
 */
class UserData private constructor(builder: Builder) {
    /**
     * A map of active slots by channel. The key is a channel name. The value is an integer: the number of active slots.
     */
    val activeSlotsByChannel: Map<String, Int>? = builder.activeSlotsByChannel
    /**
     * A map of available slots by channel. The key is a channel name. The value is an integer: the available number of slots.
     */
    val availableSlotsByChannel: Map<String, Int>? = builder.availableSlotsByChannel
    /**
     * A list of contact reference information.
     */
    val contacts: List<AgentContactReference>? = builder.contacts
    /**
     * Contains information about the levels of a hierarchy group assigned to a user.
     */
    val hierarchyPath: aws.sdk.kotlin.services.connect.model.HierarchyPathReference? = builder.hierarchyPath
    /**
     * A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number of slots. This is calculated from [MediaConcurrency](https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html) of the RoutingProfile assigned to the agent.
     */
    val maxSlotsByChannel: Map<String, Int>? = builder.maxSlotsByChannel
    /**
     * Information about the routing profile that is assigned to the user.
     */
    val routingProfile: aws.sdk.kotlin.services.connect.model.RoutingProfileReference? = builder.routingProfile
    /**
     * The status of the agent that they manually set in their Contact Control Panel (CCP), or that the supervisor manually changes in the real-time metrics report.
     */
    val status: aws.sdk.kotlin.services.connect.model.AgentStatusReference? = builder.status
    /**
     * Information about the user for the data that is returned. It contains resourceId and ARN of the user.
     */
    val user: aws.sdk.kotlin.services.connect.model.UserReference? = builder.user

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.UserData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserData(")
        append("activeSlotsByChannel=$activeSlotsByChannel,")
        append("availableSlotsByChannel=$availableSlotsByChannel,")
        append("contacts=$contacts,")
        append("hierarchyPath=$hierarchyPath,")
        append("maxSlotsByChannel=$maxSlotsByChannel,")
        append("routingProfile=$routingProfile,")
        append("status=$status,")
        append("user=$user)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeSlotsByChannel?.hashCode() ?: 0
        result = 31 * result + (availableSlotsByChannel?.hashCode() ?: 0)
        result = 31 * result + (contacts?.hashCode() ?: 0)
        result = 31 * result + (hierarchyPath?.hashCode() ?: 0)
        result = 31 * result + (maxSlotsByChannel?.hashCode() ?: 0)
        result = 31 * result + (routingProfile?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserData

        if (activeSlotsByChannel != other.activeSlotsByChannel) return false
        if (availableSlotsByChannel != other.availableSlotsByChannel) return false
        if (contacts != other.contacts) return false
        if (hierarchyPath != other.hierarchyPath) return false
        if (maxSlotsByChannel != other.maxSlotsByChannel) return false
        if (routingProfile != other.routingProfile) return false
        if (status != other.status) return false
        if (user != other.user) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.UserData = Builder(this).apply(block).build()

    class Builder {
        /**
         * A map of active slots by channel. The key is a channel name. The value is an integer: the number of active slots.
         */
        var activeSlotsByChannel: Map<String, Int>? = null
        /**
         * A map of available slots by channel. The key is a channel name. The value is an integer: the available number of slots.
         */
        var availableSlotsByChannel: Map<String, Int>? = null
        /**
         * A list of contact reference information.
         */
        var contacts: List<AgentContactReference>? = null
        /**
         * Contains information about the levels of a hierarchy group assigned to a user.
         */
        var hierarchyPath: aws.sdk.kotlin.services.connect.model.HierarchyPathReference? = null
        /**
         * A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number of slots. This is calculated from [MediaConcurrency](https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html) of the RoutingProfile assigned to the agent.
         */
        var maxSlotsByChannel: Map<String, Int>? = null
        /**
         * Information about the routing profile that is assigned to the user.
         */
        var routingProfile: aws.sdk.kotlin.services.connect.model.RoutingProfileReference? = null
        /**
         * The status of the agent that they manually set in their Contact Control Panel (CCP), or that the supervisor manually changes in the real-time metrics report.
         */
        var status: aws.sdk.kotlin.services.connect.model.AgentStatusReference? = null
        /**
         * Information about the user for the data that is returned. It contains resourceId and ARN of the user.
         */
        var user: aws.sdk.kotlin.services.connect.model.UserReference? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.UserData) : this() {
            this.activeSlotsByChannel = x.activeSlotsByChannel
            this.availableSlotsByChannel = x.availableSlotsByChannel
            this.contacts = x.contacts
            this.hierarchyPath = x.hierarchyPath
            this.maxSlotsByChannel = x.maxSlotsByChannel
            this.routingProfile = x.routingProfile
            this.status = x.status
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.UserData = UserData(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.HierarchyPathReference] inside the given [block]
         */
        fun hierarchyPath(block: aws.sdk.kotlin.services.connect.model.HierarchyPathReference.Builder.() -> kotlin.Unit) {
            this.hierarchyPath = aws.sdk.kotlin.services.connect.model.HierarchyPathReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.RoutingProfileReference] inside the given [block]
         */
        fun routingProfile(block: aws.sdk.kotlin.services.connect.model.RoutingProfileReference.Builder.() -> kotlin.Unit) {
            this.routingProfile = aws.sdk.kotlin.services.connect.model.RoutingProfileReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.AgentStatusReference] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.connect.model.AgentStatusReference.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.connect.model.AgentStatusReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserReference] inside the given [block]
         */
        fun user(block: aws.sdk.kotlin.services.connect.model.UserReference.Builder.() -> kotlin.Unit) {
            this.user = aws.sdk.kotlin.services.connect.model.UserReference.invoke(block)
        }
    }
}
