// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a custom vocabulary.
 */
class Vocabulary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the custom vocabulary.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with `Phrase`, `IPA`, `SoundsLike`, and `DisplayAs` fields. Separate the fields with TAB characters. For more information, see [Create a custom vocabulary using a table](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table).
     */
    val content: kotlin.String? = builder.content
    /**
     * The reason why the custom vocabulary was not created.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The identifier of the custom vocabulary.
     */
    val id: kotlin.String? = builder.id
    /**
     * The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see [What is Amazon Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
     */
    val languageCode: aws.sdk.kotlin.services.connect.model.VocabularyLanguageCode? = builder.languageCode
    /**
     * The timestamp when the custom vocabulary was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * A unique name of the custom vocabulary.
     */
    val name: kotlin.String? = builder.name
    /**
     * The current state of the custom vocabulary.
     */
    val state: aws.sdk.kotlin.services.connect.model.VocabularyState? = builder.state
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.Vocabulary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Vocabulary(")
        append("arn=$arn,")
        append("content=$content,")
        append("failureReason=$failureReason,")
        append("id=$id,")
        append("languageCode=$languageCode,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("state=$state,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Vocabulary

        if (arn != other.arn) return false
        if (content != other.content) return false
        if (failureReason != other.failureReason) return false
        if (id != other.id) return false
        if (languageCode != other.languageCode) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.Vocabulary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the custom vocabulary.
         */
        var arn: kotlin.String? = null
        /**
         * The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with `Phrase`, `IPA`, `SoundsLike`, and `DisplayAs` fields. Separate the fields with TAB characters. For more information, see [Create a custom vocabulary using a table](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table).
         */
        var content: kotlin.String? = null
        /**
         * The reason why the custom vocabulary was not created.
         */
        var failureReason: kotlin.String? = null
        /**
         * The identifier of the custom vocabulary.
         */
        var id: kotlin.String? = null
        /**
         * The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see [What is Amazon Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
         */
        var languageCode: aws.sdk.kotlin.services.connect.model.VocabularyLanguageCode? = null
        /**
         * The timestamp when the custom vocabulary was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique name of the custom vocabulary.
         */
        var name: kotlin.String? = null
        /**
         * The current state of the custom vocabulary.
         */
        var state: aws.sdk.kotlin.services.connect.model.VocabularyState? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.Vocabulary) : this() {
            this.arn = x.arn
            this.content = x.content
            this.failureReason = x.failureReason
            this.id = x.id
            this.languageCode = x.languageCode
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.Vocabulary = Vocabulary(this)
    }
}
