// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class CreateRoutingProfileRequest private constructor(builder: Builder) {
    /**
     * The default outbound queue for the routing profile.
     */
    public val defaultOutboundQueueId: kotlin.String? = builder.defaultOutboundQueueId
    /**
     * Description of the routing profile. Must not be more than 250 characters.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public val instanceId: kotlin.String? = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
     */
    public val mediaConcurrencies: List<MediaConcurrency>? = builder.mediaConcurrencies
    /**
     * The name of the routing profile. Must not be more than 127 characters.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.
     */
    public val queueConfigs: List<RoutingProfileQueueConfig>? = builder.queueConfigs
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateRoutingProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRoutingProfileRequest(")
        append("defaultOutboundQueueId=$defaultOutboundQueueId,")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("mediaConcurrencies=$mediaConcurrencies,")
        append("name=$name,")
        append("queueConfigs=$queueConfigs,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultOutboundQueueId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (mediaConcurrencies?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queueConfigs?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRoutingProfileRequest

        if (defaultOutboundQueueId != other.defaultOutboundQueueId) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (mediaConcurrencies != other.mediaConcurrencies) return false
        if (name != other.name) return false
        if (queueConfigs != other.queueConfigs) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateRoutingProfileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default outbound queue for the routing profile.
         */
        public var defaultOutboundQueueId: kotlin.String? = null
        /**
         * Description of the routing profile. Must not be more than 250 characters.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
         */
        public var mediaConcurrencies: List<MediaConcurrency>? = null
        /**
         * The name of the routing profile. Must not be more than 127 characters.
         */
        public var name: kotlin.String? = null
        /**
         * The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.
         */
        public var queueConfigs: List<RoutingProfileQueueConfig>? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateRoutingProfileRequest) : this() {
            this.defaultOutboundQueueId = x.defaultOutboundQueueId
            this.description = x.description
            this.instanceId = x.instanceId
            this.mediaConcurrencies = x.mediaConcurrencies
            this.name = x.name
            this.queueConfigs = x.queueConfigs
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateRoutingProfileRequest = CreateRoutingProfileRequest(this)
    }
}
