// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.CreateHoursOfOperationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateHoursOfOperationOperationDeserializer: HttpDeserialize<CreateHoursOfOperationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateHoursOfOperationResponse {
        if (!response.status.isSuccess()) {
            throwCreateHoursOfOperationError(context, response)
        }
        val builder = CreateHoursOfOperationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateHoursOfOperationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateHoursOfOperationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateResourceException" -> DuplicateResourceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateHoursOfOperationOperationBody(builder: CreateHoursOfOperationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HOURSOFOPERATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HoursOfOperationArn"))
    val HOURSOFOPERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HoursOfOperationId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HOURSOFOPERATIONARN_DESCRIPTOR)
        field(HOURSOFOPERATIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HOURSOFOPERATIONARN_DESCRIPTOR.index -> builder.hoursOfOperationArn = deserializeString()
                HOURSOFOPERATIONID_DESCRIPTOR.index -> builder.hoursOfOperationId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
