/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.crt.io;

import aws.sdk.kotlin.crt.io.Protocol;
import aws.sdk.kotlin.crt.io.UriBuilder;
import aws.sdk.kotlin.crt.io.UriJVMKt;
import aws.sdk.kotlin.crt.io.UserInfo;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b#\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00010BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\t\u0010*\u001a\u00020\u000eH\u00c6\u0003J_\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010,\u001a\u00020\u000e2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020\u0007H\u00d6\u0001J\b\u0010/\u001a\u00020\u0005H\u0016R\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00061"}, d2={"Laws/sdk/kotlin/crt/io/Uri;", "", "scheme", "Laws/sdk/kotlin/crt/io/Protocol;", "host", "", "specifiedPort", "", "path", "parameters", "fragment", "userInfo", "Laws/sdk/kotlin/crt/io/UserInfo;", "forceQuery", "", "(Laws/sdk/kotlin/crt/io/Protocol;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Laws/sdk/kotlin/crt/io/UserInfo;Z)V", "authority", "getAuthority", "()Ljava/lang/String;", "getForceQuery", "()Z", "getFragment", "getHost", "hostAndPort", "getHostAndPort", "getParameters", "getPath", "port", "getPort", "()I", "getScheme", "()Laws/sdk/kotlin/crt/io/Protocol;", "getSpecifiedPort", "getUserInfo", "()Laws/sdk/kotlin/crt/io/UserInfo;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "Companion", "aws-crt-kotlin"})
public final class Uri {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Protocol scheme;
    @NotNull
    private final String host;
    private final int specifiedPort;
    @NotNull
    private final String path;
    @Nullable
    private final String parameters;
    @Nullable
    private final String fragment;
    @Nullable
    private final UserInfo userInfo;
    private final boolean forceQuery;
    private final int port;

    /*
     * WARNING - void declaration
     */
    public Uri(@NotNull Protocol scheme, @NotNull String host, int specifiedPort, @NotNull String path, @Nullable String parameters, @Nullable String fragment, @Nullable UserInfo userInfo, boolean forceQuery) {
        void it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.scheme = scheme;
        this.host = host;
        this.specifiedPort = specifiedPort;
        this.path = path;
        this.parameters = parameters;
        this.fragment = fragment;
        this.userInfo = userInfo;
        this.forceQuery = forceQuery;
        if (this.specifiedPort != -1) {
            int n = this.specifiedPort;
            n = 1 <= n ? (n <= 65536 ? 1 : 0) : 0;
            boolean bl2 = false;
            bl = false;
            if (n == 0) {
                boolean bl3 = false;
                String string = Intrinsics.stringPlus((String)"port must be in between 1 and 65536; found: ", (Object)this.getSpecifiedPort());
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        Integer n = this.specifiedPort;
        bl = false;
        boolean bl4 = false;
        int n2 = ((Number)n).intValue();
        Uri uri = this;
        boolean bl5 = false;
        boolean bl6 = it == -1;
        Integer n3 = !bl6 ? n : null;
        uri.port = n3 == null ? this.scheme.getDefaultPort() : n3.intValue();
    }

    public /* synthetic */ Uri(Protocol protocol, String string, int n, String string2, String string3, String string4, UserInfo userInfo, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        if ((n2 & 8) != 0) {
            string2 = "";
        }
        if ((n2 & 0x10) != 0) {
            string3 = null;
        }
        if ((n2 & 0x20) != 0) {
            string4 = null;
        }
        if ((n2 & 0x40) != 0) {
            userInfo = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        this(protocol, string, n, string2, string3, string4, userInfo, bl);
    }

    @NotNull
    public final Protocol getScheme() {
        return this.scheme;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getSpecifiedPort() {
        return this.specifiedPort;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final String getParameters() {
        return this.parameters;
    }

    @Nullable
    public final String getFragment() {
        return this.fragment;
    }

    @Nullable
    public final UserInfo getUserInfo() {
        return this.userInfo;
    }

    public final boolean getForceQuery() {
        return this.forceQuery;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getAuthority() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$_get_authority__u24lambda_u2d3 = stringBuilder;
        boolean bl5 = false;
        UserInfo userInfo = this.getUserInfo();
        if (userInfo != null) {
            UserInfo userInfo2 = userInfo;
            boolean bl6 = false;
            boolean bl7 = false;
            UserInfo userinfo = userInfo2;
            boolean bl8 = false;
            CharSequence charSequence = userinfo.getUsername();
            boolean bl9 = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                $this$_get_authority__u24lambda_u2d3.append(userinfo.getUsername());
                charSequence = userinfo.getPassword();
                bl9 = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    $this$_get_authority__u24lambda_u2d3.append(Intrinsics.stringPlus((String)":", (Object)userinfo.getPassword()));
                }
                $this$_get_authority__u24lambda_u2d3.append("@");
            }
        }
        $this$_get_authority__u24lambda_u2d3.append(this.getHostAndPort());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String getHostAndPort() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$_get_hostAndPort__u24lambda_u2d4 = stringBuilder;
        boolean bl5 = false;
        $this$_get_hostAndPort__u24lambda_u2d4.append(this.getHost());
        if (this.getSpecifiedPort() != -1 && this.getSpecifiedPort() != this.getScheme().getDefaultPort()) {
            $this$_get_hostAndPort__u24lambda_u2d4.append(Intrinsics.stringPlus((String)":", (Object)this.getSpecifiedPort()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public String toString() {
        CharSequence charSequence;
        StringBuilder $this$toString_u24lambda_u2d6;
        StringBuilder stringBuilder;
        block9: {
            block8: {
                block7: {
                    boolean bl = false;
                    boolean bl2 = false;
                    stringBuilder = new StringBuilder();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    $this$toString_u24lambda_u2d6 = stringBuilder;
                    boolean bl5 = false;
                    $this$toString_u24lambda_u2d6.append(this.getScheme().getName());
                    $this$toString_u24lambda_u2d6.append("://");
                    $this$toString_u24lambda_u2d6.append(this.getAuthority());
                    charSequence = this.getPath();
                    boolean bl6 = false;
                    if (!StringsKt.isBlank((CharSequence)charSequence)) {
                        $this$toString_u24lambda_u2d6.append("/");
                        $this$toString_u24lambda_u2d6.append(StringsKt.removePrefix((String)this.getPath(), (CharSequence)"/"));
                    }
                    if (this.getParameters() == null) break block7;
                    charSequence = this.getParameters();
                    bl6 = false;
                    if (charSequence.length() > 0) break block8;
                }
                if (!this.getForceQuery()) break block9;
            }
            $this$toString_u24lambda_u2d6.append("?");
        }
        if ((charSequence = this.getParameters()) != null) {
            CharSequence charSequence2 = charSequence;
            boolean bl = false;
            boolean bl7 = false;
            CharSequence it = charSequence2;
            boolean bl8 = false;
            $this$toString_u24lambda_u2d6.append((String)it);
        }
        if (this.getFragment() != null) {
            charSequence = this.getFragment();
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                $this$toString_u24lambda_u2d6.append("#");
                $this$toString_u24lambda_u2d6.append(this.getFragment());
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final Protocol component1() {
        return this.scheme;
    }

    @NotNull
    public final String component2() {
        return this.host;
    }

    public final int component3() {
        return this.specifiedPort;
    }

    @NotNull
    public final String component4() {
        return this.path;
    }

    @Nullable
    public final String component5() {
        return this.parameters;
    }

    @Nullable
    public final String component6() {
        return this.fragment;
    }

    @Nullable
    public final UserInfo component7() {
        return this.userInfo;
    }

    public final boolean component8() {
        return this.forceQuery;
    }

    @NotNull
    public final Uri copy(@NotNull Protocol scheme, @NotNull String host, int specifiedPort, @NotNull String path, @Nullable String parameters, @Nullable String fragment, @Nullable UserInfo userInfo, boolean forceQuery) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Uri(scheme, host, specifiedPort, path, parameters, fragment, userInfo, forceQuery);
    }

    public static /* synthetic */ Uri copy$default(Uri uri, Protocol protocol, String string, int n, String string2, String string3, String string4, UserInfo userInfo, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            protocol = uri.scheme;
        }
        if ((n2 & 2) != 0) {
            string = uri.host;
        }
        if ((n2 & 4) != 0) {
            n = uri.specifiedPort;
        }
        if ((n2 & 8) != 0) {
            string2 = uri.path;
        }
        if ((n2 & 0x10) != 0) {
            string3 = uri.parameters;
        }
        if ((n2 & 0x20) != 0) {
            string4 = uri.fragment;
        }
        if ((n2 & 0x40) != 0) {
            userInfo = uri.userInfo;
        }
        if ((n2 & 0x80) != 0) {
            bl = uri.forceQuery;
        }
        return uri.copy(protocol, string, n, string2, string3, string4, userInfo, bl);
    }

    public int hashCode() {
        int result = this.scheme.hashCode();
        result = result * 31 + this.host.hashCode();
        result = result * 31 + Integer.hashCode(this.specifiedPort);
        result = result * 31 + this.path.hashCode();
        result = result * 31 + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = result * 31 + (this.fragment == null ? 0 : this.fragment.hashCode());
        result = result * 31 + (this.userInfo == null ? 0 : this.userInfo.hashCode());
        int n = this.forceQuery ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Uri)) {
            return false;
        }
        Uri uri = (Uri)other;
        if (!Intrinsics.areEqual((Object)this.scheme, (Object)uri.scheme)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)uri.host)) {
            return false;
        }
        if (this.specifiedPort != uri.specifiedPort) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)uri.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parameters, (Object)uri.parameters)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fragment, (Object)uri.fragment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userInfo, (Object)uri.userInfo)) {
            return false;
        }
        return this.forceQuery == uri.forceQuery;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Laws/sdk/kotlin/crt/io/Uri$Companion;", "", "()V", "build", "Laws/sdk/kotlin/crt/io/Uri;", "block", "Lkotlin/Function1;", "Laws/sdk/kotlin/crt/io/UriBuilder;", "", "Lkotlin/ExtensionFunctionType;", "parse", "uri", "", "aws-crt-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Uri build(@NotNull Function1<? super UriBuilder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            UriBuilder uriBuilder = new UriBuilder();
            boolean bl = false;
            boolean bl2 = false;
            block.invoke((Object)uriBuilder);
            return uriBuilder.build$aws_crt_kotlin();
        }

        @NotNull
        public final Uri parse(@NotNull String uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return UriJVMKt.parseUri(uri);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

