/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.crt;

import aws.sdk.kotlin.crt.CRT;
import aws.sdk.kotlin.crt.Config;
import aws.sdk.kotlin.crt.CrtDebug;
import aws.sdk.kotlin.crt.LogDestination;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.crt.Log;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ!\u0010\n\u001a\u00020\u000b2\u0019\b\u0002\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\u0002\b\u000fJ\u0006\u0010\u0010\u001a\u00020\bJ\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Laws/sdk/kotlin/crt/CRT;", "", "()V", "initialized", "Ljava/util/concurrent/atomic/AtomicInteger;", "errorName", "", "errorCode", "", "errorString", "initRuntime", "", "block", "Lkotlin/Function1;", "Laws/sdk/kotlin/crt/Config;", "Lkotlin/ExtensionFunctionType;", "lastError", "nativeMemory", "", "aws-crt-kotlin"})
public final class CRT {
    @NotNull
    public static final CRT INSTANCE = new CRT();
    @NotNull
    private static final AtomicInteger initialized = new AtomicInteger(0);

    private CRT() {
    }

    public final void initRuntime(@NotNull Function1<? super Config, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!initialized.compareAndSet(0, 1)) {
            return;
        }
        System.setProperty("aws.crt.memory.tracing", String.valueOf(CrtDebug.INSTANCE.getTraceLevel()));
        new software.amazon.awssdk.crt.CRT();
        Config config = new Config();
        block.invoke((Object)config);
        Config config2 = config;
        Log.LogLevel logLevel = Log.LogLevel.valueOf((String)config2.getLogLovel().name());
        switch (WhenMappings.$EnumSwitchMapping$0[config2.getLogDestination().ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                Log.initLoggingToStdout((Log.LogLevel)logLevel);
                break;
            }
            case 3: {
                Log.initLoggingToStderr((Log.LogLevel)logLevel);
                break;
            }
            case 4: {
                String logfile = config2.getLogFile();
                if (logfile == null) {
                    boolean bl = false;
                    String string = "log filename must be specified when LogDestination.File is specified";
                    throw new IllegalArgumentException(string.toString());
                }
                Log.initLoggingToFile((Log.LogLevel)logLevel, (String)logfile);
            }
        }
    }

    public static /* synthetic */ void initRuntime$default(CRT cRT, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = initRuntime.1.INSTANCE;
        }
        cRT.initRuntime((Function1<? super Config, Unit>)function1);
    }

    public final int lastError() {
        return software.amazon.awssdk.crt.CRT.awsLastError();
    }

    @Nullable
    public final String errorString(int errorCode) {
        return software.amazon.awssdk.crt.CRT.awsErrorString((int)errorCode);
    }

    @Nullable
    public final String errorName(int errorCode) {
        return software.amazon.awssdk.crt.CRT.awsErrorName((int)errorCode);
    }

    public final long nativeMemory() {
        return software.amazon.awssdk.crt.CRT.nativeMemory();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogDestination.values().length];
            nArray[LogDestination.None.ordinal()] = 1;
            nArray[LogDestination.Stdout.ordinal()] = 2;
            nArray[LogDestination.Stderr.ordinal()] = 3;
            nArray[LogDestination.File.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

