/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.crt.http;

import aws.sdk.kotlin.crt.http.HeadersBuilder;
import aws.sdk.kotlin.crt.http.HttpHeader;
import aws.sdk.kotlin.crt.http.HttpRequest;
import aws.sdk.kotlin.crt.http.HttpRequestBodyStream;
import aws.sdk.kotlin.crt.http.HttpRequestBuilder;
import aws.sdk.kotlin.crt.http.HttpRequestKt;
import aws.sdk.kotlin.crt.http.HttpStreamJVM;
import aws.sdk.kotlin.crt.http.HttpStreamResponseHandler;
import aws.sdk.kotlin.crt.http.JniRequestBodyStream;
import aws.sdk.kotlin.crt.io.Buffer;
import aws.sdk.kotlin.crt.io.BufferKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.crt.http.HttpStream;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\u0007*\u00020\u0004H\u0000\u00a8\u0006\t"}, d2={"asJniStreamResponseHandler", "Lsoftware/amazon/awssdk/crt/http/HttpStreamResponseHandler;", "Laws/sdk/kotlin/crt/http/HttpStreamResponseHandler;", "from", "Laws/sdk/kotlin/crt/http/HttpRequest;", "Laws/sdk/kotlin/crt/http/HttpRequest$Companion;", "jniRequest", "Lsoftware/amazon/awssdk/crt/http/HttpRequest;", "into", "aws-crt-kotlin"})
public final class HttpRequestUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final software.amazon.awssdk.crt.http.HttpRequest into(@NotNull HttpRequest $this$into) {
        JniRequestBodyStream jniRequestBodyStream;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$into, (String)"<this>");
        Iterable $this$map$iv = $this$into.getHeaders().entries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void entry;
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)entry.getValue();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(new software.amazon.awssdk.crt.http.HttpHeader((String)entry.getKey(), (String)it));
            }
            collection.add((List)destination$iv$iv2);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        software.amazon.awssdk.crt.http.HttpHeader[] httpHeaderArray = thisCollection$iv.toArray(new software.amazon.awssdk.crt.http.HttpHeader[0]);
        Intrinsics.checkNotNull((Object)httpHeaderArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        software.amazon.awssdk.crt.http.HttpHeader[] jniHeaders = httpHeaderArray;
        HttpRequestBodyStream httpRequestBodyStream = $this$into.getBody();
        if (httpRequestBodyStream != null) {
            HttpRequestBodyStream it = httpRequestBodyStream;
            boolean bl = false;
            jniRequestBodyStream = new JniRequestBodyStream(it);
        } else {
            jniRequestBodyStream = null;
        }
        JniRequestBodyStream bodyStream = jniRequestBodyStream;
        return new software.amazon.awssdk.crt.http.HttpRequest($this$into.getMethod(), $this$into.getEncodedPath(), jniHeaders, (software.amazon.awssdk.crt.http.HttpRequestBodyStream)bodyStream);
    }

    @NotNull
    public static final software.amazon.awssdk.crt.http.HttpStreamResponseHandler asJniStreamResponseHandler(@NotNull HttpStreamResponseHandler $this$asJniStreamResponseHandler) {
        Intrinsics.checkNotNullParameter((Object)$this$asJniStreamResponseHandler, (String)"<this>");
        HttpStreamResponseHandler handler = $this$asJniStreamResponseHandler;
        return new software.amazon.awssdk.crt.http.HttpStreamResponseHandler(handler){
            final /* synthetic */ HttpStreamResponseHandler $handler;
            {
                this.$handler = $handler;
            }

            /*
             * WARNING - void declaration
             */
            public void onResponseHeaders(@NotNull HttpStream stream, int statusCode, int blockType, @Nullable software.amazon.awssdk.crt.http.HttpHeader[] headers) {
                List list;
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                if (headers != null) {
                    void $this$mapTo$iv$iv;
                    software.amazon.awssdk.crt.http.HttpHeader[] $this$map$iv = headers;
                    boolean $i$f$map = false;
                    software.amazon.awssdk.crt.http.HttpHeader[] httpHeaderArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var14_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        String string2 = it.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.value");
                        collection.add(new HttpHeader(string, string2));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = null;
                }
                List ktHeaders = list;
                HttpStreamJVM ktStream = new HttpStreamJVM(stream);
                this.$handler.onResponseHeaders(ktStream, statusCode, blockType, ktHeaders);
            }

            public void onResponseHeadersDone(@NotNull HttpStream stream, int blockType) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                HttpStreamJVM ktStream = new HttpStreamJVM(stream);
                this.$handler.onResponseHeadersDone(ktStream, blockType);
            }

            public int onResponseBody(@NotNull HttpStream stream, @Nullable byte[] bodyBytesIn) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                if (bodyBytesIn == null) {
                    return 0;
                }
                HttpStreamJVM ktStream = new HttpStreamJVM(stream);
                Buffer buffer = BufferKt.byteArrayBuffer(bodyBytesIn);
                return this.$handler.onResponseBody(ktStream, buffer);
            }

            public void onResponseComplete(@NotNull HttpStream stream, int errorCode) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                HttpStreamJVM ktStream = new HttpStreamJVM(stream);
                this.$handler.onResponseComplete(ktStream, errorCode);
            }
        };
    }

    @NotNull
    public static final HttpRequest from(@NotNull HttpRequest.Companion $this$from, @NotNull software.amazon.awssdk.crt.http.HttpRequest jniRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$from, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jniRequest, (String)"jniRequest");
        return $this$from.build((Function1<? super HttpRequestBuilder, Unit>)((Function1)new Function1<HttpRequestBuilder, Unit>(jniRequest){
            final /* synthetic */ software.amazon.awssdk.crt.http.HttpRequest $jniRequest;
            {
                this.$jniRequest = $jniRequest;
                super(1);
            }

            public final void invoke(@NotNull HttpRequestBuilder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                String string = this.$jniRequest.getMethod();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jniRequest.method");
                $this$build.setMethod(string);
                String string2 = this.$jniRequest.getEncodedPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jniRequest.encodedPath");
                $this$build.setEncodedPath(string2);
                HttpRequestKt.headers($this$build, (Function1<? super HeadersBuilder, Unit>)((Function1)new Function1<HeadersBuilder, Unit>(this.$jniRequest){
                    final /* synthetic */ software.amazon.awssdk.crt.http.HttpRequest $jniRequest;
                    {
                        this.$jniRequest = $jniRequest;
                        super(1);
                    }

                    public final void invoke(@NotNull HeadersBuilder $this$headers) {
                        Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
                        List list = this.$jniRequest.getHeaders();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jniRequest.headers");
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            software.amazon.awssdk.crt.http.HttpHeader it = (software.amazon.awssdk.crt.http.HttpHeader)element$iv;
                            boolean bl = false;
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            String string2 = it.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.value");
                            $this$headers.append(string, string2);
                        }
                    }
                }));
                software.amazon.awssdk.crt.http.HttpRequestBodyStream jniBodyStream = this.$jniRequest.getBodyStream();
                if (jniBodyStream != null) {
                    if (jniBodyStream instanceof JniRequestBodyStream) {
                        $this$build.setBody(((JniRequestBodyStream)jniBodyStream).getKtStream());
                    } else {
                        String string3 = "JNI request body stream is not an instance of JniRequestBodyStream - proxying other stream types not implemented yet";
                        throw new NotImplementedError("An operation is not implemented: " + string3);
                    }
                }
            }
        }));
    }
}

