/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.crt.http;

import aws.sdk.kotlin.crt.http.HttpClientConnectionManagerOptionsBuilder;
import aws.sdk.kotlin.crt.http.HttpMonitoringOptions;
import aws.sdk.kotlin.crt.http.HttpProxyOptions;
import aws.sdk.kotlin.crt.io.ClientBootstrap;
import aws.sdk.kotlin.crt.io.SocketOptions;
import aws.sdk.kotlin.crt.io.TlsContext;
import aws.sdk.kotlin.crt.io.Uri;
import aws.sdk.kotlin.crt.io.UriKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006,"}, d2={"Laws/sdk/kotlin/crt/http/HttpClientConnectionManagerOptions;", "", "builder", "Laws/sdk/kotlin/crt/http/HttpClientConnectionManagerOptionsBuilder;", "(Laws/sdk/kotlin/crt/http/HttpClientConnectionManagerOptionsBuilder;)V", "clientBootstrap", "Laws/sdk/kotlin/crt/io/ClientBootstrap;", "getClientBootstrap", "()Laws/sdk/kotlin/crt/io/ClientBootstrap;", "initialWindowSize", "", "getInitialWindowSize", "()I", "manualWindowManagement", "", "getManualWindowManagement", "()Z", "maxConnectionIdleMs", "", "getMaxConnectionIdleMs", "()J", "maxConnections", "getMaxConnections", "monitoringOptions", "Laws/sdk/kotlin/crt/http/HttpMonitoringOptions;", "getMonitoringOptions", "()Laws/sdk/kotlin/crt/http/HttpMonitoringOptions;", "proxyOptions", "Laws/sdk/kotlin/crt/http/HttpProxyOptions;", "getProxyOptions", "()Laws/sdk/kotlin/crt/http/HttpProxyOptions;", "socketOptions", "Laws/sdk/kotlin/crt/io/SocketOptions;", "getSocketOptions", "()Laws/sdk/kotlin/crt/io/SocketOptions;", "tlsContext", "Laws/sdk/kotlin/crt/io/TlsContext;", "getTlsContext", "()Laws/sdk/kotlin/crt/io/TlsContext;", "uri", "Laws/sdk/kotlin/crt/io/Uri;", "getUri", "()Laws/sdk/kotlin/crt/io/Uri;", "Companion", "aws-crt-kotlin"})
public final class HttpClientConnectionManagerOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Uri uri;
    @NotNull
    private final ClientBootstrap clientBootstrap;
    @NotNull
    private final SocketOptions socketOptions;
    @Nullable
    private final TlsContext tlsContext;
    private final int initialWindowSize;
    private final int maxConnections;
    @Nullable
    private final HttpProxyOptions proxyOptions;
    private final boolean manualWindowManagement;
    @Nullable
    private final HttpMonitoringOptions monitoringOptions;
    private final long maxConnectionIdleMs;
    public static final int DEFAULT_INITIAL_WINDOW_SIZE = 16384;
    public static final int DEFAULT_MAX_CONNECTIONS = 2;

    public HttpClientConnectionManagerOptions(@NotNull HttpClientConnectionManagerOptionsBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Uri uri = builder.getUri();
        if (uri == null) {
            HttpClientConnectionManagerOptions httpClientConnectionManagerOptions = this;
            boolean $i$a$-requireNotNull-HttpClientConnectionManagerOptions$uri$22 = false;
            HttpClientConnectionManagerOptions httpClientConnectionManagerOptions2 = httpClientConnectionManagerOptions;
            String $i$a$-requireNotNull-HttpClientConnectionManagerOptions$uri$22 = "URI is required";
            throw new IllegalArgumentException($i$a$-requireNotNull-HttpClientConnectionManagerOptions$uri$22.toString());
        }
        this.uri = uri;
        ClientBootstrap clientBootstrap = builder.getClientBootstrap();
        if (clientBootstrap == null) {
            HttpClientConnectionManagerOptions httpClientConnectionManagerOptions = this;
            boolean $i$a$-requireNotNull-HttpClientConnectionManagerOptions$clientBootstrap$22 = false;
            HttpClientConnectionManagerOptions httpClientConnectionManagerOptions3 = httpClientConnectionManagerOptions;
            String $i$a$-requireNotNull-HttpClientConnectionManagerOptions$clientBootstrap$22 = "ClientBootstrap is required";
            throw new IllegalArgumentException($i$a$-requireNotNull-HttpClientConnectionManagerOptions$clientBootstrap$22.toString());
        }
        this.clientBootstrap = clientBootstrap;
        SocketOptions socketOptions = builder.getSocketOptions();
        if (socketOptions == null) {
            HttpClientConnectionManagerOptions httpClientConnectionManagerOptions = this;
            boolean $i$a$-requireNotNull-HttpClientConnectionManagerOptions$socketOptions$22 = false;
            HttpClientConnectionManagerOptions httpClientConnectionManagerOptions4 = httpClientConnectionManagerOptions;
            String $i$a$-requireNotNull-HttpClientConnectionManagerOptions$socketOptions$22 = "SocketOptions is required";
            throw new IllegalArgumentException($i$a$-requireNotNull-HttpClientConnectionManagerOptions$socketOptions$22.toString());
        }
        this.socketOptions = socketOptions;
        this.tlsContext = builder.getTlsContext();
        this.initialWindowSize = builder.getInitialWindowSize();
        this.maxConnections = builder.getMaxConnections();
        this.proxyOptions = builder.getProxyOptions();
        this.manualWindowManagement = builder.getManualWindowManagement();
        this.monitoringOptions = builder.getMonitoringOptions();
        this.maxConnectionIdleMs = builder.getMaxConnectionIdleMs();
        if (!(this.initialWindowSize > 0)) {
            boolean $i$a$-require-HttpClientConnectionManagerOptions$42 = false;
            String $i$a$-require-HttpClientConnectionManagerOptions$42 = "Window size must be > 0";
            throw new IllegalArgumentException($i$a$-require-HttpClientConnectionManagerOptions$42.toString());
        }
        if (!(this.maxConnections > 0)) {
            boolean $i$a$-require-HttpClientConnectionManagerOptions$52 = false;
            String $i$a$-require-HttpClientConnectionManagerOptions$52 = "Max connections must be > 0";
            throw new IllegalArgumentException($i$a$-require-HttpClientConnectionManagerOptions$52.toString());
        }
        if (!UriKt.isHttp(this.uri.getScheme())) {
            boolean $i$a$-require-HttpClientConnectionManagerOptions$62 = false;
            String $i$a$-require-HttpClientConnectionManagerOptions$62 = "URI has an unknown scheme: " + this.uri.getScheme();
            throw new IllegalArgumentException($i$a$-require-HttpClientConnectionManagerOptions$62.toString());
        }
        if (UriKt.requiresTls(this.uri.getScheme())) {
            if (this.tlsContext == null) {
                boolean bl = false;
                String string = "TlsContext required by URI scheme: " + this.uri.getScheme();
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @NotNull
    public final Uri getUri() {
        return this.uri;
    }

    @NotNull
    public final ClientBootstrap getClientBootstrap() {
        return this.clientBootstrap;
    }

    @NotNull
    public final SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    @Nullable
    public final TlsContext getTlsContext() {
        return this.tlsContext;
    }

    public final int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public final int getMaxConnections() {
        return this.maxConnections;
    }

    @Nullable
    public final HttpProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public final boolean getManualWindowManagement() {
        return this.manualWindowManagement;
    }

    @Nullable
    public final HttpMonitoringOptions getMonitoringOptions() {
        return this.monitoringOptions;
    }

    public final long getMaxConnectionIdleMs() {
        return this.maxConnectionIdleMs;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0006\u001a\u00020\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Laws/sdk/kotlin/crt/http/HttpClientConnectionManagerOptions$Companion;", "", "()V", "DEFAULT_INITIAL_WINDOW_SIZE", "", "DEFAULT_MAX_CONNECTIONS", "build", "Laws/sdk/kotlin/crt/http/HttpClientConnectionManagerOptions;", "block", "Lkotlin/Function1;", "Laws/sdk/kotlin/crt/http/HttpClientConnectionManagerOptionsBuilder;", "", "Lkotlin/ExtensionFunctionType;", "aws-crt-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpClientConnectionManagerOptions build(@NotNull Function1<? super HttpClientConnectionManagerOptionsBuilder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            HttpClientConnectionManagerOptionsBuilder httpClientConnectionManagerOptionsBuilder = new HttpClientConnectionManagerOptionsBuilder();
            block.invoke((Object)httpClientConnectionManagerOptionsBuilder);
            return httpClientConnectionManagerOptionsBuilder.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

