/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.crt.io;

import aws.sdk.kotlin.crt.io.TlsCipherPreference;
import aws.sdk.kotlin.crt.io.TlsContextOptions;
import aws.sdk.kotlin.crt.io.TlsVersion;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.crt.io.TlsContextOptions;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0007*\u00020\bH\u0002\u001a\f\u0010\u0005\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"isAlpnSupported", "", "isCipherSupported", "cipher", "Laws/sdk/kotlin/crt/io/TlsCipherPreference;", "into", "Lsoftware/amazon/awssdk/crt/io/TlsCipherPreference;", "Lsoftware/amazon/awssdk/crt/io/TlsContextOptions;", "Laws/sdk/kotlin/crt/io/TlsContextOptions;", "Lsoftware/amazon/awssdk/crt/io/TlsContextOptions$TlsVersions;", "Laws/sdk/kotlin/crt/io/TlsVersion;", "aws-crt-kotlin"})
public final class TlsContextJVMKt {
    public static final boolean isCipherSupported(@NotNull TlsCipherPreference cipher) {
        Intrinsics.checkNotNullParameter((Object)((Object)cipher), (String)"cipher");
        return software.amazon.awssdk.crt.io.TlsContextOptions.isCipherPreferenceSupported((software.amazon.awssdk.crt.io.TlsCipherPreference)TlsContextJVMKt.into(cipher));
    }

    public static final boolean isAlpnSupported() {
        return software.amazon.awssdk.crt.io.TlsContextOptions.isAlpnSupported();
    }

    private static final software.amazon.awssdk.crt.io.TlsCipherPreference into(TlsCipherPreference $this$into) {
        software.amazon.awssdk.crt.io.TlsCipherPreference tlsCipherPreference;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$into.ordinal()]) {
            case 1: {
                tlsCipherPreference = software.amazon.awssdk.crt.io.TlsCipherPreference.TLS_CIPHER_SYSTEM_DEFAULT;
                break;
            }
            case 2: {
                tlsCipherPreference = software.amazon.awssdk.crt.io.TlsCipherPreference.TLS_CIPHER_KMS_PQ_TLSv1_0_2019_06;
                break;
            }
            case 3: {
                tlsCipherPreference = software.amazon.awssdk.crt.io.TlsCipherPreference.TLS_CIPHER_PREF_KMS_PQ_SIKE_TLSv1_0_2019_11;
                break;
            }
            case 4: {
                tlsCipherPreference = software.amazon.awssdk.crt.io.TlsCipherPreference.TLS_CIPHER_PREF_KMS_PQ_TLSv1_0_2020_02;
                break;
            }
            case 5: {
                tlsCipherPreference = software.amazon.awssdk.crt.io.TlsCipherPreference.TLS_CIPHER_PREF_KMS_PQ_SIKE_TLSv1_0_2020_02;
                break;
            }
            case 6: {
                tlsCipherPreference = software.amazon.awssdk.crt.io.TlsCipherPreference.TLS_CIPHER_PREF_KMS_PQ_TLSv1_0_2020_07;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return tlsCipherPreference;
    }

    private static final TlsContextOptions.TlsVersions into(TlsVersion $this$into) {
        TlsContextOptions.TlsVersions tlsVersions;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$into.ordinal()]) {
            case 1: {
                tlsVersions = TlsContextOptions.TlsVersions.SSLv3;
                break;
            }
            case 2: {
                tlsVersions = TlsContextOptions.TlsVersions.TLSv1;
                break;
            }
            case 3: {
                tlsVersions = TlsContextOptions.TlsVersions.TLSv1_1;
                break;
            }
            case 4: {
                tlsVersions = TlsContextOptions.TlsVersions.TLSv1_2;
                break;
            }
            case 5: {
                tlsVersions = TlsContextOptions.TlsVersions.TLSv1_3;
                break;
            }
            case 6: {
                tlsVersions = TlsContextOptions.TlsVersions.TLS_VER_SYS_DEFAULTS;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return tlsVersions;
    }

    private static final software.amazon.awssdk.crt.io.TlsContextOptions into(TlsContextOptions $this$into) {
        TlsContextOptions kopts = $this$into;
        software.amazon.awssdk.crt.io.TlsContextOptions jniOpts = null;
        if (kopts.getCertificate() != null && kopts.getPrivateKey() != null) {
            software.amazon.awssdk.crt.io.TlsContextOptions tlsContextOptions = software.amazon.awssdk.crt.io.TlsContextOptions.createWithMtls((String)kopts.getCertificate(), (String)kopts.getPrivateKey());
            Intrinsics.checkNotNullExpressionValue((Object)tlsContextOptions, (String)"createWithMtls(kopts.cer\u2026ficate, kopts.privateKey)");
            jniOpts = tlsContextOptions;
        } else if (kopts.getCertificatePath() != null && kopts.getPrivateKeyPath() != null) {
            software.amazon.awssdk.crt.io.TlsContextOptions tlsContextOptions = software.amazon.awssdk.crt.io.TlsContextOptions.createWithMtlsFromPath((String)kopts.getCertificatePath(), (String)kopts.getPrivateKeyPath());
            Intrinsics.checkNotNullExpressionValue((Object)tlsContextOptions, (String)"createWithMtlsFromPath(k\u2026th, kopts.privateKeyPath)");
            jniOpts = tlsContextOptions;
        } else {
            software.amazon.awssdk.crt.io.TlsContextOptions tlsContextOptions = software.amazon.awssdk.crt.io.TlsContextOptions.createDefaultClient();
            Intrinsics.checkNotNullExpressionValue((Object)tlsContextOptions, (String)"createDefaultClient()");
            jniOpts = tlsContextOptions;
        }
        if (kopts.getCaRoot() != null) {
            jniOpts.withCertificateAuthority(kopts.getCaRoot());
        } else if (kopts.getCaFile() != null || kopts.getCaDir() != null) {
            jniOpts.withCertificateAuthorityFromPath(kopts.getCaFile(), kopts.getCaDir());
        }
        jniOpts.withMinimumTlsVersion(TlsContextJVMKt.into(kopts.getMinTlsVersion())).withCipherPreference(TlsContextJVMKt.into(kopts.getTlsCipherPreference())).withVerifyPeer(kopts.getVerifyPeer());
        if (((CharSequence)kopts.getAlpn()).length() > 0) {
            jniOpts.withAlpnList(kopts.getAlpn());
        }
        return jniOpts;
    }

    public static final /* synthetic */ software.amazon.awssdk.crt.io.TlsContextOptions access$into(TlsContextOptions $receiver) {
        return TlsContextJVMKt.into($receiver);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TlsCipherPreference.values().length];
            nArray[TlsCipherPreference.SYSTEM_DEFAULT.ordinal()] = 1;
            nArray[TlsCipherPreference.KMS_PQ_TLSv1_0_2019_06.ordinal()] = 2;
            nArray[TlsCipherPreference.KMS_PQ_SIKE_TLSv1_0_2019_11.ordinal()] = 3;
            nArray[TlsCipherPreference.KMS_PQ_TLSv1_0_2020_02.ordinal()] = 4;
            nArray[TlsCipherPreference.KMS_PQ_SIKE_TLSv1_0_2020_02.ordinal()] = 5;
            nArray[TlsCipherPreference.KMS_PQ_TLSv1_0_2020_07.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TlsVersion.values().length];
            nArray[TlsVersion.SSLv3.ordinal()] = 1;
            nArray[TlsVersion.TLSv1.ordinal()] = 2;
            nArray[TlsVersion.TLSv1_1.ordinal()] = 3;
            nArray[TlsVersion.TLSv1_2.ordinal()] = 4;
            nArray[TlsVersion.TLSv1_3.ordinal()] = 5;
            nArray[TlsVersion.SYS_DEFAULT.ordinal()] = 6;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

