/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.crt.io;

import aws.sdk.kotlin.crt.io.TlsCipherPreference;
import aws.sdk.kotlin.crt.io.TlsContextOptions;
import aws.sdk.kotlin.crt.io.TlsVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u00107\u001a\u000208R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\u001c\u0010!\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0006\"\u0004\b#\u0010\bR\u001c\u0010$\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010\bR\u001c\u0010'\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0006\"\u0004\b)\u0010\bR$\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020+@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u00069"}, d2={"Laws/sdk/kotlin/crt/io/TlsContextOptionsBuilder;", "", "()V", "alpn", "", "getAlpn", "()Ljava/lang/String;", "setAlpn", "(Ljava/lang/String;)V", "caDir", "getCaDir", "setCaDir", "caFile", "getCaFile", "setCaFile", "caRoot", "getCaRoot", "setCaRoot", "certificate", "getCertificate", "setCertificate", "certificatePath", "getCertificatePath", "setCertificatePath", "minTlsVersion", "Laws/sdk/kotlin/crt/io/TlsVersion;", "getMinTlsVersion", "()Laws/sdk/kotlin/crt/io/TlsVersion;", "setMinTlsVersion", "(Laws/sdk/kotlin/crt/io/TlsVersion;)V", "pkcs12Password", "getPkcs12Password", "setPkcs12Password", "pkcs12Path", "getPkcs12Path", "setPkcs12Path", "privateKey", "getPrivateKey", "setPrivateKey", "privateKeyPath", "getPrivateKeyPath", "setPrivateKeyPath", "value", "Laws/sdk/kotlin/crt/io/TlsCipherPreference;", "tlsCipherPreference", "getTlsCipherPreference", "()Laws/sdk/kotlin/crt/io/TlsCipherPreference;", "setTlsCipherPreference", "(Laws/sdk/kotlin/crt/io/TlsCipherPreference;)V", "verifyPeer", "", "getVerifyPeer", "()Z", "setVerifyPeer", "(Z)V", "build", "Laws/sdk/kotlin/crt/io/TlsContextOptions;", "aws-crt-kotlin"})
public final class TlsContextOptionsBuilder {
    @NotNull
    private TlsVersion minTlsVersion = TlsVersion.SYS_DEFAULT;
    @NotNull
    private TlsCipherPreference tlsCipherPreference = TlsCipherPreference.SYSTEM_DEFAULT;
    @NotNull
    private String alpn = "";
    private boolean verifyPeer = true;
    @Nullable
    private String certificate;
    @Nullable
    private String privateKey;
    @Nullable
    private String certificatePath;
    @Nullable
    private String privateKeyPath;
    @Nullable
    private String caRoot;
    @Nullable
    private String caFile;
    @Nullable
    private String caDir;
    @Nullable
    private String pkcs12Path;
    @Nullable
    private String pkcs12Password;

    @NotNull
    public final TlsContextOptions build() {
        return new TlsContextOptions(this);
    }

    @NotNull
    public final TlsVersion getMinTlsVersion() {
        return this.minTlsVersion;
    }

    public final void setMinTlsVersion(@NotNull TlsVersion tlsVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)tlsVersion), (String)"<set-?>");
        this.minTlsVersion = tlsVersion;
    }

    @NotNull
    public final TlsCipherPreference getTlsCipherPreference() {
        return this.tlsCipherPreference;
    }

    public final void setTlsCipherPreference(@NotNull TlsCipherPreference value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (!TlsContextOptions.Companion.isCipherPreferenceSupported(value)) {
            throw new IllegalArgumentException("TlsCipherPreference is not supported on this platform: " + (Object)((Object)value));
        }
        if (this.minTlsVersion != TlsVersion.SYS_DEFAULT && value != TlsCipherPreference.SYSTEM_DEFAULT) {
            throw new IllegalArgumentException("Currently only setting of either minimumTlsVersion or cipherPreference is supported, not both.");
        }
        this.tlsCipherPreference = value;
    }

    @NotNull
    public final String getAlpn() {
        return this.alpn;
    }

    public final void setAlpn(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.alpn = string;
    }

    public final boolean getVerifyPeer() {
        return this.verifyPeer;
    }

    public final void setVerifyPeer(boolean bl) {
        this.verifyPeer = bl;
    }

    @Nullable
    public final String getCertificate() {
        return this.certificate;
    }

    public final void setCertificate(@Nullable String string) {
        this.certificate = string;
    }

    @Nullable
    public final String getPrivateKey() {
        return this.privateKey;
    }

    public final void setPrivateKey(@Nullable String string) {
        this.privateKey = string;
    }

    @Nullable
    public final String getCertificatePath() {
        return this.certificatePath;
    }

    public final void setCertificatePath(@Nullable String string) {
        this.certificatePath = string;
    }

    @Nullable
    public final String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public final void setPrivateKeyPath(@Nullable String string) {
        this.privateKeyPath = string;
    }

    @Nullable
    public final String getCaRoot() {
        return this.caRoot;
    }

    public final void setCaRoot(@Nullable String string) {
        this.caRoot = string;
    }

    @Nullable
    public final String getCaFile() {
        return this.caFile;
    }

    public final void setCaFile(@Nullable String string) {
        this.caFile = string;
    }

    @Nullable
    public final String getCaDir() {
        return this.caDir;
    }

    public final void setCaDir(@Nullable String string) {
        this.caDir = string;
    }

    @Nullable
    public final String getPkcs12Path() {
        return this.pkcs12Path;
    }

    public final void setPkcs12Path(@Nullable String string) {
        this.pkcs12Path = string;
    }

    @Nullable
    public final String getPkcs12Password() {
        return this.pkcs12Password;
    }

    public final void setPkcs12Password(@Nullable String string) {
        this.pkcs12Password = string;
    }
}

