// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Provides information that defines an OpenSearch endpoint.
 */
class ElasticsearchSettings private constructor(builder: Builder) {
    /**
     * The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport
     * protocol (http/https) is not specified.
     */
    val endpointUri: kotlin.String? = builder.endpointUri
    /**
     * The maximum number of seconds for which DMS retries failed API requests to the
     * OpenSearch cluster.
     */
    val errorRetryDuration: kotlin.Int? = builder.errorRetryDuration
    /**
     * The maximum percentage of records that can fail to be written before a full load
     * operation stops.
     * To avoid early failure, this counter is only effective after 1000 records
     * are transferred. OpenSearch also has the concept of error monitoring during the
     * last 10 minutes of an Observation Window. If transfer of all records fail in the
     * last 10 minutes, the full load operation stops.
     */
    val fullLoadErrorPercentage: kotlin.Int? = builder.fullLoadErrorPercentage
    /**
     * The Amazon Resource Name (ARN) used by the service to access the IAM role.
     * The role must allow the iam:PassRole action.
     */
    val serviceAccessRoleArn: kotlin.String? = builder.serviceAccessRoleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ElasticsearchSettings(")
        append("endpointUri=$endpointUri,")
        append("errorRetryDuration=$errorRetryDuration,")
        append("fullLoadErrorPercentage=$fullLoadErrorPercentage,")
        append("serviceAccessRoleArn=$serviceAccessRoleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointUri?.hashCode() ?: 0
        result = 31 * result + (errorRetryDuration ?: 0)
        result = 31 * result + (fullLoadErrorPercentage ?: 0)
        result = 31 * result + (serviceAccessRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ElasticsearchSettings

        if (endpointUri != other.endpointUri) return false
        if (errorRetryDuration != other.errorRetryDuration) return false
        if (fullLoadErrorPercentage != other.fullLoadErrorPercentage) return false
        if (serviceAccessRoleArn != other.serviceAccessRoleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport
         * protocol (http/https) is not specified.
         */
        var endpointUri: kotlin.String? = null
        /**
         * The maximum number of seconds for which DMS retries failed API requests to the
         * OpenSearch cluster.
         */
        var errorRetryDuration: kotlin.Int? = null
        /**
         * The maximum percentage of records that can fail to be written before a full load
         * operation stops.
         * To avoid early failure, this counter is only effective after 1000 records
         * are transferred. OpenSearch also has the concept of error monitoring during the
         * last 10 minutes of an Observation Window. If transfer of all records fail in the
         * last 10 minutes, the full load operation stops.
         */
        var fullLoadErrorPercentage: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) used by the service to access the IAM role.
         * The role must allow the iam:PassRole action.
         */
        var serviceAccessRoleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings) : this() {
            this.endpointUri = x.endpointUri
            this.errorRetryDuration = x.errorRetryDuration
            this.fullLoadErrorPercentage = x.fullLoadErrorPercentage
            this.serviceAccessRoleArn = x.serviceAccessRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings = ElasticsearchSettings(this)
    }
}
