// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Provides information that defines an IBM Db2 LUW endpoint.
 */
class IbmDb2Settings private constructor(builder: Builder) {
    /**
     * For ongoing replication (CDC), use CurrentLSN to specify a
     * log sequence number (LSN) where you want the replication
     * to start.
     */
    val currentLsn: kotlin.String? = builder.currentLsn
    /**
     * Database name for the endpoint.
     */
    val databaseName: kotlin.String? = builder.databaseName
    /**
     * Maximum number of bytes per read, as a NUMBER value.
     * The default is 64 KB.
     */
    val maxKBytesPerRead: kotlin.Int? = builder.maxKBytesPerRead
    /**
     * Endpoint connection password.
     */
    val password: kotlin.String? = builder.password
    /**
     * Endpoint TCP port. The default value is 50000.
     */
    val port: kotlin.Int? = builder.port
    /**
     * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
     * trusted entity and grants the required permissions to access the value in
     * SecretsManagerSecret. The role must allow the iam:PassRole action.
     * SecretsManagerSecret has the value of
     * the Amazon Web Services Secrets Manager secret that allows access to the Db2 LUW endpoint.
     *
     * You can specify one of two sets of values for these permissions. You can specify the
     * values for this setting and SecretsManagerSecretId. Or you can specify
     * clear-text values for UserName, Password,
     * ServerName, and Port. You can't specify both. For more
     * information on creating this SecretsManagerSecret and the
     * SecretsManagerAccessRoleArn and SecretsManagerSecretId
     * required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
     * resources in the Database Migration Service User
     * Guide.
     */
    val secretsManagerAccessRoleArn: kotlin.String? = builder.secretsManagerAccessRoleArn
    /**
     * The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that contains the Db2 LUW endpoint connection details.
     */
    val secretsManagerSecretId: kotlin.String? = builder.secretsManagerSecretId
    /**
     * Fully qualified domain name of the endpoint.
     */
    val serverName: kotlin.String? = builder.serverName
    /**
     * Enables ongoing replication (CDC) as a BOOLEAN value. The
     * default is true.
     */
    val setDataCaptureChanges: kotlin.Boolean? = builder.setDataCaptureChanges
    /**
     * Endpoint connection user name.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IbmDb2Settings(")
        append("currentLsn=$currentLsn,")
        append("databaseName=$databaseName,")
        append("maxKBytesPerRead=$maxKBytesPerRead,")
        append("password=*** Sensitive Data Redacted ***,")
        append("port=$port,")
        append("secretsManagerAccessRoleArn=$secretsManagerAccessRoleArn,")
        append("secretsManagerSecretId=$secretsManagerSecretId,")
        append("serverName=$serverName,")
        append("setDataCaptureChanges=$setDataCaptureChanges,")
        append("username=$username)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentLsn?.hashCode() ?: 0
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (maxKBytesPerRead ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (secretsManagerAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerSecretId?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (setDataCaptureChanges?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IbmDb2Settings

        if (currentLsn != other.currentLsn) return false
        if (databaseName != other.databaseName) return false
        if (maxKBytesPerRead != other.maxKBytesPerRead) return false
        if (password != other.password) return false
        if (port != other.port) return false
        if (secretsManagerAccessRoleArn != other.secretsManagerAccessRoleArn) return false
        if (secretsManagerSecretId != other.secretsManagerSecretId) return false
        if (serverName != other.serverName) return false
        if (setDataCaptureChanges != other.setDataCaptureChanges) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings = Builder(this).apply(block).build()

    class Builder {
        /**
         * For ongoing replication (CDC), use CurrentLSN to specify a
         * log sequence number (LSN) where you want the replication
         * to start.
         */
        var currentLsn: kotlin.String? = null
        /**
         * Database name for the endpoint.
         */
        var databaseName: kotlin.String? = null
        /**
         * Maximum number of bytes per read, as a NUMBER value.
         * The default is 64 KB.
         */
        var maxKBytesPerRead: kotlin.Int? = null
        /**
         * Endpoint connection password.
         */
        var password: kotlin.String? = null
        /**
         * Endpoint TCP port. The default value is 50000.
         */
        var port: kotlin.Int? = null
        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
         * trusted entity and grants the required permissions to access the value in
         * SecretsManagerSecret. The role must allow the iam:PassRole action.
         * SecretsManagerSecret has the value of
         * the Amazon Web Services Secrets Manager secret that allows access to the Db2 LUW endpoint.
         *
         * You can specify one of two sets of values for these permissions. You can specify the
         * values for this setting and SecretsManagerSecretId. Or you can specify
         * clear-text values for UserName, Password,
         * ServerName, and Port. You can't specify both. For more
         * information on creating this SecretsManagerSecret and the
         * SecretsManagerAccessRoleArn and SecretsManagerSecretId
         * required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
         * resources in the Database Migration Service User
         * Guide.
         */
        var secretsManagerAccessRoleArn: kotlin.String? = null
        /**
         * The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that contains the Db2 LUW endpoint connection details.
         */
        var secretsManagerSecretId: kotlin.String? = null
        /**
         * Fully qualified domain name of the endpoint.
         */
        var serverName: kotlin.String? = null
        /**
         * Enables ongoing replication (CDC) as a BOOLEAN value. The
         * default is true.
         */
        var setDataCaptureChanges: kotlin.Boolean? = null
        /**
         * Endpoint connection user name.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings) : this() {
            this.currentLsn = x.currentLsn
            this.databaseName = x.databaseName
            this.maxKBytesPerRead = x.maxKBytesPerRead
            this.password = x.password
            this.port = x.port
            this.secretsManagerAccessRoleArn = x.secretsManagerAccessRoleArn
            this.secretsManagerSecretId = x.secretsManagerSecretId
            this.serverName = x.serverName
            this.setDataCaptureChanges = x.setDataCaptureChanges
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings = IbmDb2Settings(this)
    }
}
