// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



class ImportCertificateRequest private constructor(builder: Builder) {
    /**
     * A customer-assigned name for the certificate. Identifiers must begin with a letter and
     * must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
     * contain two consecutive hyphens.
     */
    val certificateIdentifier: kotlin.String? = builder.certificateIdentifier
    /**
     * The contents of a .pem file, which contains an X.509 certificate.
     */
    val certificatePem: kotlin.String? = builder.certificatePem
    /**
     * The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a .sso file
     * using the fileb:// prefix. You can't provide the certificate inline.
     * Example: filebase64("${path.root}/rds-ca-2019-root.sso")
     */
    val certificateWallet: kotlin.ByteArray? = builder.certificateWallet
    /**
     * The tags associated with the certificate.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ImportCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportCertificateRequest(")
        append("certificateIdentifier=$certificateIdentifier,")
        append("certificatePem=*** Sensitive Data Redacted ***,")
        append("certificateWallet=$certificateWallet,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateIdentifier?.hashCode() ?: 0
        result = 31 * result + (certificatePem?.hashCode() ?: 0)
        result = 31 * result + (certificateWallet?.contentHashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportCertificateRequest

        if (certificateIdentifier != other.certificateIdentifier) return false
        if (certificatePem != other.certificatePem) return false
        if (certificateWallet != null) {
            if (other.certificateWallet == null) return false
            if (!certificateWallet.contentEquals(other.certificateWallet)) return false
        } else if (other.certificateWallet != null) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ImportCertificateRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A customer-assigned name for the certificate. Identifiers must begin with a letter and
         * must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
         * contain two consecutive hyphens.
         */
        var certificateIdentifier: kotlin.String? = null
        /**
         * The contents of a .pem file, which contains an X.509 certificate.
         */
        var certificatePem: kotlin.String? = null
        /**
         * The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a .sso file
         * using the fileb:// prefix. You can't provide the certificate inline.
         * Example: filebase64("${path.root}/rds-ca-2019-root.sso")
         */
        var certificateWallet: kotlin.ByteArray? = null
        /**
         * The tags associated with the certificate.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ImportCertificateRequest) : this() {
            this.certificateIdentifier = x.certificateIdentifier
            this.certificatePem = x.certificatePem
            this.certificateWallet = x.certificateWallet
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ImportCertificateRequest = ImportCertificateRequest(this)
    }
}
