// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 *
 */
class ModifyEndpointRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     */
    val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.
     */
    val databaseName: kotlin.String? = builder.databaseName
    /**
     * The settings in JSON format for the DMS transfer type of source endpoint.
     * Attributes include the following:
     *
     *
     * serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the iam:PassRole action.
     *
     * BucketName - The name of the S3 bucket to use.
     *
     *
     * Shorthand syntax for these settings is as follows: ServiceAccessRoleArn=string
     * ,BucketName=string
     *
     * JSON syntax for these settings is as follows: { "ServiceAccessRoleArn": "string",
     * "BucketName": "string"}
     */
    val dmsTransferSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings? = builder.dmsTransferSettings
    /**
     * Settings in JSON format for the source DocumentDB endpoint. For more information about the
     * available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service
     * in the Database Migration Service User
     * Guide.
     */
    val docDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings? = builder.docDbSettings
    /**
     * Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
     * available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
     * Data to DynamoDB in the Database Migration Service User
     * Guide.
     */
    val dynamoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings? = builder.dynamoDbSettings
    /**
     * Settings in JSON format for the target OpenSearch endpoint. For more information
     * about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for DMS in
     * the Database Migration Service User Guide.
     */
    val elasticsearchSettings: aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings? = builder.elasticsearchSettings
    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     */
    val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The database endpoint identifier. Identifiers must begin with a letter and must contain
     * only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
     * consecutive hyphens.
     */
    val endpointIdentifier: kotlin.String? = builder.endpointIdentifier
    /**
     * The type of endpoint.  Valid values are source and target.
     */
    val endpointType: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationEndpointTypeValue? = builder.endpointType
    /**
     * The type of engine for the endpoint. Valid values, depending on the EndpointType,
     * include
     * "mysql", "oracle", "postgres",
     * "mariadb", "aurora", "aurora-postgresql", "opensearch",
     * "redshift", "s3", "db2", "azuredb",
     * "sybase", "dynamodb", "mongodb",
     * "kinesis", "kafka", "elasticsearch",
     * "documentdb", "sqlserver", and "neptune".
     */
    val engineName: kotlin.String? = builder.engineName
    /**
     * If this attribute is Y, the current call to ModifyEndpoint replaces all
     * existing endpoint settings with the exact settings that you specify in this call. If this
     * attribute is N, the current call to ModifyEndpoint does two things:
     *
     *
     * It replaces any endpoint settings that already exist with new values, for settings with the
     * same names.
     *
     * It creates new endpoint settings that you specify in the call, for settings with different
     * names.
     *
     *
     * For example, if you call create-endpoint ... --endpoint-settings '{"a":1}'
     * ..., the endpoint has the following endpoint settings: '{"a":1}'. If
     * you then call modify-endpoint ... --endpoint-settings '{"b":2}' ... for the
     * same endpoint, the endpoint has the following settings: '{"a":1,"b":2}'.
     * However, suppose that you follow this with a call to modify-endpoint ...
     * --endpoint-settings '{"b":2}' --exact-settings ... for that same endpoint again.
     * Then the endpoint has the following settings: '{"b":2}'. All existing settings
     * are replaced with the exact settings that you specify.
     */
    val exactSettings: kotlin.Boolean? = builder.exactSettings
    /**
     * The external table definition.
     */
    val externalTableDefinition: kotlin.String? = builder.externalTableDefinition
    /**
     * Additional attributes associated with the connection. To reset this parameter, pass the
     * empty string ("") as an argument.
     */
    val extraConnectionAttributes: kotlin.String? = builder.extraConnectionAttributes
    /**
     * Settings in JSON format for the source GCP MySQL endpoint.
     */
    val gcpMySqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.GcpMySqlSettings? = builder.gcpMySqlSettings
    /**
     * Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
     * available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
     * when using Db2 LUW as a source for DMS in the Database Migration Service
     * User Guide.
     */
    val ibmDb2Settings: aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings? = builder.ibmDb2Settings
    /**
     * Settings in JSON format for the target Apache Kafka endpoint. For more information about
     * the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
     * to migrate data to a Kafka topic in the Database Migration Service User Guide.
     */
    val kafkaSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings? = builder.kafkaSettings
    /**
     * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
     * more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
     * migrate data to a Kinesis data stream in the Database Migration Service User Guide.
     */
    val kinesisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings? = builder.kinesisSettings
    /**
     * Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
     * information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
     * attributes when using SQL Server as a source for DMS and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
     * Extra connection attributes when using SQL Server as a target for DMS in the
     * Database Migration Service User Guide.
     */
    val microsoftSqlServerSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings? = builder.microsoftSqlServerSettings
    /**
     * Settings in JSON format for the source MongoDB endpoint. For more information about the
     * available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
     * when using MongoDB as a source for Database Migration Service in the
     * Database Migration Service User Guide.
     */
    val mongoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings? = builder.mongoDbSettings
    /**
     * Settings in JSON format for the source and target MySQL endpoint. For information about
     * other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection
     * attributes when using MySQL as a source for DMS and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra
     * connection attributes when using a MySQL-compatible database as a target for DMS in the Database Migration Service User
     * Guide.
     */
    val mySqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings? = builder.mySqlSettings
    /**
     * Settings in JSON format for the target Amazon Neptune endpoint. For more information
     * about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target
     * in the Database Migration Service User Guide.
     */
    val neptuneSettings: aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings? = builder.neptuneSettings
    /**
     * Settings in JSON format for the source and target Oracle endpoint. For information about
     * other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection
     * attributes when using Oracle as a source for DMS and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
     * Extra connection attributes when using Oracle as a target for DMS in the
     * Database Migration Service User Guide.
     */
    val oracleSettings: aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings? = builder.oracleSettings
    /**
     * The password to be used to login to the endpoint database.
     */
    val password: kotlin.String? = builder.password
    /**
     * The port used by the endpoint database.
     */
    val port: kotlin.Int? = builder.port
    /**
     * Settings in JSON format for the source and target PostgreSQL endpoint. For information
     * about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
     * attributes when using PostgreSQL as a source for DMS and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
     * Extra connection attributes when using PostgreSQL as a target for DMS in the
     * Database Migration Service User Guide.
     */
    val postgreSqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings? = builder.postgreSqlSettings
    /**
     * Settings in JSON format for the Redis target endpoint.
     */
    val redisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings? = builder.redisSettings
    /**
     * Provides information that defines an Amazon Redshift endpoint.
     */
    val redshiftSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings? = builder.redshiftSettings
    /**
     * Settings in JSON format for the target Amazon S3 endpoint. For more information about
     * the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
     * Connection Attributes When Using Amazon S3 as a Target for DMS in the
     * Database Migration Service User Guide.
     */
    val s3Settings: aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings? = builder.s3Settings
    /**
     * The name of the server where the endpoint database resides.
     */
    val serverName: kotlin.String? = builder.serverName
    /**
     * The Amazon Resource Name (ARN) for the IAM role you want to use to modify
     * the endpoint. The role must allow the iam:PassRole action.
     */
    val serviceAccessRoleArn: kotlin.String? = builder.serviceAccessRoleArn
    /**
     * The SSL mode used to connect to the endpoint.  The default value is none.
     */
    val sslMode: aws.sdk.kotlin.services.databasemigrationservice.model.DmsSslModeValue? = builder.sslMode
    /**
     * Settings in JSON format for the source and target SAP ASE endpoint. For information
     * about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
     * when using SAP ASE as a source for DMS and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
     * when using SAP ASE as a target for DMS in the Database Migration Service
     * User Guide.
     */
    val sybaseSettings: aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings? = builder.sybaseSettings
    /**
     * The user name to be used to login to the endpoint database.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ModifyEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyEndpointRequest(")
        append("certificateArn=$certificateArn,")
        append("databaseName=$databaseName,")
        append("dmsTransferSettings=$dmsTransferSettings,")
        append("docDbSettings=$docDbSettings,")
        append("dynamoDbSettings=$dynamoDbSettings,")
        append("elasticsearchSettings=$elasticsearchSettings,")
        append("endpointArn=$endpointArn,")
        append("endpointIdentifier=$endpointIdentifier,")
        append("endpointType=$endpointType,")
        append("engineName=$engineName,")
        append("exactSettings=$exactSettings,")
        append("externalTableDefinition=$externalTableDefinition,")
        append("extraConnectionAttributes=$extraConnectionAttributes,")
        append("gcpMySqlSettings=$gcpMySqlSettings,")
        append("ibmDb2Settings=$ibmDb2Settings,")
        append("kafkaSettings=$kafkaSettings,")
        append("kinesisSettings=$kinesisSettings,")
        append("microsoftSqlServerSettings=$microsoftSqlServerSettings,")
        append("mongoDbSettings=$mongoDbSettings,")
        append("mySqlSettings=$mySqlSettings,")
        append("neptuneSettings=$neptuneSettings,")
        append("oracleSettings=$oracleSettings,")
        append("password=*** Sensitive Data Redacted ***,")
        append("port=$port,")
        append("postgreSqlSettings=$postgreSqlSettings,")
        append("redisSettings=$redisSettings,")
        append("redshiftSettings=$redshiftSettings,")
        append("s3Settings=$s3Settings,")
        append("serverName=$serverName,")
        append("serviceAccessRoleArn=$serviceAccessRoleArn,")
        append("sslMode=$sslMode,")
        append("sybaseSettings=$sybaseSettings,")
        append("username=$username)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dmsTransferSettings?.hashCode() ?: 0)
        result = 31 * result + (docDbSettings?.hashCode() ?: 0)
        result = 31 * result + (dynamoDbSettings?.hashCode() ?: 0)
        result = 31 * result + (elasticsearchSettings?.hashCode() ?: 0)
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (endpointIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (engineName?.hashCode() ?: 0)
        result = 31 * result + (exactSettings?.hashCode() ?: 0)
        result = 31 * result + (externalTableDefinition?.hashCode() ?: 0)
        result = 31 * result + (extraConnectionAttributes?.hashCode() ?: 0)
        result = 31 * result + (gcpMySqlSettings?.hashCode() ?: 0)
        result = 31 * result + (ibmDb2Settings?.hashCode() ?: 0)
        result = 31 * result + (kafkaSettings?.hashCode() ?: 0)
        result = 31 * result + (kinesisSettings?.hashCode() ?: 0)
        result = 31 * result + (microsoftSqlServerSettings?.hashCode() ?: 0)
        result = 31 * result + (mongoDbSettings?.hashCode() ?: 0)
        result = 31 * result + (mySqlSettings?.hashCode() ?: 0)
        result = 31 * result + (neptuneSettings?.hashCode() ?: 0)
        result = 31 * result + (oracleSettings?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (postgreSqlSettings?.hashCode() ?: 0)
        result = 31 * result + (redisSettings?.hashCode() ?: 0)
        result = 31 * result + (redshiftSettings?.hashCode() ?: 0)
        result = 31 * result + (s3Settings?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (serviceAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (sslMode?.hashCode() ?: 0)
        result = 31 * result + (sybaseSettings?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyEndpointRequest

        if (certificateArn != other.certificateArn) return false
        if (databaseName != other.databaseName) return false
        if (dmsTransferSettings != other.dmsTransferSettings) return false
        if (docDbSettings != other.docDbSettings) return false
        if (dynamoDbSettings != other.dynamoDbSettings) return false
        if (elasticsearchSettings != other.elasticsearchSettings) return false
        if (endpointArn != other.endpointArn) return false
        if (endpointIdentifier != other.endpointIdentifier) return false
        if (endpointType != other.endpointType) return false
        if (engineName != other.engineName) return false
        if (exactSettings != other.exactSettings) return false
        if (externalTableDefinition != other.externalTableDefinition) return false
        if (extraConnectionAttributes != other.extraConnectionAttributes) return false
        if (gcpMySqlSettings != other.gcpMySqlSettings) return false
        if (ibmDb2Settings != other.ibmDb2Settings) return false
        if (kafkaSettings != other.kafkaSettings) return false
        if (kinesisSettings != other.kinesisSettings) return false
        if (microsoftSqlServerSettings != other.microsoftSqlServerSettings) return false
        if (mongoDbSettings != other.mongoDbSettings) return false
        if (mySqlSettings != other.mySqlSettings) return false
        if (neptuneSettings != other.neptuneSettings) return false
        if (oracleSettings != other.oracleSettings) return false
        if (password != other.password) return false
        if (port != other.port) return false
        if (postgreSqlSettings != other.postgreSqlSettings) return false
        if (redisSettings != other.redisSettings) return false
        if (redshiftSettings != other.redshiftSettings) return false
        if (s3Settings != other.s3Settings) return false
        if (serverName != other.serverName) return false
        if (serviceAccessRoleArn != other.serviceAccessRoleArn) return false
        if (sslMode != other.sslMode) return false
        if (sybaseSettings != other.sybaseSettings) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ModifyEndpointRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         */
        var certificateArn: kotlin.String? = null
        /**
         * The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.
         */
        var databaseName: kotlin.String? = null
        /**
         * The settings in JSON format for the DMS transfer type of source endpoint.
         * Attributes include the following:
         *
         *
         * serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the iam:PassRole action.
         *
         * BucketName - The name of the S3 bucket to use.
         *
         *
         * Shorthand syntax for these settings is as follows: ServiceAccessRoleArn=string
         * ,BucketName=string
         *
         * JSON syntax for these settings is as follows: { "ServiceAccessRoleArn": "string",
         * "BucketName": "string"}
         */
        var dmsTransferSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings? = null
        /**
         * Settings in JSON format for the source DocumentDB endpoint. For more information about the
         * available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service
         * in the Database Migration Service User
         * Guide.
         */
        var docDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings? = null
        /**
         * Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
         * available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
         * Data to DynamoDB in the Database Migration Service User
         * Guide.
         */
        var dynamoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings? = null
        /**
         * Settings in JSON format for the target OpenSearch endpoint. For more information
         * about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for DMS in
         * the Database Migration Service User Guide.
         */
        var elasticsearchSettings: aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings? = null
        /**
         * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         */
        var endpointArn: kotlin.String? = null
        /**
         * The database endpoint identifier. Identifiers must begin with a letter and must contain
         * only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
         * consecutive hyphens.
         */
        var endpointIdentifier: kotlin.String? = null
        /**
         * The type of endpoint.  Valid values are source and target.
         */
        var endpointType: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationEndpointTypeValue? = null
        /**
         * The type of engine for the endpoint. Valid values, depending on the EndpointType,
         * include
         * "mysql", "oracle", "postgres",
         * "mariadb", "aurora", "aurora-postgresql", "opensearch",
         * "redshift", "s3", "db2", "azuredb",
         * "sybase", "dynamodb", "mongodb",
         * "kinesis", "kafka", "elasticsearch",
         * "documentdb", "sqlserver", and "neptune".
         */
        var engineName: kotlin.String? = null
        /**
         * If this attribute is Y, the current call to ModifyEndpoint replaces all
         * existing endpoint settings with the exact settings that you specify in this call. If this
         * attribute is N, the current call to ModifyEndpoint does two things:
         *
         *
         * It replaces any endpoint settings that already exist with new values, for settings with the
         * same names.
         *
         * It creates new endpoint settings that you specify in the call, for settings with different
         * names.
         *
         *
         * For example, if you call create-endpoint ... --endpoint-settings '{"a":1}'
         * ..., the endpoint has the following endpoint settings: '{"a":1}'. If
         * you then call modify-endpoint ... --endpoint-settings '{"b":2}' ... for the
         * same endpoint, the endpoint has the following settings: '{"a":1,"b":2}'.
         * However, suppose that you follow this with a call to modify-endpoint ...
         * --endpoint-settings '{"b":2}' --exact-settings ... for that same endpoint again.
         * Then the endpoint has the following settings: '{"b":2}'. All existing settings
         * are replaced with the exact settings that you specify.
         */
        var exactSettings: kotlin.Boolean? = null
        /**
         * The external table definition.
         */
        var externalTableDefinition: kotlin.String? = null
        /**
         * Additional attributes associated with the connection. To reset this parameter, pass the
         * empty string ("") as an argument.
         */
        var extraConnectionAttributes: kotlin.String? = null
        /**
         * Settings in JSON format for the source GCP MySQL endpoint.
         */
        var gcpMySqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.GcpMySqlSettings? = null
        /**
         * Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
         * available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
         * when using Db2 LUW as a source for DMS in the Database Migration Service
         * User Guide.
         */
        var ibmDb2Settings: aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings? = null
        /**
         * Settings in JSON format for the target Apache Kafka endpoint. For more information about
         * the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
         * to migrate data to a Kafka topic in the Database Migration Service User Guide.
         */
        var kafkaSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings? = null
        /**
         * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
         * more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
         * migrate data to a Kinesis data stream in the Database Migration Service User Guide.
         */
        var kinesisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings? = null
        /**
         * Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
         * information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
         * attributes when using SQL Server as a source for DMS and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
         * Extra connection attributes when using SQL Server as a target for DMS in the
         * Database Migration Service User Guide.
         */
        var microsoftSqlServerSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings? = null
        /**
         * Settings in JSON format for the source MongoDB endpoint. For more information about the
         * available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
         * when using MongoDB as a source for Database Migration Service in the
         * Database Migration Service User Guide.
         */
        var mongoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings? = null
        /**
         * Settings in JSON format for the source and target MySQL endpoint. For information about
         * other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection
         * attributes when using MySQL as a source for DMS and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra
         * connection attributes when using a MySQL-compatible database as a target for DMS in the Database Migration Service User
         * Guide.
         */
        var mySqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings? = null
        /**
         * Settings in JSON format for the target Amazon Neptune endpoint. For more information
         * about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target
         * in the Database Migration Service User Guide.
         */
        var neptuneSettings: aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings? = null
        /**
         * Settings in JSON format for the source and target Oracle endpoint. For information about
         * other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection
         * attributes when using Oracle as a source for DMS and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
         * Extra connection attributes when using Oracle as a target for DMS in the
         * Database Migration Service User Guide.
         */
        var oracleSettings: aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings? = null
        /**
         * The password to be used to login to the endpoint database.
         */
        var password: kotlin.String? = null
        /**
         * The port used by the endpoint database.
         */
        var port: kotlin.Int? = null
        /**
         * Settings in JSON format for the source and target PostgreSQL endpoint. For information
         * about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
         * attributes when using PostgreSQL as a source for DMS and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
         * Extra connection attributes when using PostgreSQL as a target for DMS in the
         * Database Migration Service User Guide.
         */
        var postgreSqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings? = null
        /**
         * Settings in JSON format for the Redis target endpoint.
         */
        var redisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings? = null
        /**
         * Provides information that defines an Amazon Redshift endpoint.
         */
        var redshiftSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings? = null
        /**
         * Settings in JSON format for the target Amazon S3 endpoint. For more information about
         * the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
         * Connection Attributes When Using Amazon S3 as a Target for DMS in the
         * Database Migration Service User Guide.
         */
        var s3Settings: aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings? = null
        /**
         * The name of the server where the endpoint database resides.
         */
        var serverName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the IAM role you want to use to modify
         * the endpoint. The role must allow the iam:PassRole action.
         */
        var serviceAccessRoleArn: kotlin.String? = null
        /**
         * The SSL mode used to connect to the endpoint.  The default value is none.
         */
        var sslMode: aws.sdk.kotlin.services.databasemigrationservice.model.DmsSslModeValue? = null
        /**
         * Settings in JSON format for the source and target SAP ASE endpoint. For information
         * about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
         * when using SAP ASE as a source for DMS and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
         * when using SAP ASE as a target for DMS in the Database Migration Service
         * User Guide.
         */
        var sybaseSettings: aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings? = null
        /**
         * The user name to be used to login to the endpoint database.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ModifyEndpointRequest) : this() {
            this.certificateArn = x.certificateArn
            this.databaseName = x.databaseName
            this.dmsTransferSettings = x.dmsTransferSettings
            this.docDbSettings = x.docDbSettings
            this.dynamoDbSettings = x.dynamoDbSettings
            this.elasticsearchSettings = x.elasticsearchSettings
            this.endpointArn = x.endpointArn
            this.endpointIdentifier = x.endpointIdentifier
            this.endpointType = x.endpointType
            this.engineName = x.engineName
            this.exactSettings = x.exactSettings
            this.externalTableDefinition = x.externalTableDefinition
            this.extraConnectionAttributes = x.extraConnectionAttributes
            this.gcpMySqlSettings = x.gcpMySqlSettings
            this.ibmDb2Settings = x.ibmDb2Settings
            this.kafkaSettings = x.kafkaSettings
            this.kinesisSettings = x.kinesisSettings
            this.microsoftSqlServerSettings = x.microsoftSqlServerSettings
            this.mongoDbSettings = x.mongoDbSettings
            this.mySqlSettings = x.mySqlSettings
            this.neptuneSettings = x.neptuneSettings
            this.oracleSettings = x.oracleSettings
            this.password = x.password
            this.port = x.port
            this.postgreSqlSettings = x.postgreSqlSettings
            this.redisSettings = x.redisSettings
            this.redshiftSettings = x.redshiftSettings
            this.s3Settings = x.s3Settings
            this.serverName = x.serverName
            this.serviceAccessRoleArn = x.serviceAccessRoleArn
            this.sslMode = x.sslMode
            this.sybaseSettings = x.sybaseSettings
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ModifyEndpointRequest = ModifyEndpointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings] inside the given [block]
         */
        fun dmsTransferSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings.Builder.() -> kotlin.Unit) {
            this.dmsTransferSettings = aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings] inside the given [block]
         */
        fun docDbSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings.Builder.() -> kotlin.Unit) {
            this.docDbSettings = aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings] inside the given [block]
         */
        fun dynamoDbSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings.Builder.() -> kotlin.Unit) {
            this.dynamoDbSettings = aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings] inside the given [block]
         */
        fun elasticsearchSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings.Builder.() -> kotlin.Unit) {
            this.elasticsearchSettings = aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.GcpMySqlSettings] inside the given [block]
         */
        fun gcpMySqlSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.GcpMySqlSettings.Builder.() -> kotlin.Unit) {
            this.gcpMySqlSettings = aws.sdk.kotlin.services.databasemigrationservice.model.GcpMySqlSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings] inside the given [block]
         */
        fun ibmDb2Settings(block: aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings.Builder.() -> kotlin.Unit) {
            this.ibmDb2Settings = aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings] inside the given [block]
         */
        fun kafkaSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings.Builder.() -> kotlin.Unit) {
            this.kafkaSettings = aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings] inside the given [block]
         */
        fun kinesisSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings.Builder.() -> kotlin.Unit) {
            this.kinesisSettings = aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings] inside the given [block]
         */
        fun microsoftSqlServerSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings.Builder.() -> kotlin.Unit) {
            this.microsoftSqlServerSettings = aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings] inside the given [block]
         */
        fun mongoDbSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings.Builder.() -> kotlin.Unit) {
            this.mongoDbSettings = aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings] inside the given [block]
         */
        fun mySqlSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings.Builder.() -> kotlin.Unit) {
            this.mySqlSettings = aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings] inside the given [block]
         */
        fun neptuneSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings.Builder.() -> kotlin.Unit) {
            this.neptuneSettings = aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings] inside the given [block]
         */
        fun oracleSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings.Builder.() -> kotlin.Unit) {
            this.oracleSettings = aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings] inside the given [block]
         */
        fun postgreSqlSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings.Builder.() -> kotlin.Unit) {
            this.postgreSqlSettings = aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings] inside the given [block]
         */
        fun redisSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings.Builder.() -> kotlin.Unit) {
            this.redisSettings = aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings] inside the given [block]
         */
        fun redshiftSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings.Builder.() -> kotlin.Unit) {
            this.redshiftSettings = aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings] inside the given [block]
         */
        fun s3Settings(block: aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings.Builder.() -> kotlin.Unit) {
            this.s3Settings = aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings] inside the given [block]
         */
        fun sybaseSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings.Builder.() -> kotlin.Unit) {
            this.sybaseSettings = aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings.invoke(block)
        }
    }
}
