// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information that describes a replication task created by the
 * CreateReplicationTask operation.
 */
class ReplicationTask private constructor(builder: Builder) {
    /**
     * Indicates when you want a change data capture (CDC) operation to start. Use either
     * CdcStartPosition or CdcStartTime to specify when you want the CDC operation to start.
     * Specifying both values results in an error.
     * The value can be in date, checkpoint, or LSN/SCN format.
     * Date Example: --cdc-start-position “2018-03-08T12:12:12”
     * Checkpoint Example: --cdc-start-position
     * "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     */
    val cdcStartPosition: kotlin.String? = builder.cdcStartPosition
    /**
     * Indicates when you want a change data capture (CDC) operation to stop. The value can be
     * either server time or commit time.
     * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
     * Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “
     */
    val cdcStopPosition: kotlin.String? = builder.cdcStopPosition
    /**
     * The last error (failure) message generated for the replication task.
     */
    val lastFailureMessage: kotlin.String? = builder.lastFailureMessage
    /**
     * The type of migration.
     */
    val migrationType: aws.sdk.kotlin.services.databasemigrationservice.model.MigrationTypeValue? = builder.migrationType
    /**
     * Indicates the last checkpoint that occurred during a change data capture (CDC)
     * operation. You can provide this value to the CdcStartPosition parameter to
     * start a CDC operation that begins at that checkpoint.
     */
    val recoveryCheckpoint: kotlin.String? = builder.recoveryCheckpoint
    /**
     * The ARN of the replication instance.
     */
    val replicationInstanceArn: kotlin.String? = builder.replicationInstanceArn
    /**
     * The Amazon Resource Name (ARN) of the replication task.
     */
    val replicationTaskArn: kotlin.String? = builder.replicationTaskArn
    /**
     * The date the replication task was created.
     */
    val replicationTaskCreationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.replicationTaskCreationDate
    /**
     * The user-assigned replication task identifier or name.
     * Constraints:
     *
     *
     * Must contain 1-255 alphanumeric characters or hyphens.
     *
     * First character must be a letter.
     *
     * Cannot end with a hyphen or contain two consecutive hyphens.
     */
    val replicationTaskIdentifier: kotlin.String? = builder.replicationTaskIdentifier
    /**
     * The settings for the replication task.
     */
    val replicationTaskSettings: kotlin.String? = builder.replicationTaskSettings
    /**
     * The date the replication task is scheduled to start.
     */
    val replicationTaskStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.replicationTaskStartDate
    /**
     * The statistics for the task, including elapsed time, tables loaded, and table
     * errors.
     */
    val replicationTaskStats: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats? = builder.replicationTaskStats
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the endpoint.
     */
    val sourceEndpointArn: kotlin.String? = builder.sourceEndpointArn
    /**
     * The status of the replication task. This response parameter can return one of
     * the following values:
     *
     *
     *
     * "moving" – The task is being moved in response to running the
     * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
     * MoveReplicationTask
     * operation.
     *
     *
     * "creating" – The task is being created in response to running
     * the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">
     * CreateReplicationTask
     * operation.
     *
     *
     * "deleting" – The task is being deleted in response to running
     * the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
     * DeleteReplicationTask
     * operation.
     *
     *
     * "failed" – The task failed to successfully complete the database
     * migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
     * StartReplicationTask
     * operation.
     *
     *
     * "failed-move" – The task failed to move in response to running
     * the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
     * MoveReplicationTask
     * operation.
     *
     *
     * "modifying" – The task definition is being modified in response
     * to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">
     * ModifyReplicationTask
     * operation.
     *
     *
     * "ready" – The task is in a ready state where it can
     * respond to other task operations, such as <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
     * StartReplicationTask
     * or <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
     * DeleteReplicationTask
     * .
     *
     *
     * "running" – The task is performing a database migration in
     * response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
     * StartReplicationTask
     * operation.
     *
     *
     * "starting" – The task is preparing to perform a database
     * migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
     * StartReplicationTask
     * operation.
     *
     *
     * "stopped" – The task has stopped in response to running the
     * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
     * StopReplicationTask
     * operation.
     *
     *
     * "stopping" – The task is preparing to stop in response to
     * running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
     * StopReplicationTask
     * operation.
     *
     *
     * "testing" – The database migration specified for this task is
     * being tested in response to running either the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
     * StartReplicationTaskAssessmentRun
     * or the
     * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
     * StartReplicationTaskAssessment
     *
     * operation.
     *
     *
     * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
     * StartReplicationTaskAssessmentRun
     * is
     * an improved premigration task assessment operation. The <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
     * StartReplicationTaskAssessment
     *
     * operation assesses data type compatibility only between the source and target
     * database of a given migration task. In contrast, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
     * StartReplicationTaskAssessmentRun
     *
     * enables you to specify a variety of premigration task assessments in addition to
     * data type compatibility. These assessments include ones for the validity of primary key definitions and
     * likely issues with database migration performance, among others.
     */
    val status: kotlin.String? = builder.status
    /**
     * The reason the replication task was stopped. This response parameter can return one of
     * the following values:
     *
     *
     *
     * "STOP_REASON_FULL_LOAD_COMPLETED" – Full-load migration
     * completed.
     *
     *
     * "STOP_REASON_CACHED_CHANGES_APPLIED" – Change data capture (CDC)
     * load completed.
     *
     *
     * "STOP_REASON_CACHED_CHANGES_NOT_APPLIED" – In a
     * full-load and CDC migration, the full load stopped as specified before starting the
     * CDC migration.
     *
     *
     * "STOP_REASON_SERVER_TIME" – The migration stopped at the
     * specified server time.
     */
    val stopReason: kotlin.String? = builder.stopReason
    /**
     * Table mappings specified in the task.
     */
    val tableMappings: kotlin.String? = builder.tableMappings
    /**
     * The ARN that uniquely identifies the endpoint.
     */
    val targetEndpointArn: kotlin.String? = builder.targetEndpointArn
    /**
     * The ARN of the replication instance to which this task is moved in response to running
     * the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
     * MoveReplicationTask
     * operation. Otherwise, this response
     * parameter isn't a member of the ReplicationTask object.
     */
    val targetReplicationInstanceArn: kotlin.String? = builder.targetReplicationInstanceArn
    /**
     * Supplemental information that the task requires to migrate the data for certain source and target endpoints.
     * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings in the
     * Database Migration Service User Guide.
     */
    val taskData: kotlin.String? = builder.taskData

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationTask(")
        append("cdcStartPosition=$cdcStartPosition,")
        append("cdcStopPosition=$cdcStopPosition,")
        append("lastFailureMessage=$lastFailureMessage,")
        append("migrationType=$migrationType,")
        append("recoveryCheckpoint=$recoveryCheckpoint,")
        append("replicationInstanceArn=$replicationInstanceArn,")
        append("replicationTaskArn=$replicationTaskArn,")
        append("replicationTaskCreationDate=$replicationTaskCreationDate,")
        append("replicationTaskIdentifier=$replicationTaskIdentifier,")
        append("replicationTaskSettings=$replicationTaskSettings,")
        append("replicationTaskStartDate=$replicationTaskStartDate,")
        append("replicationTaskStats=$replicationTaskStats,")
        append("sourceEndpointArn=$sourceEndpointArn,")
        append("status=$status,")
        append("stopReason=$stopReason,")
        append("tableMappings=$tableMappings,")
        append("targetEndpointArn=$targetEndpointArn,")
        append("targetReplicationInstanceArn=$targetReplicationInstanceArn,")
        append("taskData=$taskData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cdcStartPosition?.hashCode() ?: 0
        result = 31 * result + (cdcStopPosition?.hashCode() ?: 0)
        result = 31 * result + (lastFailureMessage?.hashCode() ?: 0)
        result = 31 * result + (migrationType?.hashCode() ?: 0)
        result = 31 * result + (recoveryCheckpoint?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskArn?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskCreationDate?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskIdentifier?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskSettings?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskStartDate?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskStats?.hashCode() ?: 0)
        result = 31 * result + (sourceEndpointArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stopReason?.hashCode() ?: 0)
        result = 31 * result + (tableMappings?.hashCode() ?: 0)
        result = 31 * result + (targetEndpointArn?.hashCode() ?: 0)
        result = 31 * result + (targetReplicationInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (taskData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationTask

        if (cdcStartPosition != other.cdcStartPosition) return false
        if (cdcStopPosition != other.cdcStopPosition) return false
        if (lastFailureMessage != other.lastFailureMessage) return false
        if (migrationType != other.migrationType) return false
        if (recoveryCheckpoint != other.recoveryCheckpoint) return false
        if (replicationInstanceArn != other.replicationInstanceArn) return false
        if (replicationTaskArn != other.replicationTaskArn) return false
        if (replicationTaskCreationDate != other.replicationTaskCreationDate) return false
        if (replicationTaskIdentifier != other.replicationTaskIdentifier) return false
        if (replicationTaskSettings != other.replicationTaskSettings) return false
        if (replicationTaskStartDate != other.replicationTaskStartDate) return false
        if (replicationTaskStats != other.replicationTaskStats) return false
        if (sourceEndpointArn != other.sourceEndpointArn) return false
        if (status != other.status) return false
        if (stopReason != other.stopReason) return false
        if (tableMappings != other.tableMappings) return false
        if (targetEndpointArn != other.targetEndpointArn) return false
        if (targetReplicationInstanceArn != other.targetReplicationInstanceArn) return false
        if (taskData != other.taskData) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTask = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates when you want a change data capture (CDC) operation to start. Use either
         * CdcStartPosition or CdcStartTime to specify when you want the CDC operation to start.
         * Specifying both values results in an error.
         * The value can be in date, checkpoint, or LSN/SCN format.
         * Date Example: --cdc-start-position “2018-03-08T12:12:12”
         * Checkpoint Example: --cdc-start-position
         * "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         */
        var cdcStartPosition: kotlin.String? = null
        /**
         * Indicates when you want a change data capture (CDC) operation to stop. The value can be
         * either server time or commit time.
         * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
         * Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “
         */
        var cdcStopPosition: kotlin.String? = null
        /**
         * The last error (failure) message generated for the replication task.
         */
        var lastFailureMessage: kotlin.String? = null
        /**
         * The type of migration.
         */
        var migrationType: aws.sdk.kotlin.services.databasemigrationservice.model.MigrationTypeValue? = null
        /**
         * Indicates the last checkpoint that occurred during a change data capture (CDC)
         * operation. You can provide this value to the CdcStartPosition parameter to
         * start a CDC operation that begins at that checkpoint.
         */
        var recoveryCheckpoint: kotlin.String? = null
        /**
         * The ARN of the replication instance.
         */
        var replicationInstanceArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the replication task.
         */
        var replicationTaskArn: kotlin.String? = null
        /**
         * The date the replication task was created.
         */
        var replicationTaskCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user-assigned replication task identifier or name.
         * Constraints:
         *
         *
         * Must contain 1-255 alphanumeric characters or hyphens.
         *
         * First character must be a letter.
         *
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        var replicationTaskIdentifier: kotlin.String? = null
        /**
         * The settings for the replication task.
         */
        var replicationTaskSettings: kotlin.String? = null
        /**
         * The date the replication task is scheduled to start.
         */
        var replicationTaskStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statistics for the task, including elapsed time, tables loaded, and table
         * errors.
         */
        var replicationTaskStats: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats? = null
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the endpoint.
         */
        var sourceEndpointArn: kotlin.String? = null
        /**
         * The status of the replication task. This response parameter can return one of
         * the following values:
         *
         *
         *
         * "moving" – The task is being moved in response to running the
         * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
         * MoveReplicationTask
         * operation.
         *
         *
         * "creating" – The task is being created in response to running
         * the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">
         * CreateReplicationTask
         * operation.
         *
         *
         * "deleting" – The task is being deleted in response to running
         * the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
         * DeleteReplicationTask
         * operation.
         *
         *
         * "failed" – The task failed to successfully complete the database
         * migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
         * StartReplicationTask
         * operation.
         *
         *
         * "failed-move" – The task failed to move in response to running
         * the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
         * MoveReplicationTask
         * operation.
         *
         *
         * "modifying" – The task definition is being modified in response
         * to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">
         * ModifyReplicationTask
         * operation.
         *
         *
         * "ready" – The task is in a ready state where it can
         * respond to other task operations, such as <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
         * StartReplicationTask
         * or <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
         * DeleteReplicationTask
         * .
         *
         *
         * "running" – The task is performing a database migration in
         * response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
         * StartReplicationTask
         * operation.
         *
         *
         * "starting" – The task is preparing to perform a database
         * migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
         * StartReplicationTask
         * operation.
         *
         *
         * "stopped" – The task has stopped in response to running the
         * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
         * StopReplicationTask
         * operation.
         *
         *
         * "stopping" – The task is preparing to stop in response to
         * running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
         * StopReplicationTask
         * operation.
         *
         *
         * "testing" – The database migration specified for this task is
         * being tested in response to running either the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
         * StartReplicationTaskAssessmentRun
         * or the
         * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
         * StartReplicationTaskAssessment
         *
         * operation.
         *
         *
         * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
         * StartReplicationTaskAssessmentRun
         * is
         * an improved premigration task assessment operation. The <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
         * StartReplicationTaskAssessment
         *
         * operation assesses data type compatibility only between the source and target
         * database of a given migration task. In contrast, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
         * StartReplicationTaskAssessmentRun
         *
         * enables you to specify a variety of premigration task assessments in addition to
         * data type compatibility. These assessments include ones for the validity of primary key definitions and
         * likely issues with database migration performance, among others.
         */
        var status: kotlin.String? = null
        /**
         * The reason the replication task was stopped. This response parameter can return one of
         * the following values:
         *
         *
         *
         * "STOP_REASON_FULL_LOAD_COMPLETED" – Full-load migration
         * completed.
         *
         *
         * "STOP_REASON_CACHED_CHANGES_APPLIED" – Change data capture (CDC)
         * load completed.
         *
         *
         * "STOP_REASON_CACHED_CHANGES_NOT_APPLIED" – In a
         * full-load and CDC migration, the full load stopped as specified before starting the
         * CDC migration.
         *
         *
         * "STOP_REASON_SERVER_TIME" – The migration stopped at the
         * specified server time.
         */
        var stopReason: kotlin.String? = null
        /**
         * Table mappings specified in the task.
         */
        var tableMappings: kotlin.String? = null
        /**
         * The ARN that uniquely identifies the endpoint.
         */
        var targetEndpointArn: kotlin.String? = null
        /**
         * The ARN of the replication instance to which this task is moved in response to running
         * the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
         * MoveReplicationTask
         * operation. Otherwise, this response
         * parameter isn't a member of the ReplicationTask object.
         */
        var targetReplicationInstanceArn: kotlin.String? = null
        /**
         * Supplemental information that the task requires to migrate the data for certain source and target endpoints.
         * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings in the
         * Database Migration Service User Guide.
         */
        var taskData: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTask) : this() {
            this.cdcStartPosition = x.cdcStartPosition
            this.cdcStopPosition = x.cdcStopPosition
            this.lastFailureMessage = x.lastFailureMessage
            this.migrationType = x.migrationType
            this.recoveryCheckpoint = x.recoveryCheckpoint
            this.replicationInstanceArn = x.replicationInstanceArn
            this.replicationTaskArn = x.replicationTaskArn
            this.replicationTaskCreationDate = x.replicationTaskCreationDate
            this.replicationTaskIdentifier = x.replicationTaskIdentifier
            this.replicationTaskSettings = x.replicationTaskSettings
            this.replicationTaskStartDate = x.replicationTaskStartDate
            this.replicationTaskStats = x.replicationTaskStats
            this.sourceEndpointArn = x.sourceEndpointArn
            this.status = x.status
            this.stopReason = x.stopReason
            this.tableMappings = x.tableMappings
            this.targetEndpointArn = x.targetEndpointArn
            this.targetReplicationInstanceArn = x.targetReplicationInstanceArn
            this.taskData = x.taskData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTask = ReplicationTask(this)

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats] inside the given [block]
         */
        fun replicationTaskStats(block: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats.Builder.() -> kotlin.Unit) {
            this.replicationTaskStats = aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats.invoke(block)
        }
    }
}
