// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Identifies an DMS resource and any pending actions for it.
 */
class ResourcePendingMaintenanceActions private constructor(builder: Builder) {
    /**
     * Detailed information about the pending maintenance action.
     */
    val pendingMaintenanceActionDetails: List<PendingMaintenanceAction>? = builder.pendingMaintenanceActionDetails
    /**
     * The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action
     * applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Introduction.AWS.ARN.html"> Constructing an Amazon
     * Resource Name (ARN) for DMS in the DMS documentation.
     */
    val resourceIdentifier: kotlin.String? = builder.resourceIdentifier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ResourcePendingMaintenanceActions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourcePendingMaintenanceActions(")
        append("pendingMaintenanceActionDetails=$pendingMaintenanceActionDetails,")
        append("resourceIdentifier=$resourceIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = pendingMaintenanceActionDetails?.hashCode() ?: 0
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourcePendingMaintenanceActions

        if (pendingMaintenanceActionDetails != other.pendingMaintenanceActionDetails) return false
        if (resourceIdentifier != other.resourceIdentifier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ResourcePendingMaintenanceActions = Builder(this).apply(block).build()

    class Builder {
        /**
         * Detailed information about the pending maintenance action.
         */
        var pendingMaintenanceActionDetails: List<PendingMaintenanceAction>? = null
        /**
         * The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action
         * applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Introduction.AWS.ARN.html"> Constructing an Amazon
         * Resource Name (ARN) for DMS in the DMS documentation.
         */
        var resourceIdentifier: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ResourcePendingMaintenanceActions) : this() {
            this.pendingMaintenanceActionDetails = x.pendingMaintenanceActionDetails
            this.resourceIdentifier = x.resourceIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ResourcePendingMaintenanceActions = ResourcePendingMaintenanceActions(this)
    }
}
