// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * A user-defined key-value pair that describes metadata added to an DMS resource and
 * that is used by operations such as the following:
 *
 *
 *
 * AddTagsToResource
 *
 *
 *
 * ListTagsForResource
 *
 *
 *
 * RemoveTagsFromResource
 */
class Tag private constructor(builder: Builder) {
    /**
     * A key is the required name of the tag. The string value can be 1-128 Unicode characters
     * in length and can't be prefixed with "aws:" or "dms:". The string can only contain
     * only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java
     * regular expressions: "^(&#91;\\p{L}\\p{Z}\\p{N}_.:/=+\\-&#93;*)$").
     */
    val key: kotlin.String? = builder.key
    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the resource for which the tag is created.
     */
    val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * A value is the optional value of the tag. The string value can be 1-256 Unicode
     * characters in length and can't be prefixed with "aws:" or "dms:". The string can only
     * contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-'
     * (Java regular expressions: "^(&#91;\\p{L}\\p{Z}\\p{N}_.:/=+\\-&#93;*)$").
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.Tag = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tag(")
        append("key=$key,")
        append("resourceArn=$resourceArn,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Tag

        if (key != other.key) return false
        if (resourceArn != other.resourceArn) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.Tag = Builder(this).apply(block).build()

    class Builder {
        /**
         * A key is the required name of the tag. The string value can be 1-128 Unicode characters
         * in length and can't be prefixed with "aws:" or "dms:". The string can only contain
         * only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java
         * regular expressions: "^(&#91;\\p{L}\\p{Z}\\p{N}_.:/=+\\-&#93;*)$").
         */
        var key: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) string that uniquely identifies the resource for which the tag is created.
         */
        var resourceArn: kotlin.String? = null
        /**
         * A value is the optional value of the tag. The string value can be 1-256 Unicode
         * characters in length and can't be prefixed with "aws:" or "dms:". The string can only
         * contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-'
         * (Java regular expressions: "^(&#91;\\p{L}\\p{Z}\\p{N}_.:/=+\\-&#93;*)$").
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.Tag) : this() {
            this.key = x.key
            this.resourceArn = x.resourceArn
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.Tag = Tag(this)
    }
}
