// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationSubnetGroupResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationSubnetGroup
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ModifyReplicationSubnetGroupOperationDeserializer: HttpDeserialize<ModifyReplicationSubnetGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyReplicationSubnetGroupResponse {
        if (!response.status.isSuccess()) {
            throwModifyReplicationSubnetGroupError(context, response)
        }
        val builder = ModifyReplicationSubnetGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyReplicationSubnetGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyReplicationSubnetGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedFault" -> AccessDeniedFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedResponse)
        "ReplicationSubnetGroupDoesNotCoverEnoughAZs" -> ReplicationSubnetGroupDoesNotCoverEnoughAZsDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ResourceQuotaExceededFault" -> ResourceQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "SubnetAlreadyInUse" -> SubnetAlreadyInUseDeserializer().deserialize(context, wrappedResponse)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyReplicationSubnetGroupOperationBody(builder: ModifyReplicationSubnetGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REPLICATIONSUBNETGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReplicationSubnetGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REPLICATIONSUBNETGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REPLICATIONSUBNETGROUP_DESCRIPTOR.index -> builder.replicationSubnetGroup = deserializeReplicationSubnetGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
