// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskAssessmentRun
import aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskAssessmentRunResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartReplicationTaskAssessmentRunOperationDeserializer: HttpDeserialize<StartReplicationTaskAssessmentRunResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartReplicationTaskAssessmentRunResponse {
        if (!response.status.isSuccess()) {
            throwStartReplicationTaskAssessmentRunError(context, response)
        }
        val builder = StartReplicationTaskAssessmentRunResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartReplicationTaskAssessmentRunOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartReplicationTaskAssessmentRunError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedFault" -> AccessDeniedFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidResourceStateFault" -> InvalidResourceStateFaultDeserializer().deserialize(context, wrappedResponse)
        "KMSAccessDeniedFault" -> KmsAccessDeniedFaultDeserializer().deserialize(context, wrappedResponse)
        "KMSDisabledFault" -> KmsDisabledFaultDeserializer().deserialize(context, wrappedResponse)
        "KMSFault" -> KmsFaultDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateFault" -> KmsInvalidStateFaultDeserializer().deserialize(context, wrappedResponse)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedResponse)
        "KMSNotFoundFault" -> KmsNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ResourceAlreadyExistsFault" -> ResourceAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "S3AccessDeniedFault" -> S3AccessDeniedFaultDeserializer().deserialize(context, wrappedResponse)
        "S3ResourceNotFoundFault" -> S3ResourceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartReplicationTaskAssessmentRunOperationBody(builder: StartReplicationTaskAssessmentRunResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REPLICATIONTASKASSESSMENTRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReplicationTaskAssessmentRun"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REPLICATIONTASKASSESSMENTRUN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REPLICATIONTASKASSESSMENTRUN_DESCRIPTOR.index -> builder.replicationTaskAssessmentRun = deserializeReplicationTaskAssessmentRunDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
