// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.waiters

import aws.sdk.kotlin.services.databasemigrationservice.DatabaseMigrationClient
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeConnectionsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeConnectionsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEndpointsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEndpointsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationInstancesRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationInstancesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationTasksRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationTasksResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until testing connection succeeds.
 */
suspend fun DatabaseMigrationClient.waitUntilTestConnectionSucceeds(request: DescribeConnectionsRequest): Outcome<DescribeConnectionsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeConnectionsRequest, DescribeConnectionsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val connections = it?.connections
            val connectionsOrEmpty = connections?.flattenIfPossible() ?: listOf()
            val projection = connectionsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "successful" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val connections = it?.connections
            val connectionsOrEmpty = connections?.flattenIfPossible() ?: listOf()
            val projection = connectionsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeConnections(request) }
}

/**
 * Wait until testing connection succeeds.
 */
suspend fun DatabaseMigrationClient.waitUntilTestConnectionSucceeds(block: DescribeConnectionsRequest.Builder.() -> Unit): Outcome<DescribeConnectionsResponse> =
    waitUntilTestConnectionSucceeds(DescribeConnectionsRequest.Builder().apply(block).build())

/**
 * Wait until testing endpoint is deleted.
 */
suspend fun DatabaseMigrationClient.waitUntilEndpointDeleted(request: DescribeEndpointsRequest): Outcome<DescribeEndpointsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeEndpointsRequest, DescribeEndpointsResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundFault"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val endpoints = it?.endpoints
            val endpointsOrEmpty = endpoints?.flattenIfPossible() ?: listOf()
            val projection = endpointsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "active" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val endpoints = it?.endpoints
            val endpointsOrEmpty = endpoints?.flattenIfPossible() ?: listOf()
            val projection = endpointsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "creating" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeEndpoints(request) }
}

/**
 * Wait until testing endpoint is deleted.
 */
suspend fun DatabaseMigrationClient.waitUntilEndpointDeleted(block: DescribeEndpointsRequest.Builder.() -> Unit): Outcome<DescribeEndpointsResponse> =
    waitUntilEndpointDeleted(DescribeEndpointsRequest.Builder().apply(block).build())

/**
 * Wait until DMS replication instance is available.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationInstanceAvailable(request: DescribeReplicationInstancesRequest): Outcome<DescribeReplicationInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeReplicationInstancesRequest, DescribeReplicationInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val replicationInstances = it?.replicationInstances
            val replicationInstancesOrEmpty = replicationInstances?.flattenIfPossible() ?: listOf()
            val projection = replicationInstancesOrEmpty.flatMap {
                val replicationInstanceStatus = it?.replicationInstanceStatus
                listOfNotNull(replicationInstanceStatus)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationInstances = it?.replicationInstances
            val replicationInstancesOrEmpty = replicationInstances?.flattenIfPossible() ?: listOf()
            val projection = replicationInstancesOrEmpty.flatMap {
                val replicationInstanceStatus = it?.replicationInstanceStatus
                listOfNotNull(replicationInstanceStatus)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationInstances = it?.replicationInstances
            val replicationInstancesOrEmpty = replicationInstances?.flattenIfPossible() ?: listOf()
            val projection = replicationInstancesOrEmpty.flatMap {
                val replicationInstanceStatus = it?.replicationInstanceStatus
                listOfNotNull(replicationInstanceStatus)
            }
            projection?.any { it?.toString() == "incompatible-credentials" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationInstances = it?.replicationInstances
            val replicationInstancesOrEmpty = replicationInstances?.flattenIfPossible() ?: listOf()
            val projection = replicationInstancesOrEmpty.flatMap {
                val replicationInstanceStatus = it?.replicationInstanceStatus
                listOfNotNull(replicationInstanceStatus)
            }
            projection?.any { it?.toString() == "incompatible-network" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationInstances = it?.replicationInstances
            val replicationInstancesOrEmpty = replicationInstances?.flattenIfPossible() ?: listOf()
            val projection = replicationInstancesOrEmpty.flatMap {
                val replicationInstanceStatus = it?.replicationInstanceStatus
                listOfNotNull(replicationInstanceStatus)
            }
            projection?.any { it?.toString() == "inaccessible-encryption-credentials" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeReplicationInstances(request) }
}

/**
 * Wait until DMS replication instance is available.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationInstanceAvailable(block: DescribeReplicationInstancesRequest.Builder.() -> Unit): Outcome<DescribeReplicationInstancesResponse> =
    waitUntilReplicationInstanceAvailable(DescribeReplicationInstancesRequest.Builder().apply(block).build())

/**
 * Wait until DMS replication instance is deleted.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationInstanceDeleted(request: DescribeReplicationInstancesRequest): Outcome<DescribeReplicationInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeReplicationInstancesRequest, DescribeReplicationInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationInstances = it?.replicationInstances
            val replicationInstancesOrEmpty = replicationInstances?.flattenIfPossible() ?: listOf()
            val projection = replicationInstancesOrEmpty.flatMap {
                val replicationInstanceStatus = it?.replicationInstanceStatus
                listOfNotNull(replicationInstanceStatus)
            }
            projection?.any { it?.toString() == "available" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundFault"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeReplicationInstances(request) }
}

/**
 * Wait until DMS replication instance is deleted.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationInstanceDeleted(block: DescribeReplicationInstancesRequest.Builder.() -> Unit): Outcome<DescribeReplicationInstancesResponse> =
    waitUntilReplicationInstanceDeleted(DescribeReplicationInstancesRequest.Builder().apply(block).build())

/**
 * Wait until DMS replication task is deleted.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationTaskDeleted(request: DescribeReplicationTasksRequest): Outcome<DescribeReplicationTasksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeReplicationTasksRequest, DescribeReplicationTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "ready" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stopped" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "running" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundFault"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeReplicationTasks(request) }
}

/**
 * Wait until DMS replication task is deleted.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationTaskDeleted(block: DescribeReplicationTasksRequest.Builder.() -> Unit): Outcome<DescribeReplicationTasksResponse> =
    waitUntilReplicationTaskDeleted(DescribeReplicationTasksRequest.Builder().apply(block).build())

/**
 * Wait until DMS replication task is ready.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationTaskReady(request: DescribeReplicationTasksRequest): Outcome<DescribeReplicationTasksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeReplicationTasksRequest, DescribeReplicationTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "ready" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "starting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "running" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stopping" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stopped" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "testing" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeReplicationTasks(request) }
}

/**
 * Wait until DMS replication task is ready.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationTaskReady(block: DescribeReplicationTasksRequest.Builder.() -> Unit): Outcome<DescribeReplicationTasksResponse> =
    waitUntilReplicationTaskReady(DescribeReplicationTasksRequest.Builder().apply(block).build())

/**
 * Wait until DMS replication task is running.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationTaskRunning(request: DescribeReplicationTasksRequest): Outcome<DescribeReplicationTasksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeReplicationTasksRequest, DescribeReplicationTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "running" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "ready" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stopping" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stopped" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "testing" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeReplicationTasks(request) }
}

/**
 * Wait until DMS replication task is running.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationTaskRunning(block: DescribeReplicationTasksRequest.Builder.() -> Unit): Outcome<DescribeReplicationTasksResponse> =
    waitUntilReplicationTaskRunning(DescribeReplicationTasksRequest.Builder().apply(block).build())

/**
 * Wait until DMS replication task is stopped.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationTaskStopped(request: DescribeReplicationTasksRequest): Outcome<DescribeReplicationTasksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeReplicationTasksRequest, DescribeReplicationTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "stopped" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "ready" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "starting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "testing" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationTasks = it?.replicationTasks
            val replicationTasksOrEmpty = replicationTasks?.flattenIfPossible() ?: listOf()
            val projection = replicationTasksOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeReplicationTasks(request) }
}

/**
 * Wait until DMS replication task is stopped.
 */
suspend fun DatabaseMigrationClient.waitUntilReplicationTaskStopped(block: DescribeReplicationTasksRequest.Builder.() -> Unit): Outcome<DescribeReplicationTasksResponse> =
    waitUntilReplicationTaskStopped(DescribeReplicationTasksRequest.Builder().apply(block).build())
