// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.datasync.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.datasync.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # DataSync
 * DataSync is a managed data transfer service that makes it simpler for you to automate moving data between on-premises storage and Amazon Simple Storage Service (Amazon S3) or Amazon Elastic File System (Amazon EFS).
 *
 * This API interface reference for DataSync contains documentation for a programming interface that you can use to manage DataSync.
 */
interface DataSyncClient : SdkClient {

    override val serviceName: String
        get() = "DataSync"
    /**
     * DataSyncClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): DataSyncClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDataSyncClient(config)
        }

        operator fun invoke(config: Config): DataSyncClient = DefaultDataSyncClient(config)

        /**
         * Construct a [DataSyncClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DataSyncClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultDataSyncClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels execution of a task.
     *
     * When you cancel a task execution, the transfer of some files is abruptly interrupted. The contents of files that are transferred to the destination might be incomplete or inconsistent with the source files. However, if you start a new task execution on the same task and you allow the task execution to complete, file content on the destination is complete and consistent. This applies to other unexpected failures that interrupt a task execution. In all of these cases, DataSync successfully complete the transfer when you start the next task execution.
     */
    suspend fun cancelTaskExecution(input: CancelTaskExecutionRequest): CancelTaskExecutionResponse

    /**
     * Cancels execution of a task.
     *
     * When you cancel a task execution, the transfer of some files is abruptly interrupted. The contents of files that are transferred to the destination might be incomplete or inconsistent with the source files. However, if you start a new task execution on the same task and you allow the task execution to complete, file content on the destination is complete and consistent. This applies to other unexpected failures that interrupt a task execution. In all of these cases, DataSync successfully complete the transfer when you start the next task execution.
     */
    suspend fun cancelTaskExecution(block: CancelTaskExecutionRequest.Builder.() -> Unit) = cancelTaskExecution(CancelTaskExecutionRequest.Builder().apply(block).build())

    /**
     * Activates an DataSync agent that you have deployed on your host. The activation process associates your agent with your account. In the activation process, you specify information such as the Amazon Web Services Region that you want to activate the agent in. You activate the agent in the Amazon Web Services Region where your target locations (in Amazon S3 or Amazon EFS) reside. Your tasks are created in this Amazon Web Services Region.
     *
     * You can activate the agent in a VPC (virtual private cloud) or provide the agent access to a VPC endpoint so you can run tasks without going over the public internet.
     *
     * You can use an agent for more than one location. If a task uses multiple agents, all of them need to have status AVAILABLE for the task to run. If you use multiple agents for a source location, the status of all the agents must be AVAILABLE for the task to run.
     *
     * Agents are automatically updated by Amazon Web Services on a regular basis, using a mechanism that ensures minimal interruption to your tasks.
     */
    suspend fun createAgent(input: CreateAgentRequest): CreateAgentResponse

    /**
     * Activates an DataSync agent that you have deployed on your host. The activation process associates your agent with your account. In the activation process, you specify information such as the Amazon Web Services Region that you want to activate the agent in. You activate the agent in the Amazon Web Services Region where your target locations (in Amazon S3 or Amazon EFS) reside. Your tasks are created in this Amazon Web Services Region.
     *
     * You can activate the agent in a VPC (virtual private cloud) or provide the agent access to a VPC endpoint so you can run tasks without going over the public internet.
     *
     * You can use an agent for more than one location. If a task uses multiple agents, all of them need to have status AVAILABLE for the task to run. If you use multiple agents for a source location, the status of all the agents must be AVAILABLE for the task to run.
     *
     * Agents are automatically updated by Amazon Web Services on a regular basis, using a mechanism that ensures minimal interruption to your tasks.
     */
    suspend fun createAgent(block: CreateAgentRequest.Builder.() -> Unit) = createAgent(CreateAgentRequest.Builder().apply(block).build())

    /**
     * Creates an endpoint for an Amazon EFS file system that DataSync can access for a transfer. For more information, see [Creating a location for Amazon EFS](https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html).
     */
    suspend fun createLocationEfs(input: CreateLocationEfsRequest): CreateLocationEfsResponse

    /**
     * Creates an endpoint for an Amazon EFS file system that DataSync can access for a transfer. For more information, see [Creating a location for Amazon EFS](https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html).
     */
    suspend fun createLocationEfs(block: CreateLocationEfsRequest.Builder.() -> Unit) = createLocationEfs(CreateLocationEfsRequest.Builder().apply(block).build())

    /**
     * Creates an endpoint for an Amazon FSx for Lustre file system.
     */
    suspend fun createLocationFsxLustre(input: CreateLocationFsxLustreRequest): CreateLocationFsxLustreResponse

    /**
     * Creates an endpoint for an Amazon FSx for Lustre file system.
     */
    suspend fun createLocationFsxLustre(block: CreateLocationFsxLustreRequest.Builder.() -> Unit) = createLocationFsxLustre(CreateLocationFsxLustreRequest.Builder().apply(block).build())

    /**
     * Creates an endpoint for an Amazon FSx for OpenZFS file system.
     */
    suspend fun createLocationFsxOpenZfs(input: CreateLocationFsxOpenZfsRequest): CreateLocationFsxOpenZfsResponse

    /**
     * Creates an endpoint for an Amazon FSx for OpenZFS file system.
     */
    suspend fun createLocationFsxOpenZfs(block: CreateLocationFsxOpenZfsRequest.Builder.() -> Unit) = createLocationFsxOpenZfs(CreateLocationFsxOpenZfsRequest.Builder().apply(block).build())

    /**
     * Creates an endpoint for an Amazon FSx for Windows File Server file system.
     */
    suspend fun createLocationFsxWindows(input: CreateLocationFsxWindowsRequest): CreateLocationFsxWindowsResponse

    /**
     * Creates an endpoint for an Amazon FSx for Windows File Server file system.
     */
    suspend fun createLocationFsxWindows(block: CreateLocationFsxWindowsRequest.Builder.() -> Unit) = createLocationFsxWindows(CreateLocationFsxWindowsRequest.Builder().apply(block).build())

    /**
     * Creates an endpoint for a Hadoop Distributed File System (HDFS).
     */
    suspend fun createLocationHdfs(input: CreateLocationHdfsRequest): CreateLocationHdfsResponse

    /**
     * Creates an endpoint for a Hadoop Distributed File System (HDFS).
     */
    suspend fun createLocationHdfs(block: CreateLocationHdfsRequest.Builder.() -> Unit) = createLocationHdfs(CreateLocationHdfsRequest.Builder().apply(block).build())

    /**
     * Defines a file system on a Network File System (NFS) server that can be read from or written to.
     */
    suspend fun createLocationNfs(input: CreateLocationNfsRequest): CreateLocationNfsResponse

    /**
     * Defines a file system on a Network File System (NFS) server that can be read from or written to.
     */
    suspend fun createLocationNfs(block: CreateLocationNfsRequest.Builder.() -> Unit) = createLocationNfs(CreateLocationNfsRequest.Builder().apply(block).build())

    /**
     * Creates an endpoint for a self-managed object storage bucket. For more information about self-managed object storage locations, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
     */
    suspend fun createLocationObjectStorage(input: CreateLocationObjectStorageRequest): CreateLocationObjectStorageResponse

    /**
     * Creates an endpoint for a self-managed object storage bucket. For more information about self-managed object storage locations, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
     */
    suspend fun createLocationObjectStorage(block: CreateLocationObjectStorageRequest.Builder.() -> Unit) = createLocationObjectStorage(CreateLocationObjectStorageRequest.Builder().apply(block).build())

    /**
     * Creates an endpoint for an Amazon S3 bucket.
     *
     * For more information, see [Create an Amazon S3 location](https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli) in the *DataSync User Guide*.
     */
    suspend fun createLocationS3(input: CreateLocationS3Request): CreateLocationS3Response

    /**
     * Creates an endpoint for an Amazon S3 bucket.
     *
     * For more information, see [Create an Amazon S3 location](https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli) in the *DataSync User Guide*.
     */
    suspend fun createLocationS3(block: CreateLocationS3Request.Builder.() -> Unit) = createLocationS3(CreateLocationS3Request.Builder().apply(block).build())

    /**
     * Defines a file system on a Server Message Block (SMB) server that can be read from or written to.
     */
    suspend fun createLocationSmb(input: CreateLocationSmbRequest): CreateLocationSmbResponse

    /**
     * Defines a file system on a Server Message Block (SMB) server that can be read from or written to.
     */
    suspend fun createLocationSmb(block: CreateLocationSmbRequest.Builder.() -> Unit) = createLocationSmb(CreateLocationSmbRequest.Builder().apply(block).build())

    /**
     * Creates a task.
     *
     * A task includes a source location and a destination location, and a configuration that specifies how data is transferred. A task always transfers data from the source location to the destination location. The configuration specifies options such as task scheduling, bandwidth limits, etc. A task is the complete definition of a data transfer.
     *
     * When you create a task that transfers data between Amazon Web Services services in different Amazon Web Services Regions, one of the two locations that you specify must reside in the Region where DataSync is being used. The other location must be specified in a different Region.
     *
     * You can transfer data between commercial Amazon Web Services Regions except for China, or between Amazon Web Services GovCloud (US) Regions.
     *
     * When you use DataSync to copy files or objects between Amazon Web Services Regions, you pay for data transfer between Regions. This is billed as data transfer OUT from your source Region to your destination Region. For more information, see [Data Transfer pricing](http://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer).
     */
    suspend fun createTask(input: CreateTaskRequest): CreateTaskResponse

    /**
     * Creates a task.
     *
     * A task includes a source location and a destination location, and a configuration that specifies how data is transferred. A task always transfers data from the source location to the destination location. The configuration specifies options such as task scheduling, bandwidth limits, etc. A task is the complete definition of a data transfer.
     *
     * When you create a task that transfers data between Amazon Web Services services in different Amazon Web Services Regions, one of the two locations that you specify must reside in the Region where DataSync is being used. The other location must be specified in a different Region.
     *
     * You can transfer data between commercial Amazon Web Services Regions except for China, or between Amazon Web Services GovCloud (US) Regions.
     *
     * When you use DataSync to copy files or objects between Amazon Web Services Regions, you pay for data transfer between Regions. This is billed as data transfer OUT from your source Region to your destination Region. For more information, see [Data Transfer pricing](http://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer).
     */
    suspend fun createTask(block: CreateTaskRequest.Builder.() -> Unit) = createTask(CreateTaskRequest.Builder().apply(block).build())

    /**
     * Deletes an agent. To specify which agent to delete, use the Amazon Resource Name (ARN) of the agent in your request. The operation disassociates the agent from your Amazon Web Services account. However, it doesn't delete the agent virtual machine (VM) from your on-premises environment.
     */
    suspend fun deleteAgent(input: DeleteAgentRequest): DeleteAgentResponse

    /**
     * Deletes an agent. To specify which agent to delete, use the Amazon Resource Name (ARN) of the agent in your request. The operation disassociates the agent from your Amazon Web Services account. However, it doesn't delete the agent virtual machine (VM) from your on-premises environment.
     */
    suspend fun deleteAgent(block: DeleteAgentRequest.Builder.() -> Unit) = deleteAgent(DeleteAgentRequest.Builder().apply(block).build())

    /**
     * Deletes the configuration of a location used by DataSync.
     */
    suspend fun deleteLocation(input: DeleteLocationRequest): DeleteLocationResponse

    /**
     * Deletes the configuration of a location used by DataSync.
     */
    suspend fun deleteLocation(block: DeleteLocationRequest.Builder.() -> Unit) = deleteLocation(DeleteLocationRequest.Builder().apply(block).build())

    /**
     * Deletes a task.
     */
    suspend fun deleteTask(input: DeleteTaskRequest): DeleteTaskResponse

    /**
     * Deletes a task.
     */
    suspend fun deleteTask(block: DeleteTaskRequest.Builder.() -> Unit) = deleteTask(DeleteTaskRequest.Builder().apply(block).build())

    /**
     * Returns metadata such as the name, the network interfaces, and the status (that is, whether the agent is running or not) for an agent. To specify which agent to describe, use the Amazon Resource Name (ARN) of the agent in your request.
     */
    suspend fun describeAgent(input: DescribeAgentRequest): DescribeAgentResponse

    /**
     * Returns metadata such as the name, the network interfaces, and the status (that is, whether the agent is running or not) for an agent. To specify which agent to describe, use the Amazon Resource Name (ARN) of the agent in your request.
     */
    suspend fun describeAgent(block: DescribeAgentRequest.Builder.() -> Unit) = describeAgent(DescribeAgentRequest.Builder().apply(block).build())

    /**
     * Returns metadata about your DataSync location for an Amazon EFS file system.
     */
    suspend fun describeLocationEfs(input: DescribeLocationEfsRequest): DescribeLocationEfsResponse

    /**
     * Returns metadata about your DataSync location for an Amazon EFS file system.
     */
    suspend fun describeLocationEfs(block: DescribeLocationEfsRequest.Builder.() -> Unit) = describeLocationEfs(DescribeLocationEfsRequest.Builder().apply(block).build())

    /**
     * Returns metadata about an Amazon FSx for Lustre location, such as information about its path.
     */
    suspend fun describeLocationFsxLustre(input: DescribeLocationFsxLustreRequest): DescribeLocationFsxLustreResponse

    /**
     * Returns metadata about an Amazon FSx for Lustre location, such as information about its path.
     */
    suspend fun describeLocationFsxLustre(block: DescribeLocationFsxLustreRequest.Builder.() -> Unit) = describeLocationFsxLustre(DescribeLocationFsxLustreRequest.Builder().apply(block).build())

    /**
     * Returns metadata about an Amazon FSx for OpenZFS location, such as information about its path.
     */
    suspend fun describeLocationFsxOpenZfs(input: DescribeLocationFsxOpenZfsRequest): DescribeLocationFsxOpenZfsResponse

    /**
     * Returns metadata about an Amazon FSx for OpenZFS location, such as information about its path.
     */
    suspend fun describeLocationFsxOpenZfs(block: DescribeLocationFsxOpenZfsRequest.Builder.() -> Unit) = describeLocationFsxOpenZfs(DescribeLocationFsxOpenZfsRequest.Builder().apply(block).build())

    /**
     * Returns metadata about an Amazon FSx for Windows File Server location, such as information about its path.
     */
    suspend fun describeLocationFsxWindows(input: DescribeLocationFsxWindowsRequest): DescribeLocationFsxWindowsResponse

    /**
     * Returns metadata about an Amazon FSx for Windows File Server location, such as information about its path.
     */
    suspend fun describeLocationFsxWindows(block: DescribeLocationFsxWindowsRequest.Builder.() -> Unit) = describeLocationFsxWindows(DescribeLocationFsxWindowsRequest.Builder().apply(block).build())

    /**
     * Returns metadata, such as the authentication information about the Hadoop Distributed File System (HDFS) location.
     */
    suspend fun describeLocationHdfs(input: DescribeLocationHdfsRequest): DescribeLocationHdfsResponse

    /**
     * Returns metadata, such as the authentication information about the Hadoop Distributed File System (HDFS) location.
     */
    suspend fun describeLocationHdfs(block: DescribeLocationHdfsRequest.Builder.() -> Unit) = describeLocationHdfs(DescribeLocationHdfsRequest.Builder().apply(block).build())

    /**
     * Returns metadata, such as the path information, about an NFS location.
     */
    suspend fun describeLocationNfs(input: DescribeLocationNfsRequest): DescribeLocationNfsResponse

    /**
     * Returns metadata, such as the path information, about an NFS location.
     */
    suspend fun describeLocationNfs(block: DescribeLocationNfsRequest.Builder.() -> Unit) = describeLocationNfs(DescribeLocationNfsRequest.Builder().apply(block).build())

    /**
     * Returns metadata about a self-managed object storage server location. For more information about self-managed object storage locations, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
     */
    suspend fun describeLocationObjectStorage(input: DescribeLocationObjectStorageRequest): DescribeLocationObjectStorageResponse

    /**
     * Returns metadata about a self-managed object storage server location. For more information about self-managed object storage locations, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
     */
    suspend fun describeLocationObjectStorage(block: DescribeLocationObjectStorageRequest.Builder.() -> Unit) = describeLocationObjectStorage(DescribeLocationObjectStorageRequest.Builder().apply(block).build())

    /**
     * Returns metadata, such as bucket name, about an Amazon S3 bucket location.
     */
    suspend fun describeLocationS3(input: DescribeLocationS3Request): DescribeLocationS3Response

    /**
     * Returns metadata, such as bucket name, about an Amazon S3 bucket location.
     */
    suspend fun describeLocationS3(block: DescribeLocationS3Request.Builder.() -> Unit) = describeLocationS3(DescribeLocationS3Request.Builder().apply(block).build())

    /**
     * Returns metadata, such as the path and user information about an SMB location.
     */
    suspend fun describeLocationSmb(input: DescribeLocationSmbRequest): DescribeLocationSmbResponse

    /**
     * Returns metadata, such as the path and user information about an SMB location.
     */
    suspend fun describeLocationSmb(block: DescribeLocationSmbRequest.Builder.() -> Unit) = describeLocationSmb(DescribeLocationSmbRequest.Builder().apply(block).build())

    /**
     * Returns metadata about a task.
     */
    suspend fun describeTask(input: DescribeTaskRequest): DescribeTaskResponse

    /**
     * Returns metadata about a task.
     */
    suspend fun describeTask(block: DescribeTaskRequest.Builder.() -> Unit) = describeTask(DescribeTaskRequest.Builder().apply(block).build())

    /**
     * Returns detailed metadata about a task that is being executed.
     */
    suspend fun describeTaskExecution(input: DescribeTaskExecutionRequest): DescribeTaskExecutionResponse

    /**
     * Returns detailed metadata about a task that is being executed.
     */
    suspend fun describeTaskExecution(block: DescribeTaskExecutionRequest.Builder.() -> Unit) = describeTaskExecution(DescribeTaskExecutionRequest.Builder().apply(block).build())

    /**
     * Returns a list of agents owned by an Amazon Web Services account in the Amazon Web Services Region specified in the request. The returned list is ordered by agent Amazon Resource Name (ARN).
     *
     * By default, this operation returns a maximum of 100 agents. This operation supports pagination that enables you to optionally reduce the number of agents returned in a response.
     *
     * If you have more agents than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a marker that you can specify in your next request to fetch the next page of agents.
     */
    suspend fun listAgents(input: ListAgentsRequest = ListAgentsRequest {}): ListAgentsResponse

    /**
     * Returns a list of agents owned by an Amazon Web Services account in the Amazon Web Services Region specified in the request. The returned list is ordered by agent Amazon Resource Name (ARN).
     *
     * By default, this operation returns a maximum of 100 agents. This operation supports pagination that enables you to optionally reduce the number of agents returned in a response.
     *
     * If you have more agents than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a marker that you can specify in your next request to fetch the next page of agents.
     */
    suspend fun listAgents(block: ListAgentsRequest.Builder.() -> Unit) = listAgents(ListAgentsRequest.Builder().apply(block).build())

    /**
     * Returns a list of source and destination locations.
     *
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a token that you can specify in your next request to fetch the next page of locations.
     */
    suspend fun listLocations(input: ListLocationsRequest = ListLocationsRequest {}): ListLocationsResponse

    /**
     * Returns a list of source and destination locations.
     *
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a token that you can specify in your next request to fetch the next page of locations.
     */
    suspend fun listLocations(block: ListLocationsRequest.Builder.() -> Unit) = listLocations(ListLocationsRequest.Builder().apply(block).build())

    /**
     * Returns all the tags associated with a specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns all the tags associated with a specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Returns a list of executed tasks.
     */
    suspend fun listTaskExecutions(input: ListTaskExecutionsRequest = ListTaskExecutionsRequest {}): ListTaskExecutionsResponse

    /**
     * Returns a list of executed tasks.
     */
    suspend fun listTaskExecutions(block: ListTaskExecutionsRequest.Builder.() -> Unit) = listTaskExecutions(ListTaskExecutionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all the tasks.
     */
    suspend fun listTasks(input: ListTasksRequest = ListTasksRequest {}): ListTasksResponse

    /**
     * Returns a list of all the tasks.
     */
    suspend fun listTasks(block: ListTasksRequest.Builder.() -> Unit) = listTasks(ListTasksRequest.Builder().apply(block).build())

    /**
     * Starts a specific invocation of a task. A `TaskExecution` value represents an individual run of a task. Each task can have at most one `TaskExecution` at a time.
     *
     * `TaskExecution` has the following transition phases: INITIALIZING | PREPARING | TRANSFERRING | VERIFYING | SUCCESS/FAILURE.
     *
     * For detailed information, see the Task Execution section in the Components and Terminology topic in the *DataSync User Guide*.
     */
    suspend fun startTaskExecution(input: StartTaskExecutionRequest): StartTaskExecutionResponse

    /**
     * Starts a specific invocation of a task. A `TaskExecution` value represents an individual run of a task. Each task can have at most one `TaskExecution` at a time.
     *
     * `TaskExecution` has the following transition phases: INITIALIZING | PREPARING | TRANSFERRING | VERIFYING | SUCCESS/FAILURE.
     *
     * For detailed information, see the Task Execution section in the Components and Terminology topic in the *DataSync User Guide*.
     */
    suspend fun startTaskExecution(block: StartTaskExecutionRequest.Builder.() -> Unit) = startTaskExecution(StartTaskExecutionRequest.Builder().apply(block).build())

    /**
     * Applies a key-value pair to an Amazon Web Services resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Applies a key-value pair to an Amazon Web Services resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes a tag from an Amazon Web Services resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from an Amazon Web Services resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the name of an agent.
     */
    suspend fun updateAgent(input: UpdateAgentRequest): UpdateAgentResponse

    /**
     * Updates the name of an agent.
     */
    suspend fun updateAgent(block: UpdateAgentRequest.Builder.() -> Unit) = updateAgent(UpdateAgentRequest.Builder().apply(block).build())

    /**
     * Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.
     */
    suspend fun updateLocationHdfs(input: UpdateLocationHdfsRequest): UpdateLocationHdfsResponse

    /**
     * Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.
     */
    suspend fun updateLocationHdfs(block: UpdateLocationHdfsRequest.Builder.() -> Unit) = updateLocationHdfs(UpdateLocationHdfsRequest.Builder().apply(block).build())

    /**
     * Updates some of the parameters of a previously created location for Network File System (NFS) access. For information about creating an NFS location, see [Creating a location for NFS](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html).
     */
    suspend fun updateLocationNfs(input: UpdateLocationNfsRequest): UpdateLocationNfsResponse

    /**
     * Updates some of the parameters of a previously created location for Network File System (NFS) access. For information about creating an NFS location, see [Creating a location for NFS](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html).
     */
    suspend fun updateLocationNfs(block: UpdateLocationNfsRequest.Builder.() -> Unit) = updateLocationNfs(UpdateLocationNfsRequest.Builder().apply(block).build())

    /**
     * Updates some of the parameters of a previously created location for self-managed object storage server access. For information about creating a self-managed object storage location, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
     */
    suspend fun updateLocationObjectStorage(input: UpdateLocationObjectStorageRequest): UpdateLocationObjectStorageResponse

    /**
     * Updates some of the parameters of a previously created location for self-managed object storage server access. For information about creating a self-managed object storage location, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
     */
    suspend fun updateLocationObjectStorage(block: UpdateLocationObjectStorageRequest.Builder.() -> Unit) = updateLocationObjectStorage(UpdateLocationObjectStorageRequest.Builder().apply(block).build())

    /**
     * Updates some of the parameters of a previously created location for Server Message Block (SMB) file system access. For information about creating an SMB location, see [Creating a location for SMB](https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html).
     */
    suspend fun updateLocationSmb(input: UpdateLocationSmbRequest): UpdateLocationSmbResponse

    /**
     * Updates some of the parameters of a previously created location for Server Message Block (SMB) file system access. For information about creating an SMB location, see [Creating a location for SMB](https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html).
     */
    suspend fun updateLocationSmb(block: UpdateLocationSmbRequest.Builder.() -> Unit) = updateLocationSmb(UpdateLocationSmbRequest.Builder().apply(block).build())

    /**
     * Updates the metadata associated with a task.
     */
    suspend fun updateTask(input: UpdateTaskRequest): UpdateTaskResponse

    /**
     * Updates the metadata associated with a task.
     */
    suspend fun updateTask(block: UpdateTaskRequest.Builder.() -> Unit) = updateTask(UpdateTaskRequest.Builder().apply(block).build())

    /**
     * Updates execution of a task.
     *
     * You can modify bandwidth throttling for a task execution that is running or queued. For more information, see [Adjusting Bandwidth Throttling for a Task Execution](https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#adjust-bandwidth-throttling).
     *
     * The only `Option` that can be modified by `UpdateTaskExecution` is ` <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> `.
     */
    suspend fun updateTaskExecution(input: UpdateTaskExecutionRequest): UpdateTaskExecutionResponse

    /**
     * Updates execution of a task.
     *
     * You can modify bandwidth throttling for a task execution that is running or queued. For more information, see [Adjusting Bandwidth Throttling for a Task Execution](https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#adjust-bandwidth-throttling).
     *
     * The only `Option` that can be modified by `UpdateTaskExecution` is ` <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> `.
     */
    suspend fun updateTaskExecution(block: UpdateTaskExecutionRequest.Builder.() -> Unit) = updateTaskExecution(UpdateTaskExecutionRequest.Builder().apply(block).build())
}
