// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * CreateLocationObjectStorageRequest
 */
class CreateLocationObjectStorageRequest private constructor(builder: Builder) {
    /**
     * Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `AccessKey` and `SecretKey` to provide the user name and password, respectively.
     */
    val accessKey: kotlin.String? = builder.accessKey
    /**
     * The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
     */
    val agentArns: List<String>? = builder.agentArns
    /**
     * The bucket on the self-managed object storage server that is used to read data from.
     */
    val bucketName: kotlin.String? = builder.bucketName
    /**
     * Optional. The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `AccessKey` and `SecretKey` to provide the user name and password, respectively.
     */
    val secretKey: kotlin.String? = builder.secretKey
    /**
     * The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this hostname to mount the object storage server in a network.
     */
    val serverHostname: kotlin.String? = builder.serverHostname
    /**
     * The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage server requires one.
     */
    val serverPort: kotlin.Int? = builder.serverPort
    /**
     * The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.
     */
    val serverProtocol: aws.sdk.kotlin.services.datasync.model.ObjectStorageServerProtocol? = builder.serverProtocol
    /**
     * The subdirectory in the self-managed object storage server that is used to read data from.
     */
    val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.
     */
    val tags: List<TagListEntry>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationObjectStorageRequest(")
        append("accessKey=$accessKey,")
        append("agentArns=$agentArns,")
        append("bucketName=$bucketName,")
        append("secretKey=*** Sensitive Data Redacted ***,")
        append("serverHostname=$serverHostname,")
        append("serverPort=$serverPort,")
        append("serverProtocol=$serverProtocol,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKey?.hashCode() ?: 0
        result = 31 * result + (agentArns?.hashCode() ?: 0)
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (secretKey?.hashCode() ?: 0)
        result = 31 * result + (serverHostname?.hashCode() ?: 0)
        result = 31 * result + (serverPort ?: 0)
        result = 31 * result + (serverProtocol?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationObjectStorageRequest

        if (accessKey != other.accessKey) return false
        if (agentArns != other.agentArns) return false
        if (bucketName != other.bucketName) return false
        if (secretKey != other.secretKey) return false
        if (serverHostname != other.serverHostname) return false
        if (serverPort != other.serverPort) return false
        if (serverProtocol != other.serverProtocol) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `AccessKey` and `SecretKey` to provide the user name and password, respectively.
         */
        var accessKey: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
         */
        var agentArns: List<String>? = null
        /**
         * The bucket on the self-managed object storage server that is used to read data from.
         */
        var bucketName: kotlin.String? = null
        /**
         * Optional. The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `AccessKey` and `SecretKey` to provide the user name and password, respectively.
         */
        var secretKey: kotlin.String? = null
        /**
         * The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this hostname to mount the object storage server in a network.
         */
        var serverHostname: kotlin.String? = null
        /**
         * The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage server requires one.
         */
        var serverPort: kotlin.Int? = null
        /**
         * The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.
         */
        var serverProtocol: aws.sdk.kotlin.services.datasync.model.ObjectStorageServerProtocol? = null
        /**
         * The subdirectory in the self-managed object storage server that is used to read data from.
         */
        var subdirectory: kotlin.String? = null
        /**
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.
         */
        var tags: List<TagListEntry>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageRequest) : this() {
            this.accessKey = x.accessKey
            this.agentArns = x.agentArns
            this.bucketName = x.bucketName
            this.secretKey = x.secretKey
            this.serverHostname = x.serverHostname
            this.serverPort = x.serverPort
            this.serverProtocol = x.serverProtocol
            this.subdirectory = x.subdirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageRequest = CreateLocationObjectStorageRequest(this)
    }
}
