// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * CreateLocationSmbRequest
 */
class CreateLocationSmbRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.
     */
    val agentArns: List<String>? = builder.agentArns
    /**
     * The name of the Windows domain that the SMB server belongs to.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * The mount options used by DataSync to access the SMB server.
     */
    val mountOptions: aws.sdk.kotlin.services.datasync.model.SmbMountOptions? = builder.mountOptions
    /**
     * The password of the user who can mount the share, has the permissions to access files and folders in the SMB share.
     */
    val password: kotlin.String? = builder.password
    /**
     * The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name of the SMB server. An agent that is installed on-premises uses this hostname to mount the SMB server in a network.
     *
     * This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.
     */
    val serverHostname: kotlin.String? = builder.serverHostname
    /**
     * The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.
     *
     * `Subdirectory` must be specified with forward slashes. For example, `/path/to/folder`.
     *
     * To transfer all the data in the folder you specified, DataSync needs to have permissions to mount the SMB share, as well as to access all the data in that share. To ensure this, either ensure that the user/password specified belongs to the user who can mount the share, and who has the appropriate permissions for all of the files and directories that you want DataSync to access, or use credentials of a member of the Backup Operators group to mount the share. Doing either enables the agent to access the data. For the agent to access directories, you must additionally enable all execute access.
     */
    val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.
     */
    val tags: List<TagListEntry>? = builder.tags
    /**
     * The user who can mount the share, has the permissions to access files and folders in the SMB share.
     *
     * For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see [user](create-smb-location.html#SMBuser).
     */
    val user: kotlin.String? = builder.user

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationSmbRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationSmbRequest(")
        append("agentArns=$agentArns,")
        append("domain=$domain,")
        append("mountOptions=$mountOptions,")
        append("password=*** Sensitive Data Redacted ***,")
        append("serverHostname=$serverHostname,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags,")
        append("user=$user)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArns?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (mountOptions?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (serverHostname?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationSmbRequest

        if (agentArns != other.agentArns) return false
        if (domain != other.domain) return false
        if (mountOptions != other.mountOptions) return false
        if (password != other.password) return false
        if (serverHostname != other.serverHostname) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false
        if (user != other.user) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationSmbRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.
         */
        var agentArns: List<String>? = null
        /**
         * The name of the Windows domain that the SMB server belongs to.
         */
        var domain: kotlin.String? = null
        /**
         * The mount options used by DataSync to access the SMB server.
         */
        var mountOptions: aws.sdk.kotlin.services.datasync.model.SmbMountOptions? = null
        /**
         * The password of the user who can mount the share, has the permissions to access files and folders in the SMB share.
         */
        var password: kotlin.String? = null
        /**
         * The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name of the SMB server. An agent that is installed on-premises uses this hostname to mount the SMB server in a network.
         *
         * This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.
         */
        var serverHostname: kotlin.String? = null
        /**
         * The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.
         *
         * `Subdirectory` must be specified with forward slashes. For example, `/path/to/folder`.
         *
         * To transfer all the data in the folder you specified, DataSync needs to have permissions to mount the SMB share, as well as to access all the data in that share. To ensure this, either ensure that the user/password specified belongs to the user who can mount the share, and who has the appropriate permissions for all of the files and directories that you want DataSync to access, or use credentials of a member of the Backup Operators group to mount the share. Doing either enables the agent to access the data. For the agent to access directories, you must additionally enable all execute access.
         */
        var subdirectory: kotlin.String? = null
        /**
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.
         */
        var tags: List<TagListEntry>? = null
        /**
         * The user who can mount the share, has the permissions to access files and folders in the SMB share.
         *
         * For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see [user](create-smb-location.html#SMBuser).
         */
        var user: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationSmbRequest) : this() {
            this.agentArns = x.agentArns
            this.domain = x.domain
            this.mountOptions = x.mountOptions
            this.password = x.password
            this.serverHostname = x.serverHostname
            this.subdirectory = x.subdirectory
            this.tags = x.tags
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationSmbRequest = CreateLocationSmbRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.SmbMountOptions] inside the given [block]
         */
        fun mountOptions(block: aws.sdk.kotlin.services.datasync.model.SmbMountOptions.Builder.() -> kotlin.Unit) {
            this.mountOptions = aws.sdk.kotlin.services.datasync.model.SmbMountOptions.invoke(block)
        }
    }
}
