// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * DescribeTaskResponse
 */
class DescribeTaskResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in the task.
     *
     * For more information on these groups, see Working with Log Groups and Log Streams in the *Amazon CloudWatch User Guide*.
     */
    val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * The time that the task was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the task execution that is syncing files.
     */
    val currentTaskExecutionArn: kotlin.String? = builder.currentTaskExecutionArn
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.
     */
    val destinationLocationArn: kotlin.String? = builder.destinationLocationArn
    /**
     * The Amazon Resource Names (ARNs) of the destination elastic network interfaces (ENIs) that were created for your subnet.
     */
    val destinationNetworkInterfaceArns: List<String>? = builder.destinationNetworkInterfaceArns
    /**
     * Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.
     */
    val errorCode: kotlin.String? = builder.errorCode
    /**
     * Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues.
     */
    val errorDetail: kotlin.String? = builder.errorDetail
    /**
     * A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
     */
    val excludes: List<FilterRule>? = builder.excludes
    /**
     * A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2`".
     */
    val includes: List<FilterRule>? = builder.includes
    /**
     * The name of the task that was described.
     */
    val name: kotlin.String? = builder.name
    /**
     * The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution`. You can configure these options to preserve metadata such as user ID (UID) and group (GID), file permissions, data integrity verification, and so on.
     *
     * For each individual task execution, you can override these options by specifying the overriding `OverrideOptions` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation.
     */
    val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * The schedule used to periodically transfer files from a source to a destination location.
     */
    val schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = builder.schedule
    /**
     * The Amazon Resource Name (ARN) of the source file system's location.
     */
    val sourceLocationArn: kotlin.String? = builder.sourceLocationArn
    /**
     * The Amazon Resource Names (ARNs) of the source elastic network interfaces (ENIs) that were created for your subnet.
     */
    val sourceNetworkInterfaceArns: List<String>? = builder.sourceNetworkInterfaceArns
    /**
     * The status of the task that was described.
     *
     * For detailed information about task execution statuses, see Understanding Task Statuses in the *DataSync User Guide*.
     */
    val status: aws.sdk.kotlin.services.datasync.model.TaskStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the task that was described.
     */
    val taskArn: kotlin.String? = builder.taskArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTaskResponse(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("creationTime=$creationTime,")
        append("currentTaskExecutionArn=$currentTaskExecutionArn,")
        append("destinationLocationArn=$destinationLocationArn,")
        append("destinationNetworkInterfaceArns=$destinationNetworkInterfaceArns,")
        append("errorCode=$errorCode,")
        append("errorDetail=$errorDetail,")
        append("excludes=$excludes,")
        append("includes=$includes,")
        append("name=$name,")
        append("options=$options,")
        append("schedule=$schedule,")
        append("sourceLocationArn=$sourceLocationArn,")
        append("sourceNetworkInterfaceArns=$sourceNetworkInterfaceArns,")
        append("status=$status,")
        append("taskArn=$taskArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (currentTaskExecutionArn?.hashCode() ?: 0)
        result = 31 * result + (destinationLocationArn?.hashCode() ?: 0)
        result = 31 * result + (destinationNetworkInterfaceArns?.hashCode() ?: 0)
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorDetail?.hashCode() ?: 0)
        result = 31 * result + (excludes?.hashCode() ?: 0)
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (sourceLocationArn?.hashCode() ?: 0)
        result = 31 * result + (sourceNetworkInterfaceArns?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTaskResponse

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (creationTime != other.creationTime) return false
        if (currentTaskExecutionArn != other.currentTaskExecutionArn) return false
        if (destinationLocationArn != other.destinationLocationArn) return false
        if (destinationNetworkInterfaceArns != other.destinationNetworkInterfaceArns) return false
        if (errorCode != other.errorCode) return false
        if (errorDetail != other.errorDetail) return false
        if (excludes != other.excludes) return false
        if (includes != other.includes) return false
        if (name != other.name) return false
        if (options != other.options) return false
        if (schedule != other.schedule) return false
        if (sourceLocationArn != other.sourceLocationArn) return false
        if (sourceNetworkInterfaceArns != other.sourceNetworkInterfaceArns) return false
        if (status != other.status) return false
        if (taskArn != other.taskArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in the task.
         *
         * For more information on these groups, see Working with Log Groups and Log Streams in the *Amazon CloudWatch User Guide*.
         */
        var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * The time that the task was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the task execution that is syncing files.
         */
        var currentTaskExecutionArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.
         */
        var destinationLocationArn: kotlin.String? = null
        /**
         * The Amazon Resource Names (ARNs) of the destination elastic network interfaces (ENIs) that were created for your subnet.
         */
        var destinationNetworkInterfaceArns: List<String>? = null
        /**
         * Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.
         */
        var errorCode: kotlin.String? = null
        /**
         * Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues.
         */
        var errorDetail: kotlin.String? = null
        /**
         * A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
         */
        var excludes: List<FilterRule>? = null
        /**
         * A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2`".
         */
        var includes: List<FilterRule>? = null
        /**
         * The name of the task that was described.
         */
        var name: kotlin.String? = null
        /**
         * The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution`. You can configure these options to preserve metadata such as user ID (UID) and group (GID), file permissions, data integrity verification, and so on.
         *
         * For each individual task execution, you can override these options by specifying the overriding `OverrideOptions` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation.
         */
        var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * The schedule used to periodically transfer files from a source to a destination location.
         */
        var schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = null
        /**
         * The Amazon Resource Name (ARN) of the source file system's location.
         */
        var sourceLocationArn: kotlin.String? = null
        /**
         * The Amazon Resource Names (ARNs) of the source elastic network interfaces (ENIs) that were created for your subnet.
         */
        var sourceNetworkInterfaceArns: List<String>? = null
        /**
         * The status of the task that was described.
         *
         * For detailed information about task execution statuses, see Understanding Task Statuses in the *DataSync User Guide*.
         */
        var status: aws.sdk.kotlin.services.datasync.model.TaskStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the task that was described.
         */
        var taskArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.creationTime = x.creationTime
            this.currentTaskExecutionArn = x.currentTaskExecutionArn
            this.destinationLocationArn = x.destinationLocationArn
            this.destinationNetworkInterfaceArns = x.destinationNetworkInterfaceArns
            this.errorCode = x.errorCode
            this.errorDetail = x.errorDetail
            this.excludes = x.excludes
            this.includes = x.includes
            this.name = x.name
            this.options = x.options
            this.schedule = x.schedule
            this.sourceLocationArn = x.sourceLocationArn
            this.sourceNetworkInterfaceArns = x.sourceNetworkInterfaceArns
            this.status = x.status
            this.taskArn = x.taskArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse = DescribeTaskResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskSchedule] inside the given [block]
         */
        fun schedule(block: aws.sdk.kotlin.services.datasync.model.TaskSchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.datasync.model.TaskSchedule.invoke(block)
        }
    }
}
