// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * Represents the mount options that are available for DataSync to access an NFS location.
 */
class NfsMountOptions private constructor(builder: Builder) {
    /**
     * The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to use the version specified, the sync will fail. If you don't specify a version, DataSync defaults to `AUTOMATIC`. That is, DataSync automatically selects a version based on negotiation with the NFS server.
     *
     * You can specify the following NFS versions:
     * + **[NFSv3](https://tools.ietf.org/html/rfc1813)** - stateless protocol version that allows for asynchronous writes on the server.
     * + **[NFSv4.0](https://tools.ietf.org/html/rfc3530)** - stateful, firewall-friendly protocol version that supports delegations and pseudo file systems.
     * + **[NFSv4.1](https://tools.ietf.org/html/rfc5661)** - stateful protocol version that supports sessions, directory delegations, and parallel data processing. Version 4.1 also includes all features available in version 4.0.
     */
    val version: aws.sdk.kotlin.services.datasync.model.NfsVersion? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.NfsMountOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NfsMountOptions(")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = version?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NfsMountOptions

        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.NfsMountOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to use the version specified, the sync will fail. If you don't specify a version, DataSync defaults to `AUTOMATIC`. That is, DataSync automatically selects a version based on negotiation with the NFS server.
         *
         * You can specify the following NFS versions:
         * + **[NFSv3](https://tools.ietf.org/html/rfc1813)** - stateless protocol version that allows for asynchronous writes on the server.
         * + **[NFSv4.0](https://tools.ietf.org/html/rfc3530)** - stateful, firewall-friendly protocol version that supports delegations and pseudo file systems.
         * + **[NFSv4.1](https://tools.ietf.org/html/rfc5661)** - stateful protocol version that supports sessions, directory delegations, and parallel data processing. Version 4.1 also includes all features available in version 4.0.
         */
        var version: aws.sdk.kotlin.services.datasync.model.NfsVersion? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.NfsMountOptions) : this() {
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.NfsMountOptions = NfsMountOptions(this)
    }
}
