// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * Represents the options that are available to control the behavior of a [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.
 *
 * A task has a set of default options associated with it. If you don't specify an option in [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html), the default value is used. You can override the defaults options on each task execution by specifying an overriding `Options` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
 */
class Options private constructor(builder: Builder) {
    /**
     * A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to). If you set `Atime` to BEST_EFFORT, DataSync attempts to preserve the original `Atime` attribute on all source files (that is, the version before the PREPARING phase). However, `Atime`'s behavior is not fully standard across platforms, so DataSync can only do this on a best-effort basis.
     *
     * Default value: BEST_EFFORT.
     *
     * BEST_EFFORT: Attempt to preserve the per-file `Atime` value (recommended).
     *
     * NONE: Ignore `Atime`.
     *
     * If `Atime` is set to BEST_EFFORT, `Mtime` must be set to PRESERVE.
     *
     * If `Atime` is set to NONE, `Mtime` must also be NONE.
     */
    val atime: aws.sdk.kotlin.services.datasync.model.Atime? = builder.atime
    /**
     * A value that limits the bandwidth used by DataSync. For example, if you want DataSync to use a maximum of 1 MB, set this value to `1048576` (`=1024*1024`).
     */
    val bytesPerSecond: kotlin.Long? = builder.bytesPerSecond
    /**
     * The POSIX group ID (GID) of the file's owners. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see [Metadata Copied by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied).
     *
     * Default value: INT_VALUE. This preserves the integer value of the ID.
     *
     * INT_VALUE: Preserve the integer value of user ID (UID) and GID (recommended).
     *
     * NONE: Ignore UID and GID.
     */
    val gid: aws.sdk.kotlin.services.datasync.model.Gid? = builder.gid
    /**
     * A value that determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. For more information about providing a log group for DataSync, see [CloudWatchLogGroupArn](https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn). If set to `OFF`, no logs are published. `BASIC` publishes logs on errors for individual files transferred, and `TRANSFER` publishes logs for every file or object that is transferred and integrity checked.
     */
    val logLevel: aws.sdk.kotlin.services.datasync.model.LogLevel? = builder.logLevel
    /**
     * A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase. This option is required for cases when you need to run the same task more than one time.
     *
     * Default Value: `PRESERVE`
     *
     * PRESERVE: Preserve original `Mtime` (recommended)
     *
     *  NONE: Ignore `Mtime`.
     *
     * If `Mtime` is set to PRESERVE, `Atime` must be set to BEST_EFFORT.
     *
     * If `Mtime` is set to NONE, `Atime` must also be set to NONE.
     */
    val mtime: aws.sdk.kotlin.services.datasync.model.Mtime? = builder.mtime
    /**
     * Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the `NONE` value.
     *
     * Default Value: `PRESERVE`
     */
    val objectTags: aws.sdk.kotlin.services.datasync.model.ObjectTags? = builder.objectTags
    /**
     * A value that determines whether files at the destination should be overwritten or preserved when copying files. If set to `NEVER` a destination file will not be replaced by a source file, even if the destination file differs from the source file. If you modify files in the destination and you sync the files, you can use this value to protect against overwriting those changes.
     *
     * Some storage classes have specific behaviors that can affect your S3 storage cost. For detailed information, see [Considerations when working with Amazon S3 storage classes in DataSync ](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes) in the *DataSync User Guide*.
     */
    val overwriteMode: aws.sdk.kotlin.services.datasync.model.OverwriteMode? = builder.overwriteMode
    /**
     * A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see [Metadata Copied by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied).
     *
     * Default value: PRESERVE.
     *
     * PRESERVE: Preserve POSIX-style permissions (recommended).
     *
     * NONE: Ignore permissions.
     *
     * DataSync can preserve extant permissions of a source location.
     */
    val posixPermissions: aws.sdk.kotlin.services.datasync.model.PosixPermissions? = builder.posixPermissions
    /**
     * A value that specifies whether files in the destination that don't exist in the source file system should be preserved. This option can affect your storage cost. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see [Considerations when working with Amazon S3 storage classes in DataSync ](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes) in the *DataSync User Guide*.
     *
     * Default value: PRESERVE.
     *
     * PRESERVE: Ignore such destination files (recommended).
     *
     * REMOVE: Delete destination files that aren’t present in the source.
     */
    val preserveDeletedFiles: aws.sdk.kotlin.services.datasync.model.PreserveDeletedFiles? = builder.preserveDeletedFiles
    /**
     * A value that determines whether DataSync should preserve the metadata of block and character devices in the source file system, and re-create the files with that device name and metadata on the destination. DataSync does not copy the contents of such devices, only the name and metadata.
     *
     * DataSync can't sync the actual contents of such devices, because they are nonterminal and don't return an end-of-file (EOF) marker.
     *
     * Default value: NONE.
     *
     * NONE: Ignore special devices (recommended).
     *
     * PRESERVE: Preserve character and block device metadata. This option isn't currently supported for Amazon EFS.
     */
    val preserveDevices: aws.sdk.kotlin.services.datasync.model.PreserveDevices? = builder.preserveDevices
    /**
     * A value that determines which components of the SMB security descriptor are copied from source to destination objects.
     *
     * This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. For more information about how DataSync handles metadata, see [How DataSync Handles Metadata and Special Files](https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html).
     *
     * Default value: OWNER_DACL.
     *
     * **OWNER_DACL**: For each copied object, DataSync copies the following metadata:
     * + Object owner.
     * + NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.
     *
     * When choosing this option, DataSync does NOT copy the NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.
     *
     * **OWNER_DACL_SACL**: For each copied object, DataSync copies the following metadata:
     * + Object owner.
     * + NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.
     * + NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.
     *
     * Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user that ensures sufficient permissions to files, folders, and metadata, see [user](create-smb-location.html#SMBuser).
     *
     * **NONE**: None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration.
     */
    val securityDescriptorCopyFlags: aws.sdk.kotlin.services.datasync.model.SmbSecurityDescriptorCopyFlags? = builder.securityDescriptorCopyFlags
    /**
     * A value that determines whether tasks should be queued before executing the tasks. If set to `ENABLED`, the tasks will be queued. The default is `ENABLED`.
     *
     * If you use the same agent to run multiple tasks, you can enable the tasks to run in series. For more information, see [Queueing task executions](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution).
     */
    val taskQueueing: aws.sdk.kotlin.services.datasync.model.TaskQueueing? = builder.taskQueueing
    /**
     * A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location.
     *
     * CHANGED: DataSync copies only data or metadata that is new or different content from the source location to the destination location.
     *
     * ALL: DataSync copies all source location content to the destination, without comparing to existing content on the destination.
     */
    val transferMode: aws.sdk.kotlin.services.datasync.model.TransferMode? = builder.transferMode
    /**
     * The POSIX user ID (UID) of the file's owner. This option should only be set for NFS, EFS, and S3 locations. To learn more about what metadata is copied by DataSync, see [Metadata Copied by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied).
     *
     * Default value: INT_VALUE. This preserves the integer value of the ID.
     *
     * INT_VALUE: Preserve the integer value of UID and group ID (GID) (recommended).
     *
     * NONE: Ignore UID and GID.
     */
    val uid: aws.sdk.kotlin.services.datasync.model.Uid? = builder.uid
    /**
     * A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. For more information, see [Configure task settings](https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html).
     *
     * Default value: POINT_IN_TIME_CONSISTENT.
     *
     * ONLY_FILES_TRANSFERRED (recommended): Perform verification only on files that were transferred.
     *
     * POINT_IN_TIME_CONSISTENT: Scan the entire source and entire destination at the end of the transfer to verify that source and destination are fully synchronized. This option isn't supported when transferring to S3 Glacier Flexible Retrieval or S3 Glacier Deep Archive storage classes.
     *
     * NONE: No additional verification is done at the end of the transfer, but all data transmissions are integrity-checked with checksum verification during the transfer.
     */
    val verifyMode: aws.sdk.kotlin.services.datasync.model.VerifyMode? = builder.verifyMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.Options = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Options(")
        append("atime=$atime,")
        append("bytesPerSecond=$bytesPerSecond,")
        append("gid=$gid,")
        append("logLevel=$logLevel,")
        append("mtime=$mtime,")
        append("objectTags=$objectTags,")
        append("overwriteMode=$overwriteMode,")
        append("posixPermissions=$posixPermissions,")
        append("preserveDeletedFiles=$preserveDeletedFiles,")
        append("preserveDevices=$preserveDevices,")
        append("securityDescriptorCopyFlags=$securityDescriptorCopyFlags,")
        append("taskQueueing=$taskQueueing,")
        append("transferMode=$transferMode,")
        append("uid=$uid,")
        append("verifyMode=$verifyMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = atime?.hashCode() ?: 0
        result = 31 * result + (bytesPerSecond?.hashCode() ?: 0)
        result = 31 * result + (gid?.hashCode() ?: 0)
        result = 31 * result + (logLevel?.hashCode() ?: 0)
        result = 31 * result + (mtime?.hashCode() ?: 0)
        result = 31 * result + (objectTags?.hashCode() ?: 0)
        result = 31 * result + (overwriteMode?.hashCode() ?: 0)
        result = 31 * result + (posixPermissions?.hashCode() ?: 0)
        result = 31 * result + (preserveDeletedFiles?.hashCode() ?: 0)
        result = 31 * result + (preserveDevices?.hashCode() ?: 0)
        result = 31 * result + (securityDescriptorCopyFlags?.hashCode() ?: 0)
        result = 31 * result + (taskQueueing?.hashCode() ?: 0)
        result = 31 * result + (transferMode?.hashCode() ?: 0)
        result = 31 * result + (uid?.hashCode() ?: 0)
        result = 31 * result + (verifyMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Options

        if (atime != other.atime) return false
        if (bytesPerSecond != other.bytesPerSecond) return false
        if (gid != other.gid) return false
        if (logLevel != other.logLevel) return false
        if (mtime != other.mtime) return false
        if (objectTags != other.objectTags) return false
        if (overwriteMode != other.overwriteMode) return false
        if (posixPermissions != other.posixPermissions) return false
        if (preserveDeletedFiles != other.preserveDeletedFiles) return false
        if (preserveDevices != other.preserveDevices) return false
        if (securityDescriptorCopyFlags != other.securityDescriptorCopyFlags) return false
        if (taskQueueing != other.taskQueueing) return false
        if (transferMode != other.transferMode) return false
        if (uid != other.uid) return false
        if (verifyMode != other.verifyMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.Options = Builder(this).apply(block).build()

    class Builder {
        /**
         * A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to). If you set `Atime` to BEST_EFFORT, DataSync attempts to preserve the original `Atime` attribute on all source files (that is, the version before the PREPARING phase). However, `Atime`'s behavior is not fully standard across platforms, so DataSync can only do this on a best-effort basis.
         *
         * Default value: BEST_EFFORT.
         *
         * BEST_EFFORT: Attempt to preserve the per-file `Atime` value (recommended).
         *
         * NONE: Ignore `Atime`.
         *
         * If `Atime` is set to BEST_EFFORT, `Mtime` must be set to PRESERVE.
         *
         * If `Atime` is set to NONE, `Mtime` must also be NONE.
         */
        var atime: aws.sdk.kotlin.services.datasync.model.Atime? = null
        /**
         * A value that limits the bandwidth used by DataSync. For example, if you want DataSync to use a maximum of 1 MB, set this value to `1048576` (`=1024*1024`).
         */
        var bytesPerSecond: kotlin.Long? = null
        /**
         * The POSIX group ID (GID) of the file's owners. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see [Metadata Copied by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied).
         *
         * Default value: INT_VALUE. This preserves the integer value of the ID.
         *
         * INT_VALUE: Preserve the integer value of user ID (UID) and GID (recommended).
         *
         * NONE: Ignore UID and GID.
         */
        var gid: aws.sdk.kotlin.services.datasync.model.Gid? = null
        /**
         * A value that determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. For more information about providing a log group for DataSync, see [CloudWatchLogGroupArn](https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn). If set to `OFF`, no logs are published. `BASIC` publishes logs on errors for individual files transferred, and `TRANSFER` publishes logs for every file or object that is transferred and integrity checked.
         */
        var logLevel: aws.sdk.kotlin.services.datasync.model.LogLevel? = null
        /**
         * A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase. This option is required for cases when you need to run the same task more than one time.
         *
         * Default Value: `PRESERVE`
         *
         * PRESERVE: Preserve original `Mtime` (recommended)
         *
         *  NONE: Ignore `Mtime`.
         *
         * If `Mtime` is set to PRESERVE, `Atime` must be set to BEST_EFFORT.
         *
         * If `Mtime` is set to NONE, `Atime` must also be set to NONE.
         */
        var mtime: aws.sdk.kotlin.services.datasync.model.Mtime? = null
        /**
         * Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the `NONE` value.
         *
         * Default Value: `PRESERVE`
         */
        var objectTags: aws.sdk.kotlin.services.datasync.model.ObjectTags? = null
        /**
         * A value that determines whether files at the destination should be overwritten or preserved when copying files. If set to `NEVER` a destination file will not be replaced by a source file, even if the destination file differs from the source file. If you modify files in the destination and you sync the files, you can use this value to protect against overwriting those changes.
         *
         * Some storage classes have specific behaviors that can affect your S3 storage cost. For detailed information, see [Considerations when working with Amazon S3 storage classes in DataSync ](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes) in the *DataSync User Guide*.
         */
        var overwriteMode: aws.sdk.kotlin.services.datasync.model.OverwriteMode? = null
        /**
         * A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see [Metadata Copied by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied).
         *
         * Default value: PRESERVE.
         *
         * PRESERVE: Preserve POSIX-style permissions (recommended).
         *
         * NONE: Ignore permissions.
         *
         * DataSync can preserve extant permissions of a source location.
         */
        var posixPermissions: aws.sdk.kotlin.services.datasync.model.PosixPermissions? = null
        /**
         * A value that specifies whether files in the destination that don't exist in the source file system should be preserved. This option can affect your storage cost. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see [Considerations when working with Amazon S3 storage classes in DataSync ](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes) in the *DataSync User Guide*.
         *
         * Default value: PRESERVE.
         *
         * PRESERVE: Ignore such destination files (recommended).
         *
         * REMOVE: Delete destination files that aren’t present in the source.
         */
        var preserveDeletedFiles: aws.sdk.kotlin.services.datasync.model.PreserveDeletedFiles? = null
        /**
         * A value that determines whether DataSync should preserve the metadata of block and character devices in the source file system, and re-create the files with that device name and metadata on the destination. DataSync does not copy the contents of such devices, only the name and metadata.
         *
         * DataSync can't sync the actual contents of such devices, because they are nonterminal and don't return an end-of-file (EOF) marker.
         *
         * Default value: NONE.
         *
         * NONE: Ignore special devices (recommended).
         *
         * PRESERVE: Preserve character and block device metadata. This option isn't currently supported for Amazon EFS.
         */
        var preserveDevices: aws.sdk.kotlin.services.datasync.model.PreserveDevices? = null
        /**
         * A value that determines which components of the SMB security descriptor are copied from source to destination objects.
         *
         * This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. For more information about how DataSync handles metadata, see [How DataSync Handles Metadata and Special Files](https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html).
         *
         * Default value: OWNER_DACL.
         *
         * **OWNER_DACL**: For each copied object, DataSync copies the following metadata:
         * + Object owner.
         * + NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.
         *
         * When choosing this option, DataSync does NOT copy the NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.
         *
         * **OWNER_DACL_SACL**: For each copied object, DataSync copies the following metadata:
         * + Object owner.
         * + NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.
         * + NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.
         *
         * Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user that ensures sufficient permissions to files, folders, and metadata, see [user](create-smb-location.html#SMBuser).
         *
         * **NONE**: None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration.
         */
        var securityDescriptorCopyFlags: aws.sdk.kotlin.services.datasync.model.SmbSecurityDescriptorCopyFlags? = null
        /**
         * A value that determines whether tasks should be queued before executing the tasks. If set to `ENABLED`, the tasks will be queued. The default is `ENABLED`.
         *
         * If you use the same agent to run multiple tasks, you can enable the tasks to run in series. For more information, see [Queueing task executions](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution).
         */
        var taskQueueing: aws.sdk.kotlin.services.datasync.model.TaskQueueing? = null
        /**
         * A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location.
         *
         * CHANGED: DataSync copies only data or metadata that is new or different content from the source location to the destination location.
         *
         * ALL: DataSync copies all source location content to the destination, without comparing to existing content on the destination.
         */
        var transferMode: aws.sdk.kotlin.services.datasync.model.TransferMode? = null
        /**
         * The POSIX user ID (UID) of the file's owner. This option should only be set for NFS, EFS, and S3 locations. To learn more about what metadata is copied by DataSync, see [Metadata Copied by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied).
         *
         * Default value: INT_VALUE. This preserves the integer value of the ID.
         *
         * INT_VALUE: Preserve the integer value of UID and group ID (GID) (recommended).
         *
         * NONE: Ignore UID and GID.
         */
        var uid: aws.sdk.kotlin.services.datasync.model.Uid? = null
        /**
         * A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. For more information, see [Configure task settings](https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html).
         *
         * Default value: POINT_IN_TIME_CONSISTENT.
         *
         * ONLY_FILES_TRANSFERRED (recommended): Perform verification only on files that were transferred.
         *
         * POINT_IN_TIME_CONSISTENT: Scan the entire source and entire destination at the end of the transfer to verify that source and destination are fully synchronized. This option isn't supported when transferring to S3 Glacier Flexible Retrieval or S3 Glacier Deep Archive storage classes.
         *
         * NONE: No additional verification is done at the end of the transfer, but all data transmissions are integrity-checked with checksum verification during the transfer.
         */
        var verifyMode: aws.sdk.kotlin.services.datasync.model.VerifyMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.Options) : this() {
            this.atime = x.atime
            this.bytesPerSecond = x.bytesPerSecond
            this.gid = x.gid
            this.logLevel = x.logLevel
            this.mtime = x.mtime
            this.objectTags = x.objectTags
            this.overwriteMode = x.overwriteMode
            this.posixPermissions = x.posixPermissions
            this.preserveDeletedFiles = x.preserveDeletedFiles
            this.preserveDevices = x.preserveDevices
            this.securityDescriptorCopyFlags = x.securityDescriptorCopyFlags
            this.taskQueueing = x.taskQueueing
            this.transferMode = x.transferMode
            this.uid = x.uid
            this.verifyMode = x.verifyMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.Options = Options(this)
    }
}
