// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * Describes the detailed result of a `TaskExecution` operation. This result includes the time in milliseconds spent in each phase, the status of the task execution, and the errors encountered.
 */
class TaskExecutionResultDetail private constructor(builder: Builder) {
    /**
     * Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.
     */
    val errorCode: kotlin.String? = builder.errorCode
    /**
     * Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues.
     */
    val errorDetail: kotlin.String? = builder.errorDetail
    /**
     * The total time in milliseconds that DataSync spent in the PREPARING phase.
     */
    val prepareDuration: kotlin.Long? = builder.prepareDuration
    /**
     * The status of the PREPARING phase.
     */
    val prepareStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = builder.prepareStatus
    /**
     * The total time in milliseconds that DataSync took to transfer the file from the source to the destination location.
     */
    val totalDuration: kotlin.Long? = builder.totalDuration
    /**
     * The total time in milliseconds that DataSync spent in the TRANSFERRING phase.
     */
    val transferDuration: kotlin.Long? = builder.transferDuration
    /**
     * The status of the TRANSFERRING phase.
     */
    val transferStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = builder.transferStatus
    /**
     * The total time in milliseconds that DataSync spent in the VERIFYING phase.
     */
    val verifyDuration: kotlin.Long? = builder.verifyDuration
    /**
     * The status of the VERIFYING phase.
     */
    val verifyStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = builder.verifyStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskExecutionResultDetail(")
        append("errorCode=$errorCode,")
        append("errorDetail=$errorDetail,")
        append("prepareDuration=$prepareDuration,")
        append("prepareStatus=$prepareStatus,")
        append("totalDuration=$totalDuration,")
        append("transferDuration=$transferDuration,")
        append("transferStatus=$transferStatus,")
        append("verifyDuration=$verifyDuration,")
        append("verifyStatus=$verifyStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (errorDetail?.hashCode() ?: 0)
        result = 31 * result + (prepareDuration?.hashCode() ?: 0)
        result = 31 * result + (prepareStatus?.hashCode() ?: 0)
        result = 31 * result + (totalDuration?.hashCode() ?: 0)
        result = 31 * result + (transferDuration?.hashCode() ?: 0)
        result = 31 * result + (transferStatus?.hashCode() ?: 0)
        result = 31 * result + (verifyDuration?.hashCode() ?: 0)
        result = 31 * result + (verifyStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskExecutionResultDetail

        if (errorCode != other.errorCode) return false
        if (errorDetail != other.errorDetail) return false
        if (prepareDuration != other.prepareDuration) return false
        if (prepareStatus != other.prepareStatus) return false
        if (totalDuration != other.totalDuration) return false
        if (transferDuration != other.transferDuration) return false
        if (transferStatus != other.transferStatus) return false
        if (verifyDuration != other.verifyDuration) return false
        if (verifyStatus != other.verifyStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.
         */
        var errorCode: kotlin.String? = null
        /**
         * Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues.
         */
        var errorDetail: kotlin.String? = null
        /**
         * The total time in milliseconds that DataSync spent in the PREPARING phase.
         */
        var prepareDuration: kotlin.Long? = null
        /**
         * The status of the PREPARING phase.
         */
        var prepareStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = null
        /**
         * The total time in milliseconds that DataSync took to transfer the file from the source to the destination location.
         */
        var totalDuration: kotlin.Long? = null
        /**
         * The total time in milliseconds that DataSync spent in the TRANSFERRING phase.
         */
        var transferDuration: kotlin.Long? = null
        /**
         * The status of the TRANSFERRING phase.
         */
        var transferStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = null
        /**
         * The total time in milliseconds that DataSync spent in the VERIFYING phase.
         */
        var verifyDuration: kotlin.Long? = null
        /**
         * The status of the VERIFYING phase.
         */
        var verifyStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail) : this() {
            this.errorCode = x.errorCode
            this.errorDetail = x.errorDetail
            this.prepareDuration = x.prepareDuration
            this.prepareStatus = x.prepareStatus
            this.totalDuration = x.totalDuration
            this.transferDuration = x.transferDuration
            this.transferStatus = x.transferStatus
            this.verifyDuration = x.verifyDuration
            this.verifyStatus = x.verifyStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail = TaskExecutionResultDetail(this)
    }
}
