// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



class UpdateTaskExecutionRequest private constructor(builder: Builder) {
    /**
     * Represents the options that are available to control the behavior of a [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.
     *
     * A task has a set of default options associated with it. If you don't specify an option in [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html), the default value is used. You can override the defaults options on each task execution by specifying an overriding `Options` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
     */
    val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * The Amazon Resource Name (ARN) of the specific task execution that is being updated.
     */
    val taskExecutionArn: kotlin.String? = builder.taskExecutionArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.UpdateTaskExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTaskExecutionRequest(")
        append("options=$options,")
        append("taskExecutionArn=$taskExecutionArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = options?.hashCode() ?: 0
        result = 31 * result + (taskExecutionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTaskExecutionRequest

        if (options != other.options) return false
        if (taskExecutionArn != other.taskExecutionArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.UpdateTaskExecutionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Represents the options that are available to control the behavior of a [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.
         *
         * A task has a set of default options associated with it. If you don't specify an option in [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html), the default value is used. You can override the defaults options on each task execution by specifying an overriding `Options` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
         */
        var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * The Amazon Resource Name (ARN) of the specific task execution that is being updated.
         */
        var taskExecutionArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.UpdateTaskExecutionRequest) : this() {
            this.options = x.options
            this.taskExecutionArn = x.taskExecutionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.UpdateTaskExecutionRequest = UpdateTaskExecutionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }
    }
}
