// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.paginators

import aws.sdk.kotlin.services.datasync.DataSyncClient
import aws.sdk.kotlin.services.datasync.model.AgentListEntry
import aws.sdk.kotlin.services.datasync.model.ListAgentsRequest
import aws.sdk.kotlin.services.datasync.model.ListAgentsResponse
import aws.sdk.kotlin.services.datasync.model.ListLocationsRequest
import aws.sdk.kotlin.services.datasync.model.ListLocationsResponse
import aws.sdk.kotlin.services.datasync.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.datasync.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.datasync.model.ListTaskExecutionsRequest
import aws.sdk.kotlin.services.datasync.model.ListTaskExecutionsResponse
import aws.sdk.kotlin.services.datasync.model.ListTasksRequest
import aws.sdk.kotlin.services.datasync.model.ListTasksResponse
import aws.sdk.kotlin.services.datasync.model.LocationListEntry
import aws.sdk.kotlin.services.datasync.model.TagListEntry
import aws.sdk.kotlin.services.datasync.model.TaskExecutionListEntry
import aws.sdk.kotlin.services.datasync.model.TaskListEntry
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAgentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAgentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAgentsResponse]
 */
fun DataSyncClient.listAgentsPaginated(initialRequest: ListAgentsRequest): Flow<ListAgentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAgentsPaginated.listAgents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAgentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAgentsResponse]
 */
fun DataSyncClient.listAgentsPaginated(block: ListAgentsRequest.Builder.() -> Unit): Flow<ListAgentsResponse> =
    listAgentsPaginated(ListAgentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAgentsPaginated]
 * to access the nested member [AgentListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AgentListEntry]
 */
@JvmName("listAgentsResponseAgentListEntry")
fun Flow<ListAgentsResponse>.agents(): Flow<AgentListEntry> =
    transform() { response ->
        response.agents?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLocationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLocationsResponse]
 */
fun DataSyncClient.listLocationsPaginated(initialRequest: ListLocationsRequest): Flow<ListLocationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLocationsPaginated.listLocations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLocationsResponse]
 */
fun DataSyncClient.listLocationsPaginated(block: ListLocationsRequest.Builder.() -> Unit): Flow<ListLocationsResponse> =
    listLocationsPaginated(ListLocationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLocationsPaginated]
 * to access the nested member [LocationListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LocationListEntry]
 */
@JvmName("listLocationsResponseLocationListEntry")
fun Flow<ListLocationsResponse>.locations(): Flow<LocationListEntry> =
    transform() { response ->
        response.locations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun DataSyncClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun DataSyncClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [TagListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TagListEntry]
 */
@JvmName("listTagsForResourceResponseTagListEntry")
fun Flow<ListTagsForResourceResponse>.tags(): Flow<TagListEntry> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTaskExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTaskExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaskExecutionsResponse]
 */
fun DataSyncClient.listTaskExecutionsPaginated(initialRequest: ListTaskExecutionsRequest): Flow<ListTaskExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTaskExecutionsPaginated.listTaskExecutions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTaskExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaskExecutionsResponse]
 */
fun DataSyncClient.listTaskExecutionsPaginated(block: ListTaskExecutionsRequest.Builder.() -> Unit): Flow<ListTaskExecutionsResponse> =
    listTaskExecutionsPaginated(ListTaskExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTaskExecutionsPaginated]
 * to access the nested member [TaskExecutionListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TaskExecutionListEntry]
 */
@JvmName("listTaskExecutionsResponseTaskExecutionListEntry")
fun Flow<ListTaskExecutionsResponse>.taskExecutions(): Flow<TaskExecutionListEntry> =
    transform() { response ->
        response.taskExecutions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTasksResponse]
 */
fun DataSyncClient.listTasksPaginated(initialRequest: ListTasksRequest): Flow<ListTasksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTasksPaginated.listTasks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTasksResponse]
 */
fun DataSyncClient.listTasksPaginated(block: ListTasksRequest.Builder.() -> Unit): Flow<ListTasksResponse> =
    listTasksPaginated(ListTasksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTasksPaginated]
 * to access the nested member [TaskListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TaskListEntry]
 */
@JvmName("listTasksResponseTaskListEntry")
fun Flow<ListTasksResponse>.tasks(): Flow<TaskListEntry> =
    transform() { response ->
        response.tasks?.forEach {
            emit(it)
        }
    }
