// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.FilterRule
import aws.sdk.kotlin.services.datasync.model.Options
import aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail
import aws.sdk.kotlin.services.datasync.model.TaskExecutionStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeTaskExecutionOperationDeserializer: HttpDeserialize<DescribeTaskExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeTaskExecutionResponse {
        if (!response.status.isSuccess()) {
            throwDescribeTaskExecutionError(context, response)
        }
        val builder = DescribeTaskExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTaskExecutionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeTaskExecutionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTaskExecutionOperationBody(builder: DescribeTaskExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BYTESTRANSFERRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BytesTransferred"))
    val BYTESWRITTEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BytesWritten"))
    val ESTIMATEDBYTESTOTRANSFER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedBytesToTransfer"))
    val ESTIMATEDFILESTOTRANSFER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedFilesToTransfer"))
    val EXCLUDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Excludes"))
    val FILESTRANSFERRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FilesTransferred"))
    val INCLUDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Includes"))
    val OPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Options"))
    val RESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Result"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TASKEXECUTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TaskExecutionArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BYTESTRANSFERRED_DESCRIPTOR)
        field(BYTESWRITTEN_DESCRIPTOR)
        field(ESTIMATEDBYTESTOTRANSFER_DESCRIPTOR)
        field(ESTIMATEDFILESTOTRANSFER_DESCRIPTOR)
        field(EXCLUDES_DESCRIPTOR)
        field(FILESTRANSFERRED_DESCRIPTOR)
        field(INCLUDES_DESCRIPTOR)
        field(OPTIONS_DESCRIPTOR)
        field(RESULT_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TASKEXECUTIONARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BYTESTRANSFERRED_DESCRIPTOR.index -> builder.bytesTransferred = deserializeLong()
                BYTESWRITTEN_DESCRIPTOR.index -> builder.bytesWritten = deserializeLong()
                ESTIMATEDBYTESTOTRANSFER_DESCRIPTOR.index -> builder.estimatedBytesToTransfer = deserializeLong()
                ESTIMATEDFILESTOTRANSFER_DESCRIPTOR.index -> builder.estimatedFilesToTransfer = deserializeLong()
                EXCLUDES_DESCRIPTOR.index -> builder.excludes =
                    deserializer.deserializeList(EXCLUDES_DESCRIPTOR) {
                        val col0 = mutableListOf<FilterRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFilterRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FILESTRANSFERRED_DESCRIPTOR.index -> builder.filesTransferred = deserializeLong()
                INCLUDES_DESCRIPTOR.index -> builder.includes =
                    deserializer.deserializeList(INCLUDES_DESCRIPTOR) {
                        val col0 = mutableListOf<FilterRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFilterRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OPTIONS_DESCRIPTOR.index -> builder.options = deserializeOptionsDocument(deserializer)
                RESULT_DESCRIPTOR.index -> builder.result = deserializeTaskExecutionResultDetailDocument(deserializer)
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TaskExecutionStatus.fromValue(it) }
                TASKEXECUTIONARN_DESCRIPTOR.index -> builder.taskExecutionArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
