// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.datasync.model.*
import aws.sdk.kotlin.services.datasync.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "DataSync"
const val ServiceApiVersion: String = "2018-11-09"
const val SdkVersion: String = "0.16.7-beta"

internal class DefaultDataSyncClient(override val config: DataSyncClient.Config) : DataSyncClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Cancels execution of a task.
     *
     * When you cancel a task execution, the transfer of some files is abruptly interrupted. The contents of files that are transferred to the destination might be incomplete or inconsistent with the source files. However, if you start a new task execution on the same task and you allow the task execution to complete, file content on the destination is complete and consistent. This applies to other unexpected failures that interrupt a task execution. In all of these cases, DataSync successfully complete the transfer when you start the next task execution.
     */
    override suspend fun cancelTaskExecution(input: CancelTaskExecutionRequest): CancelTaskExecutionResponse {
        val op = SdkHttpOperation.build<CancelTaskExecutionRequest, CancelTaskExecutionResponse> {
            serializer = CancelTaskExecutionOperationSerializer()
            deserializer = CancelTaskExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelTaskExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Activates an DataSync agent that you have deployed on your host. The activation process associates your agent with your account. In the activation process, you specify information such as the Amazon Web Services Region that you want to activate the agent in. You activate the agent in the Amazon Web Services Region where your target locations (in Amazon S3 or Amazon EFS) reside. Your tasks are created in this Amazon Web Services Region.
     *
     * You can activate the agent in a VPC (virtual private cloud) or provide the agent access to a VPC endpoint so you can run tasks without going over the public internet.
     *
     * You can use an agent for more than one location. If a task uses multiple agents, all of them need to have status AVAILABLE for the task to run. If you use multiple agents for a source location, the status of all the agents must be AVAILABLE for the task to run.
     *
     * Agents are automatically updated by Amazon Web Services on a regular basis, using a mechanism that ensures minimal interruption to your tasks.
     */
    override suspend fun createAgent(input: CreateAgentRequest): CreateAgentResponse {
        val op = SdkHttpOperation.build<CreateAgentRequest, CreateAgentResponse> {
            serializer = CreateAgentOperationSerializer()
            deserializer = CreateAgentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAgent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint for an Amazon EFS file system that DataSync can access for a transfer. For more information, see [Creating a location for Amazon EFS](https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html).
     */
    override suspend fun createLocationEfs(input: CreateLocationEfsRequest): CreateLocationEfsResponse {
        val op = SdkHttpOperation.build<CreateLocationEfsRequest, CreateLocationEfsResponse> {
            serializer = CreateLocationEfsOperationSerializer()
            deserializer = CreateLocationEfsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocationEfs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint for an Amazon FSx for Lustre file system.
     */
    override suspend fun createLocationFsxLustre(input: CreateLocationFsxLustreRequest): CreateLocationFsxLustreResponse {
        val op = SdkHttpOperation.build<CreateLocationFsxLustreRequest, CreateLocationFsxLustreResponse> {
            serializer = CreateLocationFsxLustreOperationSerializer()
            deserializer = CreateLocationFsxLustreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocationFsxLustre"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint for an Amazon FSx for NetApp ONTAP file system that DataSync can access for a transfer. For more information, see [Creating a location for FSx for ONTAP](https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html).
     */
    override suspend fun createLocationFsxOntap(input: CreateLocationFsxOntapRequest): CreateLocationFsxOntapResponse {
        val op = SdkHttpOperation.build<CreateLocationFsxOntapRequest, CreateLocationFsxOntapResponse> {
            serializer = CreateLocationFsxOntapOperationSerializer()
            deserializer = CreateLocationFsxOntapOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocationFsxOntap"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint for an Amazon FSx for OpenZFS file system.
     */
    override suspend fun createLocationFsxOpenZfs(input: CreateLocationFsxOpenZfsRequest): CreateLocationFsxOpenZfsResponse {
        val op = SdkHttpOperation.build<CreateLocationFsxOpenZfsRequest, CreateLocationFsxOpenZfsResponse> {
            serializer = CreateLocationFsxOpenZfsOperationSerializer()
            deserializer = CreateLocationFsxOpenZfsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocationFsxOpenZfs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint for an Amazon FSx for Windows File Server file system.
     */
    override suspend fun createLocationFsxWindows(input: CreateLocationFsxWindowsRequest): CreateLocationFsxWindowsResponse {
        val op = SdkHttpOperation.build<CreateLocationFsxWindowsRequest, CreateLocationFsxWindowsResponse> {
            serializer = CreateLocationFsxWindowsOperationSerializer()
            deserializer = CreateLocationFsxWindowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocationFsxWindows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint for a Hadoop Distributed File System (HDFS).
     */
    override suspend fun createLocationHdfs(input: CreateLocationHdfsRequest): CreateLocationHdfsResponse {
        val op = SdkHttpOperation.build<CreateLocationHdfsRequest, CreateLocationHdfsResponse> {
            serializer = CreateLocationHdfsOperationSerializer()
            deserializer = CreateLocationHdfsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocationHdfs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Defines a file system on a Network File System (NFS) server that can be read from or written to.
     */
    override suspend fun createLocationNfs(input: CreateLocationNfsRequest): CreateLocationNfsResponse {
        val op = SdkHttpOperation.build<CreateLocationNfsRequest, CreateLocationNfsResponse> {
            serializer = CreateLocationNfsOperationSerializer()
            deserializer = CreateLocationNfsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocationNfs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint for an object storage system that DataSync can access for a transfer. For more information, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
     */
    override suspend fun createLocationObjectStorage(input: CreateLocationObjectStorageRequest): CreateLocationObjectStorageResponse {
        val op = SdkHttpOperation.build<CreateLocationObjectStorageRequest, CreateLocationObjectStorageResponse> {
            serializer = CreateLocationObjectStorageOperationSerializer()
            deserializer = CreateLocationObjectStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocationObjectStorage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint for an Amazon S3 bucket.
     *
     * For more information, see [Create an Amazon S3 location](https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli) in the *DataSync User Guide*.
     */
    override suspend fun createLocationS3(input: CreateLocationS3Request): CreateLocationS3Response {
        val op = SdkHttpOperation.build<CreateLocationS3Request, CreateLocationS3Response> {
            serializer = CreateLocationS3OperationSerializer()
            deserializer = CreateLocationS3OperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocationS3"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Defines a file system on a Server Message Block (SMB) server that can be read from or written to.
     */
    override suspend fun createLocationSmb(input: CreateLocationSmbRequest): CreateLocationSmbResponse {
        val op = SdkHttpOperation.build<CreateLocationSmbRequest, CreateLocationSmbResponse> {
            serializer = CreateLocationSmbOperationSerializer()
            deserializer = CreateLocationSmbOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocationSmb"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a task.
     *
     * A task includes a source location and a destination location, and a configuration that specifies how data is transferred. A task always transfers data from the source location to the destination location. The configuration specifies options such as task scheduling, bandwidth limits, etc. A task is the complete definition of a data transfer.
     *
     * When you create a task that transfers data between Amazon Web Services services in different Amazon Web Services Regions, one of the two locations that you specify must reside in the Region where DataSync is being used. The other location must be specified in a different Region.
     *
     * You can transfer data between commercial Amazon Web Services Regions except for China, or between Amazon Web Services GovCloud (US) Regions.
     *
     * When you use DataSync to copy files or objects between Amazon Web Services Regions, you pay for data transfer between Regions. This is billed as data transfer OUT from your source Region to your destination Region. For more information, see [Data Transfer pricing](http://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer).
     */
    override suspend fun createTask(input: CreateTaskRequest): CreateTaskResponse {
        val op = SdkHttpOperation.build<CreateTaskRequest, CreateTaskResponse> {
            serializer = CreateTaskOperationSerializer()
            deserializer = CreateTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an agent. To specify which agent to delete, use the Amazon Resource Name (ARN) of the agent in your request. The operation disassociates the agent from your Amazon Web Services account. However, it doesn't delete the agent virtual machine (VM) from your on-premises environment.
     */
    override suspend fun deleteAgent(input: DeleteAgentRequest): DeleteAgentResponse {
        val op = SdkHttpOperation.build<DeleteAgentRequest, DeleteAgentResponse> {
            serializer = DeleteAgentOperationSerializer()
            deserializer = DeleteAgentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAgent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the configuration of a location used by DataSync.
     */
    override suspend fun deleteLocation(input: DeleteLocationRequest): DeleteLocationResponse {
        val op = SdkHttpOperation.build<DeleteLocationRequest, DeleteLocationResponse> {
            serializer = DeleteLocationOperationSerializer()
            deserializer = DeleteLocationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLocation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a task.
     */
    override suspend fun deleteTask(input: DeleteTaskRequest): DeleteTaskResponse {
        val op = SdkHttpOperation.build<DeleteTaskRequest, DeleteTaskResponse> {
            serializer = DeleteTaskOperationSerializer()
            deserializer = DeleteTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata such as the name, the network interfaces, and the status (that is, whether the agent is running or not) for an agent. To specify which agent to describe, use the Amazon Resource Name (ARN) of the agent in your request.
     */
    override suspend fun describeAgent(input: DescribeAgentRequest): DescribeAgentResponse {
        val op = SdkHttpOperation.build<DescribeAgentRequest, DescribeAgentResponse> {
            serializer = DescribeAgentOperationSerializer()
            deserializer = DescribeAgentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAgent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about your DataSync location for an Amazon EFS file system.
     */
    override suspend fun describeLocationEfs(input: DescribeLocationEfsRequest): DescribeLocationEfsResponse {
        val op = SdkHttpOperation.build<DescribeLocationEfsRequest, DescribeLocationEfsResponse> {
            serializer = DescribeLocationEfsOperationSerializer()
            deserializer = DescribeLocationEfsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocationEfs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about an Amazon FSx for Lustre location, such as information about its path.
     */
    override suspend fun describeLocationFsxLustre(input: DescribeLocationFsxLustreRequest): DescribeLocationFsxLustreResponse {
        val op = SdkHttpOperation.build<DescribeLocationFsxLustreRequest, DescribeLocationFsxLustreResponse> {
            serializer = DescribeLocationFsxLustreOperationSerializer()
            deserializer = DescribeLocationFsxLustreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocationFsxLustre"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides details about how an DataSync location for an Amazon FSx for NetApp ONTAP file system is configured.
     */
    override suspend fun describeLocationFsxOntap(input: DescribeLocationFsxOntapRequest): DescribeLocationFsxOntapResponse {
        val op = SdkHttpOperation.build<DescribeLocationFsxOntapRequest, DescribeLocationFsxOntapResponse> {
            serializer = DescribeLocationFsxOntapOperationSerializer()
            deserializer = DescribeLocationFsxOntapOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocationFsxOntap"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about an Amazon FSx for OpenZFS location, such as information about its path.
     */
    override suspend fun describeLocationFsxOpenZfs(input: DescribeLocationFsxOpenZfsRequest): DescribeLocationFsxOpenZfsResponse {
        val op = SdkHttpOperation.build<DescribeLocationFsxOpenZfsRequest, DescribeLocationFsxOpenZfsResponse> {
            serializer = DescribeLocationFsxOpenZfsOperationSerializer()
            deserializer = DescribeLocationFsxOpenZfsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocationFsxOpenZfs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about an Amazon FSx for Windows File Server location, such as information about its path.
     */
    override suspend fun describeLocationFsxWindows(input: DescribeLocationFsxWindowsRequest): DescribeLocationFsxWindowsResponse {
        val op = SdkHttpOperation.build<DescribeLocationFsxWindowsRequest, DescribeLocationFsxWindowsResponse> {
            serializer = DescribeLocationFsxWindowsOperationSerializer()
            deserializer = DescribeLocationFsxWindowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocationFsxWindows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata, such as the authentication information about the Hadoop Distributed File System (HDFS) location.
     */
    override suspend fun describeLocationHdfs(input: DescribeLocationHdfsRequest): DescribeLocationHdfsResponse {
        val op = SdkHttpOperation.build<DescribeLocationHdfsRequest, DescribeLocationHdfsResponse> {
            serializer = DescribeLocationHdfsOperationSerializer()
            deserializer = DescribeLocationHdfsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocationHdfs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata, such as the path information, about an NFS location.
     */
    override suspend fun describeLocationNfs(input: DescribeLocationNfsRequest): DescribeLocationNfsResponse {
        val op = SdkHttpOperation.build<DescribeLocationNfsRequest, DescribeLocationNfsResponse> {
            serializer = DescribeLocationNfsOperationSerializer()
            deserializer = DescribeLocationNfsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocationNfs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about your DataSync location for an object storage system.
     */
    override suspend fun describeLocationObjectStorage(input: DescribeLocationObjectStorageRequest): DescribeLocationObjectStorageResponse {
        val op = SdkHttpOperation.build<DescribeLocationObjectStorageRequest, DescribeLocationObjectStorageResponse> {
            serializer = DescribeLocationObjectStorageOperationSerializer()
            deserializer = DescribeLocationObjectStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocationObjectStorage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata, such as bucket name, about an Amazon S3 bucket location.
     */
    override suspend fun describeLocationS3(input: DescribeLocationS3Request): DescribeLocationS3Response {
        val op = SdkHttpOperation.build<DescribeLocationS3Request, DescribeLocationS3Response> {
            serializer = DescribeLocationS3OperationSerializer()
            deserializer = DescribeLocationS3OperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocationS3"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata, such as the path and user information about an SMB location.
     */
    override suspend fun describeLocationSmb(input: DescribeLocationSmbRequest): DescribeLocationSmbResponse {
        val op = SdkHttpOperation.build<DescribeLocationSmbRequest, DescribeLocationSmbResponse> {
            serializer = DescribeLocationSmbOperationSerializer()
            deserializer = DescribeLocationSmbOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocationSmb"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about a task.
     */
    override suspend fun describeTask(input: DescribeTaskRequest): DescribeTaskResponse {
        val op = SdkHttpOperation.build<DescribeTaskRequest, DescribeTaskResponse> {
            serializer = DescribeTaskOperationSerializer()
            deserializer = DescribeTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed metadata about a task that is being executed.
     */
    override suspend fun describeTaskExecution(input: DescribeTaskExecutionRequest): DescribeTaskExecutionResponse {
        val op = SdkHttpOperation.build<DescribeTaskExecutionRequest, DescribeTaskExecutionResponse> {
            serializer = DescribeTaskExecutionOperationSerializer()
            deserializer = DescribeTaskExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTaskExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of agents owned by an Amazon Web Services account in the Amazon Web Services Region specified in the request. The returned list is ordered by agent Amazon Resource Name (ARN).
     *
     * By default, this operation returns a maximum of 100 agents. This operation supports pagination that enables you to optionally reduce the number of agents returned in a response.
     *
     * If you have more agents than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a marker that you can specify in your next request to fetch the next page of agents.
     */
    override suspend fun listAgents(input: ListAgentsRequest): ListAgentsResponse {
        val op = SdkHttpOperation.build<ListAgentsRequest, ListAgentsResponse> {
            serializer = ListAgentsOperationSerializer()
            deserializer = ListAgentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAgents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of source and destination locations.
     *
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a token that you can specify in your next request to fetch the next page of locations.
     */
    override suspend fun listLocations(input: ListLocationsRequest): ListLocationsResponse {
        val op = SdkHttpOperation.build<ListLocationsRequest, ListLocationsResponse> {
            serializer = ListLocationsOperationSerializer()
            deserializer = ListLocationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLocations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns all the tags associated with a specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of executed tasks.
     */
    override suspend fun listTaskExecutions(input: ListTaskExecutionsRequest): ListTaskExecutionsResponse {
        val op = SdkHttpOperation.build<ListTaskExecutionsRequest, ListTaskExecutionsResponse> {
            serializer = ListTaskExecutionsOperationSerializer()
            deserializer = ListTaskExecutionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTaskExecutions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all the tasks.
     */
    override suspend fun listTasks(input: ListTasksRequest): ListTasksResponse {
        val op = SdkHttpOperation.build<ListTasksRequest, ListTasksResponse> {
            serializer = ListTasksOperationSerializer()
            deserializer = ListTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a specific invocation of a task. A `TaskExecution` value represents an individual run of a task. Each task can have at most one `TaskExecution` at a time.
     *
     * `TaskExecution` has the following transition phases: INITIALIZING | PREPARING | TRANSFERRING | VERIFYING | SUCCESS/FAILURE.
     *
     * For detailed information, see the Task Execution section in the Components and Terminology topic in the *DataSync User Guide*.
     */
    override suspend fun startTaskExecution(input: StartTaskExecutionRequest): StartTaskExecutionResponse {
        val op = SdkHttpOperation.build<StartTaskExecutionRequest, StartTaskExecutionResponse> {
            serializer = StartTaskExecutionOperationSerializer()
            deserializer = StartTaskExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartTaskExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies a key-value pair to an Amazon Web Services resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from an Amazon Web Services resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name of an agent.
     */
    override suspend fun updateAgent(input: UpdateAgentRequest): UpdateAgentResponse {
        val op = SdkHttpOperation.build<UpdateAgentRequest, UpdateAgentResponse> {
            serializer = UpdateAgentOperationSerializer()
            deserializer = UpdateAgentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAgent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.
     */
    override suspend fun updateLocationHdfs(input: UpdateLocationHdfsRequest): UpdateLocationHdfsResponse {
        val op = SdkHttpOperation.build<UpdateLocationHdfsRequest, UpdateLocationHdfsResponse> {
            serializer = UpdateLocationHdfsOperationSerializer()
            deserializer = UpdateLocationHdfsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLocationHdfs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates some of the parameters of a previously created location for Network File System (NFS) access. For information about creating an NFS location, see [Creating a location for NFS](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html).
     */
    override suspend fun updateLocationNfs(input: UpdateLocationNfsRequest): UpdateLocationNfsResponse {
        val op = SdkHttpOperation.build<UpdateLocationNfsRequest, UpdateLocationNfsResponse> {
            serializer = UpdateLocationNfsOperationSerializer()
            deserializer = UpdateLocationNfsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLocationNfs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates some of the parameters of a previously created location for self-managed object storage server access. For information about creating a self-managed object storage location, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
     */
    override suspend fun updateLocationObjectStorage(input: UpdateLocationObjectStorageRequest): UpdateLocationObjectStorageResponse {
        val op = SdkHttpOperation.build<UpdateLocationObjectStorageRequest, UpdateLocationObjectStorageResponse> {
            serializer = UpdateLocationObjectStorageOperationSerializer()
            deserializer = UpdateLocationObjectStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLocationObjectStorage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates some of the parameters of a previously created location for Server Message Block (SMB) file system access. For information about creating an SMB location, see [Creating a location for SMB](https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html).
     */
    override suspend fun updateLocationSmb(input: UpdateLocationSmbRequest): UpdateLocationSmbResponse {
        val op = SdkHttpOperation.build<UpdateLocationSmbRequest, UpdateLocationSmbResponse> {
            serializer = UpdateLocationSmbOperationSerializer()
            deserializer = UpdateLocationSmbOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLocationSmb"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the metadata associated with a task.
     */
    override suspend fun updateTask(input: UpdateTaskRequest): UpdateTaskResponse {
        val op = SdkHttpOperation.build<UpdateTaskRequest, UpdateTaskResponse> {
            serializer = UpdateTaskOperationSerializer()
            deserializer = UpdateTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates execution of a task.
     *
     * You can modify bandwidth throttling for a task execution that is running or queued. For more information, see [Adjusting Bandwidth Throttling for a Task Execution](https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#adjust-bandwidth-throttling).
     *
     * The only `Option` that can be modified by `UpdateTaskExecution` is ` <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> `.
     */
    override suspend fun updateTaskExecution(input: UpdateTaskExecutionRequest): UpdateTaskExecutionResponse {
        val op = SdkHttpOperation.build<UpdateTaskExecutionRequest, UpdateTaskExecutionResponse> {
            serializer = UpdateTaskExecutionOperationSerializer()
            deserializer = UpdateTaskExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTaskExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("FmrsService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "datasync"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "datasync")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
