// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



class CreateLocationFsxOntapRequest private constructor(builder: Builder) {
    /**
     * Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
     */
    val protocol: aws.sdk.kotlin.services.datasync.model.FsxProtocol? = builder.protocol
    /**
     * Specifies the security groups that DataSync can use to access your FSx for ONTAP file system. You must configure the security groups to allow outbound traffic on the following ports (depending on the protocol that you're using):
     * + **Network File System (NFS)**: TCP port 2049
     * + **Server Message Block (SMB)**: TCP port 445
     *
     * Your file system's security groups must also allow inbound traffic on the same port.
     */
    val securityGroupArns: List<String>? = builder.securityGroupArns
    /**
     * Specifies the ARN of the storage virtual machine (SVM) on your file system where you're copying data to or from.
     */
    val storageVirtualMachineArn: kotlin.String? = builder.storageVirtualMachineArn
    /**
     * Specifies the junction path (also known as a mount point) in the SVM volume where you're copying data to or from (for example, `/vol1`).
     *
     * Don't specify a junction path in the SVM's root volume. For more information, see [Managing FSx for ONTAP storage virtual machines](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html) in the *Amazon FSx for NetApp ONTAP User Guide*.
     */
    val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.
     */
    val tags: List<TagListEntry>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationFsxOntapRequest(")
        append("protocol=$protocol,")
        append("securityGroupArns=$securityGroupArns,")
        append("storageVirtualMachineArn=$storageVirtualMachineArn,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = protocol?.hashCode() ?: 0
        result = 31 * result + (securityGroupArns?.hashCode() ?: 0)
        result = 31 * result + (storageVirtualMachineArn?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationFsxOntapRequest

        if (protocol != other.protocol) return false
        if (securityGroupArns != other.securityGroupArns) return false
        if (storageVirtualMachineArn != other.storageVirtualMachineArn) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
         */
        var protocol: aws.sdk.kotlin.services.datasync.model.FsxProtocol? = null
        /**
         * Specifies the security groups that DataSync can use to access your FSx for ONTAP file system. You must configure the security groups to allow outbound traffic on the following ports (depending on the protocol that you're using):
         * + **Network File System (NFS)**: TCP port 2049
         * + **Server Message Block (SMB)**: TCP port 445
         *
         * Your file system's security groups must also allow inbound traffic on the same port.
         */
        var securityGroupArns: List<String>? = null
        /**
         * Specifies the ARN of the storage virtual machine (SVM) on your file system where you're copying data to or from.
         */
        var storageVirtualMachineArn: kotlin.String? = null
        /**
         * Specifies the junction path (also known as a mount point) in the SVM volume where you're copying data to or from (for example, `/vol1`).
         *
         * Don't specify a junction path in the SVM's root volume. For more information, see [Managing FSx for ONTAP storage virtual machines](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html) in the *Amazon FSx for NetApp ONTAP User Guide*.
         */
        var subdirectory: kotlin.String? = null
        /**
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.
         */
        var tags: List<TagListEntry>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapRequest) : this() {
            this.protocol = x.protocol
            this.securityGroupArns = x.securityGroupArns
            this.storageVirtualMachineArn = x.storageVirtualMachineArn
            this.subdirectory = x.subdirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapRequest = CreateLocationFsxOntapRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.FsxProtocol] inside the given [block]
         */
        fun protocol(block: aws.sdk.kotlin.services.datasync.model.FsxProtocol.Builder.() -> kotlin.Unit) {
            this.protocol = aws.sdk.kotlin.services.datasync.model.FsxProtocol.invoke(block)
        }
    }
}
