// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * CreateLocationObjectStorageRequest
 */
class CreateLocationObjectStorageRequest private constructor(builder: Builder) {
    /**
     * Specifies the access key (for example, a user name) if credentials are required to authenticate with the object storage server.
     */
    val accessKey: kotlin.String? = builder.accessKey
    /**
     * Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can securely connect with your location.
     */
    val agentArns: List<String>? = builder.agentArns
    /**
     * Specifies the name of the object storage bucket involved in the transfer.
     */
    val bucketName: kotlin.String? = builder.bucketName
    /**
     * Specifies the secret key (for example, a password) if credentials are required to authenticate with the object storage server.
     */
    val secretKey: kotlin.String? = builder.secretKey
    /**
     * Specifies the domain name or IP address of the object storage server. A DataSync agent uses this hostname to mount the object storage server in a network.
     */
    val serverHostname: kotlin.String? = builder.serverHostname
    /**
     * Specifies the port that your object storage server accepts inbound network traffic on (for example, port 443).
     */
    val serverPort: kotlin.Int? = builder.serverPort
    /**
     * Specifies the protocol that your object storage server uses to communicate.
     */
    val serverProtocol: aws.sdk.kotlin.services.datasync.model.ObjectStorageServerProtocol? = builder.serverProtocol
    /**
     * Specifies the object prefix for your object storage server. If this is a source location, DataSync only copies objects with this prefix. If this is a destination location, DataSync writes all objects with this prefix.
     */
    val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * Specifies the key-value pair that represents a tag that you want to add to the resource. Tags can help you manage, filter, and search for your resources. We recommend creating a name tag for your location.
     */
    val tags: List<TagListEntry>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationObjectStorageRequest(")
        append("accessKey=$accessKey,")
        append("agentArns=$agentArns,")
        append("bucketName=$bucketName,")
        append("secretKey=*** Sensitive Data Redacted ***,")
        append("serverHostname=$serverHostname,")
        append("serverPort=$serverPort,")
        append("serverProtocol=$serverProtocol,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKey?.hashCode() ?: 0
        result = 31 * result + (agentArns?.hashCode() ?: 0)
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (secretKey?.hashCode() ?: 0)
        result = 31 * result + (serverHostname?.hashCode() ?: 0)
        result = 31 * result + (serverPort ?: 0)
        result = 31 * result + (serverProtocol?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationObjectStorageRequest

        if (accessKey != other.accessKey) return false
        if (agentArns != other.agentArns) return false
        if (bucketName != other.bucketName) return false
        if (secretKey != other.secretKey) return false
        if (serverHostname != other.serverHostname) return false
        if (serverPort != other.serverPort) return false
        if (serverProtocol != other.serverProtocol) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the access key (for example, a user name) if credentials are required to authenticate with the object storage server.
         */
        var accessKey: kotlin.String? = null
        /**
         * Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can securely connect with your location.
         */
        var agentArns: List<String>? = null
        /**
         * Specifies the name of the object storage bucket involved in the transfer.
         */
        var bucketName: kotlin.String? = null
        /**
         * Specifies the secret key (for example, a password) if credentials are required to authenticate with the object storage server.
         */
        var secretKey: kotlin.String? = null
        /**
         * Specifies the domain name or IP address of the object storage server. A DataSync agent uses this hostname to mount the object storage server in a network.
         */
        var serverHostname: kotlin.String? = null
        /**
         * Specifies the port that your object storage server accepts inbound network traffic on (for example, port 443).
         */
        var serverPort: kotlin.Int? = null
        /**
         * Specifies the protocol that your object storage server uses to communicate.
         */
        var serverProtocol: aws.sdk.kotlin.services.datasync.model.ObjectStorageServerProtocol? = null
        /**
         * Specifies the object prefix for your object storage server. If this is a source location, DataSync only copies objects with this prefix. If this is a destination location, DataSync writes all objects with this prefix.
         */
        var subdirectory: kotlin.String? = null
        /**
         * Specifies the key-value pair that represents a tag that you want to add to the resource. Tags can help you manage, filter, and search for your resources. We recommend creating a name tag for your location.
         */
        var tags: List<TagListEntry>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageRequest) : this() {
            this.accessKey = x.accessKey
            this.agentArns = x.agentArns
            this.bucketName = x.bucketName
            this.secretKey = x.secretKey
            this.serverHostname = x.serverHostname
            this.serverPort = x.serverPort
            this.serverProtocol = x.serverProtocol
            this.subdirectory = x.subdirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageRequest = CreateLocationObjectStorageRequest(this)
    }
}
