// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * CreateLocationS3Request
 */
class CreateLocationS3Request private constructor(builder: Builder) {
    /**
     * If you're using DataSync on an Amazon Web Services Outpost, specify the Amazon Resource Names (ARNs) of the DataSync agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see [Deploy your DataSync agent on Outposts](https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent).
     */
    val agentArns: List<String>? = builder.agentArns
    /**
     * The ARN of the Amazon S3 bucket. If the bucket is on an Amazon Web Services Outpost, this must be an access point ARN.
     */
    val s3BucketArn: kotlin.String? = builder.s3BucketArn
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to access an Amazon S3 bucket.
     *
     * For detailed information about using such a role, see Creating a Location for Amazon S3 in the *DataSync User Guide*.
     */
    val s3Config: aws.sdk.kotlin.services.datasync.model.S3Config? = builder.s3Config
    /**
     * The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. For buckets in Amazon Web Services Regions, the storage class defaults to Standard. For buckets on Outposts, the storage class defaults to Amazon Web Services S3 Outposts.
     *
     * For more information about S3 storage classes, see [Amazon S3 Storage Classes](http://aws.amazon.com/s3/storage-classes/). Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see [Considerations when working with S3 storage classes in DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
     */
    val s3StorageClass: aws.sdk.kotlin.services.datasync.model.S3StorageClass? = builder.s3StorageClass
    /**
     * A subdirectory in the Amazon S3 bucket. This subdirectory in Amazon S3 is used to read data from the S3 source location or write data to the S3 destination.
     */
    val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.
     */
    val tags: List<TagListEntry>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationS3Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationS3Request(")
        append("agentArns=$agentArns,")
        append("s3BucketArn=$s3BucketArn,")
        append("s3Config=$s3Config,")
        append("s3StorageClass=$s3StorageClass,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArns?.hashCode() ?: 0
        result = 31 * result + (s3BucketArn?.hashCode() ?: 0)
        result = 31 * result + (s3Config?.hashCode() ?: 0)
        result = 31 * result + (s3StorageClass?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationS3Request

        if (agentArns != other.agentArns) return false
        if (s3BucketArn != other.s3BucketArn) return false
        if (s3Config != other.s3Config) return false
        if (s3StorageClass != other.s3StorageClass) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationS3Request = Builder(this).apply(block).build()

    class Builder {
        /**
         * If you're using DataSync on an Amazon Web Services Outpost, specify the Amazon Resource Names (ARNs) of the DataSync agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see [Deploy your DataSync agent on Outposts](https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent).
         */
        var agentArns: List<String>? = null
        /**
         * The ARN of the Amazon S3 bucket. If the bucket is on an Amazon Web Services Outpost, this must be an access point ARN.
         */
        var s3BucketArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to access an Amazon S3 bucket.
         *
         * For detailed information about using such a role, see Creating a Location for Amazon S3 in the *DataSync User Guide*.
         */
        var s3Config: aws.sdk.kotlin.services.datasync.model.S3Config? = null
        /**
         * The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. For buckets in Amazon Web Services Regions, the storage class defaults to Standard. For buckets on Outposts, the storage class defaults to Amazon Web Services S3 Outposts.
         *
         * For more information about S3 storage classes, see [Amazon S3 Storage Classes](http://aws.amazon.com/s3/storage-classes/). Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see [Considerations when working with S3 storage classes in DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
         */
        var s3StorageClass: aws.sdk.kotlin.services.datasync.model.S3StorageClass? = null
        /**
         * A subdirectory in the Amazon S3 bucket. This subdirectory in Amazon S3 is used to read data from the S3 source location or write data to the S3 destination.
         */
        var subdirectory: kotlin.String? = null
        /**
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.
         */
        var tags: List<TagListEntry>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationS3Request) : this() {
            this.agentArns = x.agentArns
            this.s3BucketArn = x.s3BucketArn
            this.s3Config = x.s3Config
            this.s3StorageClass = x.s3StorageClass
            this.subdirectory = x.subdirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationS3Request = CreateLocationS3Request(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.S3Config] inside the given [block]
         */
        fun s3Config(block: aws.sdk.kotlin.services.datasync.model.S3Config.Builder.() -> kotlin.Unit) {
            this.s3Config = aws.sdk.kotlin.services.datasync.model.S3Config.invoke(block)
        }
    }
}
