// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * DescribeLocationSmbResponse
 */
class DescribeLocationSmbResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the source SMB file system location that is created.
     */
    val agentArns: List<String>? = builder.agentArns
    /**
     * The time that the SMB location was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the Windows domain that the SMB server belongs to.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * The Amazon Resource Name (ARN) of the SMB location that was described.
     */
    val locationArn: kotlin.String? = builder.locationArn
    /**
     * The URL of the source SMB location that was described.
     */
    val locationUri: kotlin.String? = builder.locationUri
    /**
     * The mount options that are available for DataSync to use to access an SMB location.
     */
    val mountOptions: aws.sdk.kotlin.services.datasync.model.SmbMountOptions? = builder.mountOptions
    /**
     * The user who can mount the share, has the permissions to access files and folders in the SMB share.
     */
    val user: kotlin.String? = builder.user

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.DescribeLocationSmbResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeLocationSmbResponse(")
        append("agentArns=$agentArns,")
        append("creationTime=$creationTime,")
        append("domain=$domain,")
        append("locationArn=$locationArn,")
        append("locationUri=$locationUri,")
        append("mountOptions=$mountOptions,")
        append("user=$user)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArns?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (locationUri?.hashCode() ?: 0)
        result = 31 * result + (mountOptions?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeLocationSmbResponse

        if (agentArns != other.agentArns) return false
        if (creationTime != other.creationTime) return false
        if (domain != other.domain) return false
        if (locationArn != other.locationArn) return false
        if (locationUri != other.locationUri) return false
        if (mountOptions != other.mountOptions) return false
        if (user != other.user) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.DescribeLocationSmbResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the source SMB file system location that is created.
         */
        var agentArns: List<String>? = null
        /**
         * The time that the SMB location was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Windows domain that the SMB server belongs to.
         */
        var domain: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the SMB location that was described.
         */
        var locationArn: kotlin.String? = null
        /**
         * The URL of the source SMB location that was described.
         */
        var locationUri: kotlin.String? = null
        /**
         * The mount options that are available for DataSync to use to access an SMB location.
         */
        var mountOptions: aws.sdk.kotlin.services.datasync.model.SmbMountOptions? = null
        /**
         * The user who can mount the share, has the permissions to access files and folders in the SMB share.
         */
        var user: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.DescribeLocationSmbResponse) : this() {
            this.agentArns = x.agentArns
            this.creationTime = x.creationTime
            this.domain = x.domain
            this.locationArn = x.locationArn
            this.locationUri = x.locationUri
            this.mountOptions = x.mountOptions
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.DescribeLocationSmbResponse = DescribeLocationSmbResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.SmbMountOptions] inside the given [block]
         */
        fun mountOptions(block: aws.sdk.kotlin.services.datasync.model.SmbMountOptions.Builder.() -> kotlin.Unit) {
            this.mountOptions = aws.sdk.kotlin.services.datasync.model.SmbMountOptions.invoke(block)
        }
    }
}
