// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * DescribeTaskExecutionResponse
 */
class DescribeTaskExecutionResponse private constructor(builder: Builder) {
    /**
     * The physical number of bytes transferred over the network.
     */
    val bytesTransferred: kotlin.Long = builder.bytesTransferred
    /**
     * The number of logical bytes written to the destination Amazon Web Services storage resource.
     */
    val bytesWritten: kotlin.Long = builder.bytesWritten
    /**
     * The estimated physical number of bytes that is to be transferred over the network.
     */
    val estimatedBytesToTransfer: kotlin.Long = builder.estimatedBytesToTransfer
    /**
     * The expected number of files that is to be transferred over the network. This value is calculated during the PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files to be transferred. It's calculated based on comparing the content of the source and destination locations and finding the delta that needs to be transferred.
     */
    val estimatedFilesToTransfer: kotlin.Long = builder.estimatedFilesToTransfer
    /**
     * A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: `"/folder1|/folder2"`
     */
    val excludes: List<FilterRule>? = builder.excludes
    /**
     * The actual number of files that was transferred over the network. This value is calculated and updated on an ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read from the source and sent over the network.
     *
     * If failures occur during a transfer, this value can be less than `EstimatedFilesToTransfer`. This value can also be greater than `EstimatedFilesTransferred` in some cases. This element is implementation-specific for some location types, so don't use it as an indicator for a correct file number or to monitor your task execution.
     */
    val filesTransferred: kotlin.Long = builder.filesTransferred
    /**
     * A list of filter rules that determines which files to include when running a task. The list should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: `"/folder1|/folder2"`
     */
    val includes: List<FilterRule>? = builder.includes
    /**
     * Represents the options that are available to control the behavior of a [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.
     *
     * A task has a set of default options associated with it. If you don't specify an option in [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html), the default value is used. You can override the defaults options on each task execution by specifying an overriding `Options` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
     */
    val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * The result of the task execution.
     */
    val result: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail? = builder.result
    /**
     * The time that the task execution was started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the task execution.
     *
     * For detailed information about task execution statuses, see Understanding Task Statuses in the *DataSync User Guide.*
     */
    val status: aws.sdk.kotlin.services.datasync.model.TaskExecutionStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the task execution that was described. `TaskExecutionArn` is hierarchical and includes `TaskArn` for the task that was executed.
     *
     * For example, a `TaskExecution` value with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b` executed the task with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2`.
     */
    val taskExecutionArn: kotlin.String? = builder.taskExecutionArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTaskExecutionResponse(")
        append("bytesTransferred=$bytesTransferred,")
        append("bytesWritten=$bytesWritten,")
        append("estimatedBytesToTransfer=$estimatedBytesToTransfer,")
        append("estimatedFilesToTransfer=$estimatedFilesToTransfer,")
        append("excludes=$excludes,")
        append("filesTransferred=$filesTransferred,")
        append("includes=$includes,")
        append("options=$options,")
        append("result=$result,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("taskExecutionArn=$taskExecutionArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytesTransferred.hashCode()
        result = 31 * result + (bytesWritten.hashCode())
        result = 31 * result + (estimatedBytesToTransfer.hashCode())
        result = 31 * result + (estimatedFilesToTransfer.hashCode())
        result = 31 * result + (excludes?.hashCode() ?: 0)
        result = 31 * result + (filesTransferred.hashCode())
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskExecutionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTaskExecutionResponse

        if (bytesTransferred != other.bytesTransferred) return false
        if (bytesWritten != other.bytesWritten) return false
        if (estimatedBytesToTransfer != other.estimatedBytesToTransfer) return false
        if (estimatedFilesToTransfer != other.estimatedFilesToTransfer) return false
        if (excludes != other.excludes) return false
        if (filesTransferred != other.filesTransferred) return false
        if (includes != other.includes) return false
        if (options != other.options) return false
        if (result != other.result) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (taskExecutionArn != other.taskExecutionArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The physical number of bytes transferred over the network.
         */
        var bytesTransferred: kotlin.Long = 0L
        /**
         * The number of logical bytes written to the destination Amazon Web Services storage resource.
         */
        var bytesWritten: kotlin.Long = 0L
        /**
         * The estimated physical number of bytes that is to be transferred over the network.
         */
        var estimatedBytesToTransfer: kotlin.Long = 0L
        /**
         * The expected number of files that is to be transferred over the network. This value is calculated during the PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files to be transferred. It's calculated based on comparing the content of the source and destination locations and finding the delta that needs to be transferred.
         */
        var estimatedFilesToTransfer: kotlin.Long = 0L
        /**
         * A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: `"/folder1|/folder2"`
         */
        var excludes: List<FilterRule>? = null
        /**
         * The actual number of files that was transferred over the network. This value is calculated and updated on an ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read from the source and sent over the network.
         *
         * If failures occur during a transfer, this value can be less than `EstimatedFilesToTransfer`. This value can also be greater than `EstimatedFilesTransferred` in some cases. This element is implementation-specific for some location types, so don't use it as an indicator for a correct file number or to monitor your task execution.
         */
        var filesTransferred: kotlin.Long = 0L
        /**
         * A list of filter rules that determines which files to include when running a task. The list should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: `"/folder1|/folder2"`
         */
        var includes: List<FilterRule>? = null
        /**
         * Represents the options that are available to control the behavior of a [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.
         *
         * A task has a set of default options associated with it. If you don't specify an option in [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html), the default value is used. You can override the defaults options on each task execution by specifying an overriding `Options` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
         */
        var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * The result of the task execution.
         */
        var result: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail? = null
        /**
         * The time that the task execution was started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the task execution.
         *
         * For detailed information about task execution statuses, see Understanding Task Statuses in the *DataSync User Guide.*
         */
        var status: aws.sdk.kotlin.services.datasync.model.TaskExecutionStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the task execution that was described. `TaskExecutionArn` is hierarchical and includes `TaskArn` for the task that was executed.
         *
         * For example, a `TaskExecution` value with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b` executed the task with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2`.
         */
        var taskExecutionArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse) : this() {
            this.bytesTransferred = x.bytesTransferred
            this.bytesWritten = x.bytesWritten
            this.estimatedBytesToTransfer = x.estimatedBytesToTransfer
            this.estimatedFilesToTransfer = x.estimatedFilesToTransfer
            this.excludes = x.excludes
            this.filesTransferred = x.filesTransferred
            this.includes = x.includes
            this.options = x.options
            this.result = x.result
            this.startTime = x.startTime
            this.status = x.status
            this.taskExecutionArn = x.taskExecutionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse = DescribeTaskExecutionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail] inside the given [block]
         */
        fun result(block: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail.Builder.() -> kotlin.Unit) {
            this.result = aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail.invoke(block)
        }
    }
}
