// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * The VPC endpoint, subnet, and security group that an agent uses to access IP addresses in a VPC (Virtual Private Cloud).
 */
class PrivateLinkConfig private constructor(builder: Builder) {
    /**
     * The private endpoint that is configured for an agent that has access to IP addresses in a [PrivateLink](https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html). An agent that is configured with this endpoint will not be accessible over the public internet.
     */
    val privateLinkEndpoint: kotlin.String? = builder.privateLinkEndpoint
    /**
     * The Amazon Resource Names (ARNs) of the security groups that are configured for the EC2 resource that hosts an agent activated in a VPC or an agent that has access to a VPC endpoint.
     */
    val securityGroupArns: List<String>? = builder.securityGroupArns
    /**
     * The Amazon Resource Names (ARNs) of the subnets that are configured for an agent activated in a VPC or an agent that has access to a VPC endpoint.
     */
    val subnetArns: List<String>? = builder.subnetArns
    /**
     * The ID of the VPC endpoint that is configured for an agent. An agent that is configured with a VPC endpoint will not be accessible over the public internet.
     */
    val vpcEndpointId: kotlin.String? = builder.vpcEndpointId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.PrivateLinkConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PrivateLinkConfig(")
        append("privateLinkEndpoint=$privateLinkEndpoint,")
        append("securityGroupArns=$securityGroupArns,")
        append("subnetArns=$subnetArns,")
        append("vpcEndpointId=$vpcEndpointId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = privateLinkEndpoint?.hashCode() ?: 0
        result = 31 * result + (securityGroupArns?.hashCode() ?: 0)
        result = 31 * result + (subnetArns?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PrivateLinkConfig

        if (privateLinkEndpoint != other.privateLinkEndpoint) return false
        if (securityGroupArns != other.securityGroupArns) return false
        if (subnetArns != other.subnetArns) return false
        if (vpcEndpointId != other.vpcEndpointId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.PrivateLinkConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The private endpoint that is configured for an agent that has access to IP addresses in a [PrivateLink](https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html). An agent that is configured with this endpoint will not be accessible over the public internet.
         */
        var privateLinkEndpoint: kotlin.String? = null
        /**
         * The Amazon Resource Names (ARNs) of the security groups that are configured for the EC2 resource that hosts an agent activated in a VPC or an agent that has access to a VPC endpoint.
         */
        var securityGroupArns: List<String>? = null
        /**
         * The Amazon Resource Names (ARNs) of the subnets that are configured for an agent activated in a VPC or an agent that has access to a VPC endpoint.
         */
        var subnetArns: List<String>? = null
        /**
         * The ID of the VPC endpoint that is configured for an agent. An agent that is configured with a VPC endpoint will not be accessible over the public internet.
         */
        var vpcEndpointId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.PrivateLinkConfig) : this() {
            this.privateLinkEndpoint = x.privateLinkEndpoint
            this.securityGroupArns = x.securityGroupArns
            this.subnetArns = x.subnetArns
            this.vpcEndpointId = x.vpcEndpointId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.PrivateLinkConfig = PrivateLinkConfig(this)
    }
}
