// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer privacy settings configured on the Hadoop Distributed File System (HDFS) cluster.
 */
class QopConfiguration private constructor(builder: Builder) {
    /**
     * The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your `dfs.data.transfer.protection` setting in the `hdfs-site.xml` file on your Hadoop cluster.
     */
    val dataTransferProtection: aws.sdk.kotlin.services.datasync.model.HdfsDataTransferProtection? = builder.dataTransferProtection
    /**
     * The RPC protection setting configured on the HDFS cluster. This setting corresponds to your `hadoop.rpc.protection` setting in your `core-site.xml` file on your Hadoop cluster.
     */
    val rpcProtection: aws.sdk.kotlin.services.datasync.model.HdfsRpcProtection? = builder.rpcProtection

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.QopConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QopConfiguration(")
        append("dataTransferProtection=$dataTransferProtection,")
        append("rpcProtection=$rpcProtection)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferProtection?.hashCode() ?: 0
        result = 31 * result + (rpcProtection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QopConfiguration

        if (dataTransferProtection != other.dataTransferProtection) return false
        if (rpcProtection != other.rpcProtection) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.QopConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your `dfs.data.transfer.protection` setting in the `hdfs-site.xml` file on your Hadoop cluster.
         */
        var dataTransferProtection: aws.sdk.kotlin.services.datasync.model.HdfsDataTransferProtection? = null
        /**
         * The RPC protection setting configured on the HDFS cluster. This setting corresponds to your `hadoop.rpc.protection` setting in your `core-site.xml` file on your Hadoop cluster.
         */
        var rpcProtection: aws.sdk.kotlin.services.datasync.model.HdfsRpcProtection? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.QopConfiguration) : this() {
            this.dataTransferProtection = x.dataTransferProtection
            this.rpcProtection = x.rpcProtection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.QopConfiguration = QopConfiguration(this)
    }
}
