// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



class UpdateLocationSmbRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.
     */
    val agentArns: List<String>? = builder.agentArns
    /**
     * The name of the Windows domain that the SMB server belongs to.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * The Amazon Resource Name (ARN) of the SMB location to update.
     */
    val locationArn: kotlin.String? = builder.locationArn
    /**
     * Specifies how DataSync can access a location using the SMB protocol.
     */
    val mountOptions: aws.sdk.kotlin.services.datasync.model.SmbMountOptions? = builder.mountOptions
    /**
     * The password of the user who can mount the share has the permissions to access files and folders in the SMB share.
     */
    val password: kotlin.String? = builder.password
    /**
     * The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.
     *
     * `Subdirectory` must be specified with forward slashes. For example, `/path/to/folder`.
     *
     * To transfer all the data in the folder that you specified, DataSync must have permissions to mount the SMB share and to access all the data in that share. To ensure this, do either of the following:
     * + Ensure that the user/password specified belongs to the user who can mount the share and who has the appropriate permissions for all of the files and directories that you want DataSync to access.
     * + Use credentials of a member of the Backup Operators group to mount the share.
     *
     * Doing either of these options enables the agent to access the data. For the agent to access directories, you must also enable all execute access.
     */
    val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * The user who can mount the share has the permissions to access files and folders in the SMB share.
     */
    val user: kotlin.String? = builder.user

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.UpdateLocationSmbRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLocationSmbRequest(")
        append("agentArns=$agentArns,")
        append("domain=$domain,")
        append("locationArn=$locationArn,")
        append("mountOptions=$mountOptions,")
        append("password=*** Sensitive Data Redacted ***,")
        append("subdirectory=$subdirectory,")
        append("user=$user)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArns?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (mountOptions?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateLocationSmbRequest

        if (agentArns != other.agentArns) return false
        if (domain != other.domain) return false
        if (locationArn != other.locationArn) return false
        if (mountOptions != other.mountOptions) return false
        if (password != other.password) return false
        if (subdirectory != other.subdirectory) return false
        if (user != other.user) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.UpdateLocationSmbRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.
         */
        var agentArns: List<String>? = null
        /**
         * The name of the Windows domain that the SMB server belongs to.
         */
        var domain: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the SMB location to update.
         */
        var locationArn: kotlin.String? = null
        /**
         * Specifies how DataSync can access a location using the SMB protocol.
         */
        var mountOptions: aws.sdk.kotlin.services.datasync.model.SmbMountOptions? = null
        /**
         * The password of the user who can mount the share has the permissions to access files and folders in the SMB share.
         */
        var password: kotlin.String? = null
        /**
         * The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.
         *
         * `Subdirectory` must be specified with forward slashes. For example, `/path/to/folder`.
         *
         * To transfer all the data in the folder that you specified, DataSync must have permissions to mount the SMB share and to access all the data in that share. To ensure this, do either of the following:
         * + Ensure that the user/password specified belongs to the user who can mount the share and who has the appropriate permissions for all of the files and directories that you want DataSync to access.
         * + Use credentials of a member of the Backup Operators group to mount the share.
         *
         * Doing either of these options enables the agent to access the data. For the agent to access directories, you must also enable all execute access.
         */
        var subdirectory: kotlin.String? = null
        /**
         * The user who can mount the share has the permissions to access files and folders in the SMB share.
         */
        var user: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.UpdateLocationSmbRequest) : this() {
            this.agentArns = x.agentArns
            this.domain = x.domain
            this.locationArn = x.locationArn
            this.mountOptions = x.mountOptions
            this.password = x.password
            this.subdirectory = x.subdirectory
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.UpdateLocationSmbRequest = UpdateLocationSmbRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.SmbMountOptions] inside the given [block]
         */
        fun mountOptions(block: aws.sdk.kotlin.services.datasync.model.SmbMountOptions.Builder.() -> kotlin.Unit) {
            this.mountOptions = aws.sdk.kotlin.services.datasync.model.SmbMountOptions.invoke(block)
        }
    }
}
